/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.resources.Resources;
import org.operamasks.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralMethodExpression
extends MethodExpression
implements Serializable {
    private static final long serialVersionUID = 4394283970441392163L;
    private String expr;
    private Class<?> expectedType;
    private Class<?>[] paramTypes;
    private transient Object result;

    public LiteralMethodExpression(String expr, Class<?> expectedType, Class<?>[] paramTypes) {
        this.expr = expr;
        this.expectedType = expectedType;
        this.paramTypes = paramTypes;
        this.result = LiteralMethodExpression.getResult(expr, expectedType);
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return new MethodInfo(this.expr, this.expectedType, (Class[])this.paramTypes);
    }

    public Object invoke(ELContext context, Object[] args) {
        if (this.result == null) {
            this.result = LiteralMethodExpression.getResult(this.expr, this.expectedType);
        }
        return this.result;
    }

    private static Object getResult(String expr, Class<?> expectedType) {
        if (expectedType == Void.TYPE) {
            throw new ELException(Resources._T("JSPRT_COERCE_ERROR", "java.lang.String", "void"));
        }
        if (expectedType == null || expectedType == Object.class) {
            return expr;
        }
        if (expectedType == String.class) {
            return expr;
        }
        return TypeCoercion.coerce(expr, expectedType);
    }

    public String getExpressionString() {
        return this.expr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralMethodExpression) {
            return this.expr.equals(((LiteralMethodExpression)obj).getExpressionString());
        }
        return false;
    }

    public int hashCode() {
        return this.expr.hashCode();
    }

    public boolean isLiteralText() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.expr);
        out.writeUTF(this.expectedType == null ? "" : this.expectedType.getName());
        if (this.paramTypes == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.paramTypes.length);
            for (Class<?> type : this.paramTypes) {
                out.writeUTF(type.getName());
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.expr = in.readUTF();
        String type = in.readUTF();
        this.expectedType = type.length() == 0 ? null : Utils.findClass(type);
        int len = in.readInt();
        if (len >= 0) {
            this.paramTypes = new Class[len];
            for (int i = 0; i < len; ++i) {
                type = in.readUTF();
                this.paramTypes[i] = Utils.findClass(type);
            }
        }
    }
}

