/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval;

import elite.lang.Closure;
import elite.lang.Decimal;
import elite.lang.Range;
import elite.lang.Rational;
import elite.lang.Seq;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import org.operamasks.el.eval.Coercible;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.GlobalScope;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.seq.ArraySeq;
import org.operamasks.el.eval.seq.IteratorSeq;
import org.operamasks.el.eval.seq.ListSeq;
import org.operamasks.el.eval.seq.PArraySeq;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeCoercion {
    private static Map<Class, Integer> typeMap = new IdentityHashMap<Class, Integer>();
    private static Map<Class, Class> primitives = new IdentityHashMap<Class, Class>();
    public static final int NULL_TYPE = 0;
    public static final int BOOLEAN_TYPE = 1;
    public static final int BYTE_TYPE = 2;
    public static final int CHAR_TYPE = 3;
    public static final int SHORT_TYPE = 4;
    public static final int INT_TYPE = 5;
    public static final int LONG_TYPE = 6;
    public static final int FLOAT_TYPE = 7;
    public static final int DOUBLE_TYPE = 8;
    public static final int DECIMAL_TYPE = 9;
    public static final int RATIONAL_TYPE = 10;
    public static final int BIG_INTEGER_TYPE = 11;
    public static final int BIG_DECIMAL_TYPE = 12;
    public static final int GENERIC_NUMBER_TYPE = 13;
    public static final int STRING_TYPE = 14;
    public static final int OBJECT_TYPE = 15;
    public static final int UNKNOWN_TYPE = 16;
    public static final int GUESSED_DISTANCE = 20;
    private static final int[][] DISTANCE;

    public static int typeof(Class<?> t) {
        Integer type = typeMap.get(t);
        if (type != null) {
            return type;
        }
        if (Number.class.isAssignableFrom(t)) {
            return 13;
        }
        return 16;
    }

    public static int typeof(Object o) {
        if (o == null) {
            return 0;
        }
        Integer type = typeMap.get(o.getClass());
        if (type != null) {
            return type;
        }
        if (o instanceof Number) {
            return 13;
        }
        return 16;
    }

    public static Class getBoxedType(Class t) {
        if (t.isPrimitive()) {
            return primitives.get(t);
        }
        return t;
    }

    public static String coerceToString(Object v) {
        if (v == null) {
            return "";
        }
        if (v instanceof String) {
            return (String)v;
        }
        if (v instanceof Range) {
            return v.toString();
        }
        if (v instanceof Collection) {
            StringBuilder buf = new StringBuilder();
            buf.append("[");
            Iterator i = ((Collection)v).iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                TypeCoercion.to_s(buf, v, i.next());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("]");
            return buf.toString();
        }
        if (v instanceof Map) {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            Iterator i = ((Map)v).entrySet().iterator();
            boolean hasNext = i.hasNext();
            while (hasNext) {
                Map.Entry e = i.next();
                TypeCoercion.to_s(buf, v, e.getKey());
                buf.append(":");
                TypeCoercion.to_s(buf, v, e.getValue());
                hasNext = i.hasNext();
                if (!hasNext) continue;
                buf.append(", ");
            }
            buf.append("}");
            return buf.toString();
        }
        if (v.getClass().isArray()) {
            int length = Array.getLength(v);
            StringBuilder buf = new StringBuilder();
            buf.append("(");
            for (int i = 0; i < length; ++i) {
                TypeCoercion.to_s(buf, v, Array.get(v, i));
                if (i >= length - 1) continue;
                buf.append(", ");
            }
            buf.append(")");
            return buf.toString();
        }
        return v.toString();
    }

    private static void to_s(StringBuilder buf, Object v, Object o) {
        if (o == v) {
            buf.append("(this object)");
        } else if (o instanceof String) {
            TypeCoercion.escape(buf, (String)o);
        } else {
            buf.append(TypeCoercion.coerceToString(o));
        }
    }

    public static String escape(String s) {
        StringBuilder buf = new StringBuilder();
        TypeCoercion.escape(buf, s);
        return buf.toString();
    }

    public static void escape(StringBuilder buf, String s) {
        boolean escaped = false;
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            String esc = TypeCoercion.escape(c);
            if (esc != null) {
                if (!escaped) {
                    buf.append('\"');
                    buf.append(s.substring(0, i));
                    escaped = true;
                }
                buf.append(esc);
                continue;
            }
            if (!escaped) continue;
            buf.append(c);
        }
        if (escaped) {
            buf.append('\"');
        } else {
            buf.append('\'');
            buf.append(s);
            buf.append('\'');
        }
    }

    public static String escape(char c) {
        switch (c) {
            case '\r': {
                return "\\r";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\\': {
                return "\\\\";
            }
            case '\'': {
                return "'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\u0000': 
            case '\u0001': 
            case '\u0002': 
            case '\u0003': 
            case '\u0004': 
            case '\u0005': 
            case '\u0006': 
            case '\u0007': {
                return "\\00" + Integer.toOctalString(c);
            }
            case '\u000b': 
            case '\u000e': 
            case '\u000f': 
            case '\u0010': 
            case '\u0011': 
            case '\u0012': 
            case '\u0013': 
            case '\u0014': 
            case '\u0015': 
            case '\u0016': 
            case '\u0017': 
            case '\u0018': 
            case '\u0019': 
            case '\u001a': 
            case '\u001b': 
            case '\u001c': 
            case '\u001d': 
            case '\u001e': 
            case '\u001f': {
                return "\\0" + Integer.toOctalString(c);
            }
        }
        return null;
    }

    public static Decimal coerceToDecimal(Object v) throws ELException {
        if (v == null) {
            return Decimal.ZERO;
        }
        if (v instanceof Decimal) {
            return (Decimal)v;
        }
        if (v instanceof BigDecimal) {
            return Decimal.valueOf((BigDecimal)v);
        }
        if (v instanceof BigInteger) {
            return Decimal.valueOf(new BigDecimal((BigInteger)v));
        }
        if (v instanceof Number) {
            return Decimal.valueOf(((Number)v).doubleValue());
        }
        if (v instanceof Character) {
            return Decimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Decimal.ZERO;
            }
            return Decimal.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Decimal.class);
        }
        throw TypeCoercion.coerceError(v, "Decimal");
    }

    public static Rational coerceToRational(Object v) {
        if (v == null) {
            return Rational.ZERO;
        }
        if (v instanceof Rational) {
            return (Rational)v;
        }
        if (v instanceof BigInteger) {
            return Rational.make((BigInteger)v, BigInteger.ONE);
        }
        if (v instanceof BigDecimal) {
            return Rational.valueOf((Number)((BigDecimal)v));
        }
        if (v instanceof Decimal) {
            return Rational.valueOf((Number)((Decimal)v));
        }
        if (v instanceof Double || v instanceof Float) {
            return Rational.valueOf((Number)((Number)v).doubleValue());
        }
        if (v instanceof Number) {
            return Rational.make(((Number)v).longValue(), 1L);
        }
        if (v instanceof Character) {
            return Rational.make((short)((Character)v).charValue(), 1L);
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Rational.ZERO;
            }
            return Rational.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Rational.class);
        }
        throw TypeCoercion.coerceError(v, "Rational");
    }

    public static BigDecimal coerceToBigDecimal(Object v) throws ELException {
        if (v == null) {
            return BigDecimal.valueOf(0L);
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)v);
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigDecimal();
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)v).doubleValue());
        }
        if (v instanceof Character) {
            return BigDecimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, BigDecimal.class);
        }
        throw TypeCoercion.coerceError(v, "BigDecimal");
    }

    public static BigDecimal coerceToBigDecimal(ELContext ctx, Object v) {
        MathContext mc;
        if (ctx == null || (mc = GlobalScope.getMathContext(ctx)) == null) {
            return TypeCoercion.coerceToBigDecimal(v);
        }
        if (v == null) {
            return BigDecimal.valueOf(0L);
        }
        if (v instanceof BigDecimal) {
            return (BigDecimal)v;
        }
        if (v instanceof BigInteger) {
            return new BigDecimal((BigInteger)v, mc);
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigDecimal(mc);
        }
        if (v instanceof Number) {
            return new BigDecimal(((Number)v).doubleValue(), mc);
        }
        if (v instanceof Character) {
            return BigDecimal.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigDecimal.valueOf(0L);
            }
            return new BigDecimal(s, mc);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, BigDecimal.class);
        }
        throw TypeCoercion.coerceError(v, "BigDecimal");
    }

    public static BigInteger coerceToBigInteger(Object v) throws ELException {
        if (v == null) {
            return BigInteger.valueOf(0L);
        }
        if (v instanceof BigInteger) {
            return (BigInteger)v;
        }
        if (v instanceof BigDecimal) {
            return ((BigDecimal)v).toBigInteger();
        }
        if (v instanceof Decimal) {
            return ((Decimal)v).toBigDecimal().toBigInteger();
        }
        if (v instanceof Rational) {
            return ((Rational)v).toBigInteger();
        }
        if (v instanceof Number) {
            return BigInteger.valueOf(((Number)v).longValue());
        }
        if (v instanceof Character) {
            return BigInteger.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return BigInteger.valueOf(0L);
            }
            return new BigInteger(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, BigInteger.class);
        }
        throw TypeCoercion.coerceError(v, "BigInteger");
    }

    public static Double coerceToDouble(Object v) throws ELException {
        if (v == null) {
            return 0.0;
        }
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof Number) {
            return ((Number)v).doubleValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0.0;
            }
            return Double.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Double.class);
        }
        throw TypeCoercion.coerceError(v, "Double");
    }

    public static Float coerceToFloat(Object v) throws ELException {
        if (v == null) {
            return Float.valueOf(0.0f);
        }
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof Number) {
            return Float.valueOf(((Number)v).floatValue());
        }
        if (v instanceof Character) {
            return Float.valueOf((short)((Character)v).charValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Float.valueOf(0.0f);
            }
            return Float.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Float.class);
        }
        throw TypeCoercion.coerceError(v, "Float");
    }

    public static Long coerceToLong(Object v) throws ELException {
        if (v == null) {
            return 0L;
        }
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof Number) {
            return ((Number)v).longValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0L;
            }
            return Long.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Long.class);
        }
        throw TypeCoercion.coerceError(v, "Long");
    }

    public static int coerceToInt(Object v) throws ELException {
        if (v == null) {
            return 0;
        }
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof Number) {
            return ((Number)v).intValue();
        }
        if (v instanceof Character) {
            return ((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return 0;
            }
            return Integer.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Integer.class);
        }
        throw TypeCoercion.coerceError(v, "Integer");
    }

    public static Integer coerceToInteger(Object v) throws ELException {
        return TypeCoercion.coerceToInt(v);
    }

    public static Short coerceToShort(Object v) throws ELException {
        if (v == null) {
            return (short)0;
        }
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof Number) {
            return ((Number)v).shortValue();
        }
        if (v instanceof Character) {
            return (short)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return (short)0;
            }
            return Short.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Short.class);
        }
        throw TypeCoercion.coerceError(v, "Long");
    }

    public static Byte coerceToByte(Object v) throws ELException {
        if (v == null) {
            return (byte)0;
        }
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof Number) {
            return ((Number)v).byteValue();
        }
        if (v instanceof Character) {
            return (byte)((Character)v).charValue();
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return (byte)0;
            }
            return Byte.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Byte.class);
        }
        throw TypeCoercion.coerceError(v, "Byte");
    }

    public static Character coerceToCharacter(Object v) throws ELException {
        if (v == null) {
            return Character.valueOf('\u0000');
        }
        if (v instanceof Character) {
            return (Character)v;
        }
        if (v instanceof Number) {
            return Character.valueOf((char)((Number)v).shortValue());
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Character.valueOf('\u0000');
            }
            return Character.valueOf(s.charAt(0));
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Character.class);
        }
        throw TypeCoercion.coerceError(v, "Character");
    }

    public static Boolean coerceToBoolean(Object v) throws ELException {
        if (v == null) {
            return Boolean.FALSE;
        }
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return Boolean.FALSE;
            }
            assert ("true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s));
            return Boolean.valueOf(s);
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, Boolean.class);
        }
        throw TypeCoercion.coerceError(v, "Boolean");
    }

    public static <E extends Enum<E>> Enum<E> coerceToEnum(Object v, Class<E> t) {
        if (v == null) {
            return null;
        }
        if (t.isInstance(v)) {
            return (Enum)v;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.length() == 0) {
                return null;
            }
            return Enum.valueOf(t, s);
        }
        if (v instanceof Coercible) {
            return (Enum)TypeCoercion.selfCoerce((Coercible)v, t);
        }
        throw TypeCoercion.coerceError(v, t.getName());
    }

    public static Seq coerceToSeq(Object v) {
        if (v == null) {
            return null;
        }
        if (v instanceof Seq) {
            return (Seq)v;
        }
        if (v instanceof List) {
            return ListSeq.make((List)v);
        }
        if (v instanceof Iterable) {
            return IteratorSeq.make(((Iterable)v).iterator());
        }
        if (v instanceof Object[]) {
            return ArraySeq.make((Object[])v);
        }
        if (v.getClass().isArray()) {
            return PArraySeq.make(v);
        }
        throw TypeCoercion.coerceError(v, "Seq");
    }

    public static boolean canCoerceToSeq(Object v) {
        return v != null && TypeCoercion.canCoerceToSeq(v.getClass());
    }

    public static boolean canCoerceToSeq(Class<?> t) {
        return t.isArray() || Iterable.class.isAssignableFrom(t);
    }

    private static Object coerceToAny(ELContext ctx, Object v, Class<?> t) throws ELException {
        Object proxy;
        if (v == null) {
            return null;
        }
        if (v instanceof Coercible) {
            return TypeCoercion.selfCoerce((Coercible)v, t);
        }
        if (t.isEnum()) {
            return TypeCoercion.coerceToEnum(v, t);
        }
        if (t == Seq.class || t == List.class) {
            return TypeCoercion.coerceToSeq(v);
        }
        if (v instanceof String) {
            String s = (String)v;
            PropertyEditor ed = PropertyEditorManager.findEditor(t);
            if (ed == null) {
                if (s.length() == 0) {
                    return null;
                }
                throw TypeCoercion.coerceError(v, t.getName());
            }
            try {
                ed.setAsText(s);
                return ed.getValue();
            }
            catch (IllegalArgumentException ex) {
                if (s.length() == 0) {
                    return null;
                }
                throw ex;
            }
        }
        if (v instanceof ClosureObject && t.isInstance(proxy = ((ClosureObject)v).get_proxy())) {
            return proxy;
        }
        if (t.isInterface() && v instanceof Closure && ((Closure)((Object)v)).isProcedure()) {
            final Closure proc = (Closure)((Object)v);
            final ELContext elctx = ctx != null ? ctx : ELEngine.getCurrentELContext();
            return Proxy.newProxyInstance(t.getClassLoader(), new Class[]{t}, new InvocationHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result;
                    if (args == null) {
                        args = ELUtils.NO_VALUES;
                    }
                    if (method.getDeclaringClass() == Object.class) {
                        return method.invoke((Object)proc, args);
                    }
                    EvaluationContext context = proc.getContext(elctx);
                    Class<?> type = method.getReturnType();
                    if (context != null) {
                        context.setVariable("$method", new LiteralClosure(method.getName()));
                        try {
                            result = proc.call(elctx, args);
                        }
                        finally {
                            context.setVariable("$method", null);
                        }
                    } else {
                        result = proc.call(elctx, args);
                    }
                    return type == Void.TYPE ? null : TypeCoercion.coerce(elctx, result, type);
                }
            });
        }
        throw TypeCoercion.coerceError(v, t.getName());
    }

    public static Object coerce(Object v, Class<?> t) throws ELException {
        return TypeCoercion.coerce(null, v, t);
    }

    public static Object coerce(ELContext ctx, Object v, Class<?> t) throws ELException {
        if (v == null && !t.isPrimitive()) {
            return null;
        }
        if (t.isInstance(v)) {
            return v;
        }
        switch (TypeCoercion.typeof(t)) {
            case 14: {
                return TypeCoercion.coerceToString(v);
            }
            case 12: {
                return TypeCoercion.coerceToBigDecimal(ctx, v);
            }
            case 11: {
                return TypeCoercion.coerceToBigInteger(v);
            }
            case 9: {
                return TypeCoercion.coerceToDecimal(v);
            }
            case 10: {
                return TypeCoercion.coerceToRational(v);
            }
            case 8: {
                return TypeCoercion.coerceToDouble(v);
            }
            case 7: {
                return TypeCoercion.coerceToFloat(v);
            }
            case 6: {
                return TypeCoercion.coerceToLong(v);
            }
            case 5: {
                return TypeCoercion.coerceToInteger(v);
            }
            case 4: {
                return TypeCoercion.coerceToShort(v);
            }
            case 2: {
                return TypeCoercion.coerceToByte(v);
            }
            case 3: {
                return TypeCoercion.coerceToCharacter(v);
            }
            case 1: {
                return TypeCoercion.coerceToBoolean(v);
            }
        }
        return TypeCoercion.coerceToAny(ctx, v, t);
    }

    private static <T> T selfCoerce(Coercible value, Class<T> type) {
        Object result;
        if (type.isPrimitive()) {
            type = primitives.get(type);
        }
        if ((result = value.coerce(type)) != null) {
            return type.cast(result);
        }
        throw TypeCoercion.coerceError(value, type.getName());
    }

    public static int distanceof(Class<?> s, Class<?> t) {
        int tk;
        if (s == t) {
            return 0;
        }
        int sk = TypeCoercion.typeof(s);
        int d = DISTANCE[sk][tk = TypeCoercion.typeof(t)];
        if (d != -1) {
            return d;
        }
        if (t.isAssignableFrom(s)) {
            Class<?> u = s;
            if (t.isInterface()) {
                d = 0;
                do {
                    int f;
                    if ((f = TypeCoercion.distanceof_interface(u, t)) != -1) {
                        return d + f;
                    }
                    ++d;
                } while ((u = u.getSuperclass()) != null);
            } else {
                d = 0;
                while ((u = u.getSuperclass()) != null) {
                    ++d;
                    if (u != t) continue;
                    return d;
                }
            }
        }
        if (Coercible.class.isAssignableFrom(s)) {
            return 20;
        }
        if (sk == 14 || tk == 14) {
            return 21;
        }
        if (t.isInterface() && Closure.class.isAssignableFrom(s)) {
            return 20;
        }
        if ((t == Seq.class || t == List.class) && (s.isArray() || Iterable.class.isAssignableFrom(s))) {
            return 20;
        }
        return -1;
    }

    private static int distanceof_interface(Class<?> s, Class<?> t) {
        if (s == t) {
            return 0;
        }
        for (Class<?> ifs : s.getInterfaces()) {
            int d = TypeCoercion.distanceof_interface(ifs, t);
            if (d == -1) continue;
            return d + 1;
        }
        return -1;
    }

    private static final void put(int t1, int t2, int d) {
        TypeCoercion.DISTANCE[t1][t2] = d;
    }

    private static ELException coerceError(Object v, String t) {
        return new ELException(Resources._T("JSPRT_COERCE_ERROR", v.getClass().getName(), t));
    }

    private TypeCoercion() {
    }

    static {
        typeMap.put(Boolean.TYPE, 1);
        typeMap.put(Boolean.class, 1);
        typeMap.put(Byte.TYPE, 2);
        typeMap.put(Byte.class, 2);
        typeMap.put(Character.TYPE, 3);
        typeMap.put(Character.class, 3);
        typeMap.put(Short.TYPE, 4);
        typeMap.put(Short.class, 4);
        typeMap.put(Integer.TYPE, 5);
        typeMap.put(Integer.class, 5);
        typeMap.put(Long.TYPE, 6);
        typeMap.put(Long.class, 6);
        typeMap.put(Float.TYPE, 7);
        typeMap.put(Float.class, 7);
        typeMap.put(Double.TYPE, 8);
        typeMap.put(Double.class, 8);
        typeMap.put(Decimal.class, 9);
        typeMap.put(Rational.class, 10);
        typeMap.put(BigInteger.class, 11);
        typeMap.put(BigDecimal.class, 12);
        typeMap.put(Number.class, 13);
        typeMap.put(String.class, 14);
        typeMap.put(Object.class, 15);
        primitives.put(Void.TYPE, Void.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        DISTANCE = new int[17][17];
        for (int i = 0; i < DISTANCE.length; ++i) {
            Arrays.fill(DISTANCE[i], -1);
        }
        TypeCoercion.put(2, 2, 0);
        TypeCoercion.put(2, 4, 1);
        TypeCoercion.put(2, 3, 2);
        TypeCoercion.put(2, 5, 3);
        TypeCoercion.put(2, 6, 4);
        TypeCoercion.put(2, 7, 5);
        TypeCoercion.put(2, 8, 6);
        TypeCoercion.put(2, 9, 7);
        TypeCoercion.put(2, 10, 8);
        TypeCoercion.put(2, 11, 9);
        TypeCoercion.put(2, 12, 10);
        TypeCoercion.put(2, 13, 11);
        TypeCoercion.put(2, 15, 12);
        TypeCoercion.put(2, 14, 13);
        TypeCoercion.put(4, 4, 0);
        TypeCoercion.put(4, 3, 1);
        TypeCoercion.put(4, 5, 2);
        TypeCoercion.put(4, 6, 3);
        TypeCoercion.put(4, 7, 4);
        TypeCoercion.put(4, 8, 5);
        TypeCoercion.put(4, 9, 6);
        TypeCoercion.put(4, 10, 7);
        TypeCoercion.put(4, 11, 8);
        TypeCoercion.put(4, 12, 9);
        TypeCoercion.put(4, 13, 10);
        TypeCoercion.put(4, 15, 11);
        TypeCoercion.put(4, 14, 12);
        TypeCoercion.put(4, 2, 13);
        TypeCoercion.put(5, 5, 0);
        TypeCoercion.put(5, 6, 1);
        TypeCoercion.put(5, 7, 2);
        TypeCoercion.put(5, 8, 3);
        TypeCoercion.put(5, 9, 4);
        TypeCoercion.put(5, 10, 5);
        TypeCoercion.put(5, 11, 6);
        TypeCoercion.put(5, 12, 7);
        TypeCoercion.put(5, 13, 8);
        TypeCoercion.put(5, 15, 9);
        TypeCoercion.put(5, 14, 10);
        TypeCoercion.put(5, 4, 11);
        TypeCoercion.put(5, 3, 12);
        TypeCoercion.put(5, 2, 13);
        TypeCoercion.put(6, 6, 0);
        TypeCoercion.put(6, 7, 1);
        TypeCoercion.put(6, 8, 2);
        TypeCoercion.put(6, 9, 3);
        TypeCoercion.put(6, 10, 4);
        TypeCoercion.put(6, 11, 5);
        TypeCoercion.put(6, 12, 6);
        TypeCoercion.put(6, 13, 7);
        TypeCoercion.put(6, 15, 8);
        TypeCoercion.put(6, 14, 9);
        TypeCoercion.put(6, 5, 10);
        TypeCoercion.put(6, 4, 11);
        TypeCoercion.put(6, 3, 12);
        TypeCoercion.put(6, 2, 13);
        TypeCoercion.put(7, 7, 0);
        TypeCoercion.put(7, 8, 1);
        TypeCoercion.put(7, 12, 2);
        TypeCoercion.put(7, 9, 3);
        TypeCoercion.put(7, 10, 4);
        TypeCoercion.put(7, 11, 5);
        TypeCoercion.put(7, 13, 6);
        TypeCoercion.put(7, 15, 7);
        TypeCoercion.put(7, 14, 8);
        TypeCoercion.put(7, 6, 9);
        TypeCoercion.put(7, 5, 10);
        TypeCoercion.put(7, 4, 11);
        TypeCoercion.put(7, 3, 12);
        TypeCoercion.put(7, 2, 13);
        TypeCoercion.put(8, 8, 0);
        TypeCoercion.put(8, 12, 1);
        TypeCoercion.put(8, 9, 2);
        TypeCoercion.put(8, 10, 3);
        TypeCoercion.put(8, 7, 4);
        TypeCoercion.put(8, 11, 5);
        TypeCoercion.put(8, 13, 6);
        TypeCoercion.put(8, 15, 7);
        TypeCoercion.put(8, 14, 8);
        TypeCoercion.put(8, 6, 9);
        TypeCoercion.put(8, 5, 10);
        TypeCoercion.put(8, 4, 11);
        TypeCoercion.put(8, 3, 12);
        TypeCoercion.put(8, 2, 13);
        TypeCoercion.put(9, 9, 0);
        TypeCoercion.put(9, 12, 1);
        TypeCoercion.put(9, 10, 2);
        TypeCoercion.put(9, 8, 3);
        TypeCoercion.put(9, 7, 4);
        TypeCoercion.put(9, 13, 5);
        TypeCoercion.put(9, 15, 6);
        TypeCoercion.put(9, 14, 7);
        TypeCoercion.put(9, 11, 8);
        TypeCoercion.put(9, 6, 9);
        TypeCoercion.put(9, 5, 10);
        TypeCoercion.put(9, 4, 11);
        TypeCoercion.put(9, 3, 12);
        TypeCoercion.put(9, 2, 13);
        TypeCoercion.put(10, 10, 0);
        TypeCoercion.put(10, 12, 1);
        TypeCoercion.put(10, 9, 2);
        TypeCoercion.put(10, 8, 3);
        TypeCoercion.put(10, 7, 4);
        TypeCoercion.put(10, 13, 5);
        TypeCoercion.put(10, 15, 6);
        TypeCoercion.put(10, 14, 7);
        TypeCoercion.put(10, 11, 8);
        TypeCoercion.put(10, 6, 9);
        TypeCoercion.put(10, 5, 10);
        TypeCoercion.put(10, 4, 11);
        TypeCoercion.put(10, 3, 12);
        TypeCoercion.put(10, 2, 13);
        TypeCoercion.put(11, 11, 0);
        TypeCoercion.put(11, 10, 1);
        TypeCoercion.put(11, 12, 2);
        TypeCoercion.put(11, 9, 3);
        TypeCoercion.put(11, 8, 4);
        TypeCoercion.put(11, 7, 5);
        TypeCoercion.put(11, 13, 6);
        TypeCoercion.put(11, 15, 7);
        TypeCoercion.put(11, 14, 8);
        TypeCoercion.put(11, 6, 9);
        TypeCoercion.put(11, 5, 10);
        TypeCoercion.put(11, 4, 11);
        TypeCoercion.put(11, 3, 12);
        TypeCoercion.put(11, 2, 13);
        TypeCoercion.put(12, 12, 0);
        TypeCoercion.put(12, 9, 1);
        TypeCoercion.put(12, 10, 2);
        TypeCoercion.put(12, 8, 3);
        TypeCoercion.put(12, 7, 4);
        TypeCoercion.put(12, 13, 5);
        TypeCoercion.put(12, 15, 6);
        TypeCoercion.put(12, 14, 7);
        TypeCoercion.put(12, 11, 8);
        TypeCoercion.put(12, 6, 9);
        TypeCoercion.put(12, 5, 10);
        TypeCoercion.put(12, 4, 11);
        TypeCoercion.put(12, 3, 12);
        TypeCoercion.put(12, 2, 13);
        TypeCoercion.put(13, 13, 0);
        TypeCoercion.put(13, 15, 1);
        TypeCoercion.put(13, 12, 2);
        TypeCoercion.put(13, 9, 3);
        TypeCoercion.put(13, 10, 4);
        TypeCoercion.put(13, 11, 5);
        TypeCoercion.put(13, 8, 6);
        TypeCoercion.put(13, 7, 7);
        TypeCoercion.put(13, 6, 8);
        TypeCoercion.put(13, 5, 9);
        TypeCoercion.put(13, 4, 10);
        TypeCoercion.put(13, 3, 12);
        TypeCoercion.put(13, 2, 13);
        TypeCoercion.put(13, 14, 14);
        TypeCoercion.put(14, 14, 0);
        TypeCoercion.put(14, 3, 1);
        TypeCoercion.put(14, 15, 2);
        TypeCoercion.put(14, 12, 3);
        TypeCoercion.put(14, 11, 4);
        TypeCoercion.put(14, 9, 5);
        TypeCoercion.put(14, 10, 6);
        TypeCoercion.put(14, 8, 7);
        TypeCoercion.put(14, 7, 8);
        TypeCoercion.put(14, 6, 9);
        TypeCoercion.put(14, 5, 10);
        TypeCoercion.put(14, 4, 11);
        TypeCoercion.put(14, 2, 12);
        TypeCoercion.put(14, 1, 13);
        TypeCoercion.put(3, 3, 0);
        TypeCoercion.put(3, 4, 1);
        TypeCoercion.put(3, 5, 2);
        TypeCoercion.put(3, 6, 4);
        TypeCoercion.put(3, 14, 5);
        TypeCoercion.put(3, 2, 6);
        TypeCoercion.put(3, 7, 7);
        TypeCoercion.put(3, 8, 8);
        TypeCoercion.put(3, 11, 9);
        TypeCoercion.put(3, 9, 10);
        TypeCoercion.put(3, 10, 11);
        TypeCoercion.put(3, 12, 12);
        TypeCoercion.put(3, 15, 13);
        TypeCoercion.put(1, 1, 0);
        TypeCoercion.put(1, 14, 1);
        TypeCoercion.put(1, 15, 2);
        TypeCoercion.put(16, 16, -1);
    }
}

