/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.io.IOException;
import java.io.ObjectOutputStream;
import javax.el.ELContext;
import javax.el.FunctionMapper;
import javax.el.MethodInfo;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.AnnotatedClosure;
import org.operamasks.el.parser.ELNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvalClosure
extends AnnotatedClosure {
    protected final ELNode node;
    private FunctionMapper fm;
    private VariableMapper vm;
    protected transient EvaluationContext context;
    private static final long serialVersionUID = -7013242346088674319L;

    public EvalClosure(EvaluationContext context, ELNode node) {
        this.context = context;
        this.node = node;
        this.fm = context.getFunctionMapper();
        this.vm = null;
    }

    @Override
    public EvaluationContext getContext() {
        return this.context;
    }

    @Override
    public EvaluationContext getContext(ELContext elctx) {
        if (this.context == null) {
            if (elctx == null) {
                elctx = ELEngine.getCurrentELContext();
            }
            this.context = new EvaluationContext(elctx, this.fm, this.vm);
        } else if (elctx != null) {
            this.context.setELContext(elctx);
        }
        return this.context;
    }

    @Override
    public void _setenv(ELContext elctx, VariableMapper env) {
        this.context = this.getContext(elctx).pushContext(env);
    }

    public Object getValue(ELContext elctx) {
        return this.node.getValue(this.getContext(elctx));
    }

    public void setValue(ELContext elctx, Object value) {
        this.node.setValue(this.getContext(elctx), value);
    }

    public boolean isReadOnly(ELContext elctx) {
        return this.node.isReadOnly(this.getContext(elctx));
    }

    public Class<?> getType(ELContext elctx) {
        return this.node.getType(this.getContext(elctx));
    }

    @Override
    public int arity(ELContext elctx) {
        if (this.node instanceof ELNode.LAMBDA) {
            return ((ELNode.LAMBDA)this.node).vars.length;
        }
        MethodInfo info = this.node.getMethodInfo(this.getContext(elctx));
        if (info != null && info.getParamTypes() != null) {
            return info.getParamTypes().length;
        }
        return -1;
    }

    @Override
    public MethodInfo getMethodInfo(ELContext elctx) {
        return this.node.getMethodInfo(this.getContext(elctx));
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        return this.node.invoke(this.getContext(elctx), args);
    }

    public Class<?> getExpectedType() {
        return Object.class;
    }

    public String getExpressionString() {
        return null;
    }

    public boolean isLiteralText() {
        return this.node instanceof ELNode.LITERAL;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return System.identityHashCode((Object)this);
    }

    public String toString() {
        if (this.node instanceof ELNode.LAMBDA) {
            String name = ((ELNode.LAMBDA)this.node).name;
            return name == null ? "#<procedure>" : "#<procedure:" + name + ">";
        }
        if (this.node instanceof ELNode.IDENT) {
            return "#<closure:" + ((ELNode.IDENT)this.node).id + ">";
        }
        return "#<closure>";
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.context != null) {
            VariableMapperBuilder vmb = new VariableMapperBuilder(this.context);
            this.node.applyVariableMapper(vmb);
            this.vm = vmb.getVariableMapper();
        }
        out.defaultWriteObject();
    }

    static class VariableMapperBuilder
    extends VariableMapper {
        private EvaluationContext source;
        private VariableMapper target;

        VariableMapperBuilder(EvaluationContext source) {
            this.source = source;
        }

        public ValueExpression resolveVariable(String name) {
            ValueExpression value = this.source.resolveVariable(name);
            if (value != null) {
                if (this.target == null) {
                    this.target = new VariableMapperImpl();
                }
                this.target.setVariable(name, value);
            }
            return value;
        }

        public ValueExpression setVariable(String name, ValueExpression value) {
            throw new IllegalStateException();
        }

        VariableMapper getVariableMapper() {
            return this.target;
        }
    }
}

