/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.closure.AbstractClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldClosure
extends AbstractClosure {
    private final Field field;

    public FieldClosure(Field field) {
        this.field = field;
    }

    @Override
    public Object getValue(ELContext elctx) {
        try {
            return this.field.get(null);
        }
        catch (Exception ex) {
            throw new EvaluationException(elctx, ex);
        }
    }

    @Override
    public void setValue(ELContext elctx, Object value) {
        if (Modifier.isFinal(this.field.getModifiers())) {
            throw new PropertyNotWritableException(this.field.getName());
        }
        try {
            this.field.set(null, value);
        }
        catch (Exception ex) {
            throw new EvaluationException(elctx, ex);
        }
    }

    @Override
    public Class<?> getType(ELContext elctx) {
        return this.field.getType();
    }

    @Override
    public boolean isReadOnly(ELContext elctx) {
        return Modifier.isFinal(this.field.getModifiers());
    }

    @Override
    public Object invoke(ELContext elctx, Closure[] args) {
        try {
            return ELEngine.invokeTarget(elctx, this.field.get(null), args);
        }
        catch (IllegalAccessException ex) {
            throw new EvaluationException(elctx, ex);
        }
    }
}

