/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.closure;

import elite.lang.Closure;
import java.lang.reflect.Array;
import javax.el.ELContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELUtils;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.DelegatingClosure;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedClosure
extends DelegatingClosure {
    TypedClosure(Closure delegate) {
        super(delegate);
    }

    static Object typecast(ELContext elctx, Class<?> type, Object value) {
        if (type == Void.TYPE) {
            return null;
        }
        if (value == null) {
            if (!type.isPrimitive()) {
                return null;
            }
        } else if (type == Array.class && value.getClass().isArray()) {
            return value;
        }
        try {
            return TypeCoercion.coerce(elctx, value, type);
        }
        catch (Exception ex) {
            throw new EvaluationException(elctx, ex);
        }
    }

    static Object typecast(ELContext elctx, ClassDefinition type, Object value) {
        if (type.isInstance(elctx, value)) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof ClosureObject) {
            Object result = ((ClosureObject)value).invokeSpecial(elctx, "__coerce__", new Closure[]{type});
            if (result != ELUtils.NO_RESULT) {
                return result;
            }
        } else {
            MethodClosure method = MethodResolver.getInstance(elctx).resolveMethod(value.getClass(), "__coerce__");
            if (method != null) {
                return method.invoke(elctx, value, new Closure[]{type});
            }
        }
        String name = value instanceof ClosureObject ? ((ClosureObject)value).get_class().getName() : value.getClass().getName();
        throw new EvaluationException(elctx, Resources._T("JSPRT_COERCE_ERROR", name, type.getName()));
    }

    public static Object typecast(EvaluationContext ctx, String typename, Object value) {
        if (typename == null) {
            return value;
        }
        Object type = ELEngine.resolveClass(ctx, typename);
        if (type instanceof ClassDefinition) {
            return TypedClosure.typecast(ctx.getELContext(), (ClassDefinition)type, value);
        }
        return TypedClosure.typecast(ctx.getELContext(), (Class)type, value);
    }

    public static boolean typecheck(EvaluationContext ctx, String typename, Object value) {
        if (typename == null) {
            return true;
        }
        if (value == null) {
            return false;
        }
        Object type = ELEngine.resolveClass(ctx, typename);
        if (type instanceof ClassDefinition) {
            ClassDefinition cls = (ClassDefinition)type;
            return cls.isInstance(ctx.getELContext(), value);
        }
        if (type == Array.class) {
            return value.getClass().isArray();
        }
        return TypeCoercion.getBoxedType((Class)type).isInstance(value);
    }

    public static Closure make(EvaluationContext ctx, String typename, Closure closure) {
        Object type;
        if (typename == null) {
            return closure;
        }
        if (closure instanceof TypedClosure) {
            closure = ((TypedClosure)closure).getDelegate();
        }
        if ((type = ELEngine.resolveClass(ctx, typename)) instanceof ClassDefinition) {
            return new ClosureTypedClosure(closure, (ClassDefinition)type);
        }
        return new JavaTypedClosure(closure, (Class)type);
    }

    public static Closure make(EvaluationContext ctx, String typename, Object value, boolean readonly) {
        if (value instanceof Closure && !(value instanceof ClosureObject)) {
            return TypedClosure.make(ctx, typename, (Closure)((Object)value));
        }
        if (typename == null) {
            return new LiteralClosure(value, readonly);
        }
        Object type = ELEngine.resolveClass(ctx, typename);
        if (type instanceof ClassDefinition) {
            ClassDefinition cls = (ClassDefinition)type;
            Object newval = TypedClosure.typecast(ctx.getELContext(), cls, value);
            LiteralClosure closure = new LiteralClosure(newval, readonly);
            return new ClosureTypedClosure(closure, cls);
        }
        Class cls = (Class)type;
        Object newval = TypedClosure.typecast(ctx.getELContext(), cls, value);
        LiteralClosure closure = new LiteralClosure(newval, readonly);
        return new JavaTypedClosure(closure, cls);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClosureTypedClosure
    extends DelegatingClosure {
        private final ClassDefinition type;

        ClosureTypedClosure(Closure delegate, ClassDefinition type) {
            super(delegate);
            this.type = type;
        }

        @Override
        public Object getValue(ELContext elctx) {
            return TypedClosure.typecast(elctx, this.type, this.delegate.getValue(elctx));
        }

        @Override
        public void setValue(ELContext elctx, Object value) {
            this.delegate.setValue(elctx, TypedClosure.typecast(elctx, this.type, value));
        }

        @Override
        public Class<?> getType(ELContext elctx) {
            return Object.class;
        }

        @Override
        public Class<?> getExpectedType() {
            return Object.class;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ClosureTypedClosure) {
                ClosureTypedClosure other = (ClosureTypedClosure)((Object)obj);
                return this.delegate.equals((Object)other.delegate) && this.type.equals(other.type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode() ^ this.type.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class JavaTypedClosure
    extends TypedClosure {
        private final Class<?> type;

        JavaTypedClosure(Closure delegate, Class<?> type) {
            super(delegate);
            this.type = type;
        }

        @Override
        public Object getValue(ELContext elctx) {
            return JavaTypedClosure.typecast(elctx, this.type, this.delegate.getValue(elctx));
        }

        @Override
        public void setValue(ELContext elctx, Object value) {
            this.delegate.setValue(elctx, JavaTypedClosure.typecast(elctx, this.type, value));
        }

        @Override
        public Class<?> getType(ELContext elctx) {
            return this.type;
        }

        @Override
        public Class<?> getExpectedType() {
            return this.type;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof JavaTypedClosure) {
                JavaTypedClosure other = (JavaTypedClosure)((Object)obj);
                return this.delegate.equals((Object)other.delegate) && this.type.equals(other.type);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode() ^ this.type.hashCode();
        }
    }
}

