/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.seq;

import elite.lang.Seq;
import java.util.RandomAccess;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.seq.AbstractSeq;
import org.operamasks.el.eval.seq.Cons;

public class ArraySeq
extends AbstractSeq
implements RandomAccess {
    private final Object[] value;
    private final Class type;
    private final int offset;
    private final int count;

    private ArraySeq(Object[] value, int offset, int count) {
        this.value = value;
        this.type = value.getClass().getComponentType();
        this.offset = offset;
        this.count = count;
    }

    public static Seq make(Object[] value) {
        return ArraySeq.make(value, 0, value.length);
    }

    public static Seq make(Object[] value, int offset, int count) {
        if (count > 0) {
            return new ArraySeq(value, offset, count);
        }
        return Cons.nil();
    }

    public Object get() {
        return this.value[this.offset];
    }

    public Object set(Object x) {
        Object old = this.value[this.offset];
        this.value[this.offset] = TypeCoercion.coerce(x, this.type);
        return old;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        return this.value[this.offset + index];
    }

    public Object set(int index, Object x) {
        if (index < 0 || index >= this.count) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        Object old = this.value[this.offset + index];
        this.value[this.offset + index] = TypeCoercion.coerce(x, this.type);
        return old;
    }

    public Seq tail() {
        return ArraySeq.make(this.value, this.offset + 1, this.count - 1);
    }

    public Seq last() {
        if (this.count == 1) {
            return this;
        }
        return ArraySeq.make(this.value, this.offset + this.count - 1, 1);
    }

    public int size() {
        return this.count;
    }
}

