/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.eval.seq;

import elite.lang.Seq;
import java.util.Collection;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.seq.AbstractSeq;

public class Cons
extends AbstractSeq
implements Cloneable {
    protected Object head;
    protected Seq tail;

    public Cons() {
        this(null, null);
    }

    public Cons(Object head, Seq tail) {
        this.head = head;
        this.tail = tail;
    }

    public static Cons nil() {
        return new Cons();
    }

    public static Cons make(Object x) {
        return new Cons(x, Cons.nil());
    }

    public static Cons make(Object x1, Object x2) {
        return new Cons(x1, new Cons(x2, Cons.nil()));
    }

    public static Cons make(Object x1, Object x2, Object x3) {
        return new Cons(x1, new Cons(x2, new Cons(x3, Cons.nil())));
    }

    public static Cons make(Object ... args) {
        Cons ret = Cons.nil();
        int i = args.length;
        while (--i >= 0) {
            ret = new Cons(args[i], ret);
        }
        return ret;
    }

    public Object get() {
        return this.head;
    }

    public Object set(Object x) {
        Object old = this.head;
        this.head = x;
        return old;
    }

    public Seq tail() {
        return this.tail;
    }

    public void set_tail(Seq t) {
        this.tail = t;
    }

    public boolean isEmpty() {
        return this.tail == null;
    }

    public int size() {
        Cons l = this;
        int len = 0;
        while (l.tail != null) {
            if (l.tail instanceof Cons) {
                l = (Cons)l.tail;
                ++len;
                continue;
            }
            len += l.tail.size();
            break;
        }
        return len;
    }

    public boolean add(Object x) {
        Cons l = this;
        while (l.tail != null && l.tail instanceof Cons) {
            l = (Cons)l.tail;
        }
        if (l.tail == null) {
            l.head = x;
            l.tail = Cons.nil();
            return true;
        }
        return l.tail.add(x);
    }

    public void add(int index, Object x) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        if (index == 0) {
            if (this.tail == null) {
                this.head = x;
                this.tail = Cons.nil();
            } else {
                this.tail = new Cons(this.head, this.tail);
                this.head = x;
            }
        } else {
            this.tail.add(index - 1, x);
        }
    }

    public boolean addAll(Collection c) {
        if (c.isEmpty()) {
            return false;
        }
        if (this.tail == null) {
            Seq s = TypeCoercion.coerceToSeq(c);
            this.head = s.get();
            this.tail = s.tail();
            return true;
        }
        Cons l = this;
        while (l.tail instanceof Cons) {
            Cons t = (Cons)l.tail;
            if (t.tail == null) {
                l.tail = TypeCoercion.coerceToSeq(c);
                return true;
            }
            l = t;
        }
        return l.tail.addAll(c);
    }

    public Object remove() {
        Object old = this.head;
        if (this.tail != null) {
            this.head = this.tail.get();
            this.tail = this.tail.tail();
        }
        return old;
    }

    public void clear() {
        this.head = null;
        this.tail = null;
    }

    public Cons clone() {
        try {
            Cons s = (Cons)super.clone();
            if (this.tail instanceof Cons) {
                this.tail = ((Cons)this.tail).clone();
            }
            return s;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }
}

