/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import elite.ast.Expression;
import elite.lang.Decimal;
import elite.lang.Rational;
import elite.lang.Symbol;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ELException;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.ELProgram;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.Operator;
import org.operamasks.el.parser.ParseException;
import org.operamasks.el.parser.Position;
import org.operamasks.el.parser.ResourceResolver;
import org.operamasks.el.parser.Scanner;
import org.operamasks.el.parser.SyntaxRule;
import org.operamasks.el.parser.Token;
import org.operamasks.el.parser.XMLParser;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.resources.Resources;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Parser
extends Scanner {
    private ResourceResolver resolver = null;
    private XMLParser xmlparser = null;
    private static final String SCRIPT_PATH = "META-INF/script/elite/";
    private static final String SCRIPT_EXT = ".xel";
    private static final AtomicInteger clstagid = new AtomicInteger();
    private static final String[] EMPTY_VARS = new String[0];
    private static final ELNode[] EMPTY_EXPS = new ELNode[0];
    private static final ELNode.DEFINE[] EMPTY_DEFS = new ELNode.DEFINE[0];
    private int tempid = 0;
    private static final int L_GENERATOR = 0;
    private static final int L_DECLARATION = 1;
    private static final int L_FILTER = 2;
    private SyntaxRuleMap prefix_syntax_rules = new SyntaxRuleMap();
    private SyntaxRuleMap infix_syntax_rules = new SyntaxRuleMap();
    private SyntaxRuleMap pattern_rules = new SyntaxRuleMap();
    private EvaluationContext parse_context;
    private static final SimpleCache<String, ELNode> cache = SimpleCache.make(5000);

    public Parser(String text) {
        super(text);
    }

    public void setResourceResolver(ResourceResolver resolver) {
        this.resolver = resolver;
    }

    private static String clstag() {
        return "class$" + clstagid.incrementAndGet();
    }

    private void expect(int t) throws ELException {
        Operator op;
        if (this.token == t) {
            this.scan();
            return;
        }
        if (t != 47 && this.token == 47 && (op = this.getOperator(this.idValue)) != null && t == op.token) {
            this.scan();
            return;
        }
        switch (t) {
            case 88: {
                if (!this.scanLayout()) {
                    throw this.parseError(Resources._T("EL_TOKEN_EXPECTED", ";", this.token_value()));
                }
                return;
            }
            case 47: {
                if (this.token == -1) {
                    throw this.incomplete(Resources._T("EL_IDENTIFIER_EXPECTED"));
                }
                throw this.parseError(Resources._T("EL_IDENTIFIER_EXPECTED"));
            }
            case -1: {
                throw this.parseError(Resources._T("EL_EXTRA_CHAR_IN_INPUT"));
            }
        }
        if (this.token == -1) {
            throw this.incomplete(Resources._T("EL_TOKEN_EXPECTED", Token.opNames[t], "<EOF>"));
        }
        throw this.parseError(Resources._T("EL_TOKEN_EXPECTED", Token.opNames[t], this.token_value()));
    }

    private void expect_lvalue(ELNode e) {
        while (e instanceof ELNode.EXPR) {
            e = ((ELNode.EXPR)e).right;
        }
        switch (e.op) {
            case 0: 
            case 43: 
            case 47: {
                break;
            }
            case 55: {
                for (ELNode a : ((ELNode.LIST)e).elems) {
                    this.expect_lvalue(a);
                }
                break;
            }
            case 56: {
                for (ELNode a : ((ELNode.TUPLE)e).elems) {
                    this.expect_lvalue(a);
                }
                break;
            }
            default: {
                throw this.parseError(e.pos, Resources._T("EL_READONLY_EXPRESSION"));
            }
        }
    }

    private static ELNode[] to_a(List<ELNode> exps) {
        return exps.toArray(new ELNode[exps.size()]);
    }

    private static ELNode.DEFINE[] to_a(List<ELNode.DEFINE> defs) {
        return defs.toArray(new ELNode.DEFINE[defs.size()]);
    }

    private static String[] to_a(List<String> ids) {
        return ids.toArray(new String[ids.size()]);
    }

    private String tempvar() {
        return "*" + this.tempid++ + "*";
    }

    private ELNode parseTerm() {
        switch (this.token) {
            case 49: {
                char v = this.charValue;
                return new ELNode.CHARVAL(this.scan(), v);
            }
            case 50: {
                Number v = this.numberValue;
                return new ELNode.NUMBER(this.scan(), v);
            }
            case 52: {
                String v = this.stringValue;
                if (this.charValue == '\"') {
                    return this.parseEmbedExpression(this.scan(), v);
                }
                return new ELNode.STRINGVAL(this.scan(), v);
            }
            case 27: {
                ELNode.REGEXP e = new ELNode.REGEXP(this.pos, this.scanRegexp());
                this.scan();
                return e;
            }
            case 73: {
                return new ELNode.IDENT(this.scan(), "void");
            }
            case 47: 
            case 83: {
                Operator op;
                if (this.token == 47 && (op = this.getOperator(this.idValue)) != null && op.token == 2) {
                    return new ELNode.PREFIX(this.scan(), op.name, op.token2, this.parseTerm());
                }
                int p = this.pos;
                String id = this.scanQAName();
                this.expect(47);
                if (this.token == 81) {
                    return new ELNode.APPLY(p, new ELNode.IDENT(p, id), this.parseBlock(this.scan()));
                }
                if (this.token == 85 || this.token == 75) {
                    ELNode.DEFINE var = new ELNode.DEFINE(p, id, this.parseTypeNameOpt());
                    this.expect(85);
                    return new ELNode.LAMBDA(p, this.filename, new ELNode.DEFINE[]{var}, this.parseExpression());
                }
                return new ELNode.IDENT(p, id);
            }
            case 85: {
                return new ELNode.LAMBDA(this.scan(), this.filename, EMPTY_DEFS, this.parseExpression());
            }
            case 74: {
                if (Character.isJavaIdentifierStart((char)this.ch)) {
                    this.scan();
                    String id = this.idValue;
                    return new ELNode.SYMBOL(this.scan(), Symbol.valueOf(id));
                }
                if (this.ch == 39 || this.ch == 34) {
                    this.scan();
                    String id = this.stringValue;
                    return new ELNode.SYMBOL(this.scan(), Symbol.valueOf(id));
                }
                throw this.parseError(Resources._T("EL_MISSING_TERM"));
            }
            case 70: {
                return new ELNode.BOOLEANVAL(this.scan(), true);
            }
            case 71: {
                return new ELNode.BOOLEANVAL(this.scan(), false);
            }
            case 72: {
                return new ELNode.NULL(this.scan());
            }
            case 45: {
                return this.parseNewExpression(this.scan());
            }
            case 81: {
                int p = this.scan();
                ELNode e = this.parseLambdaExpressionOpt(p);
                if (e != null) {
                    this.expect(82);
                    return e;
                }
                return this.parseMapExpression(p);
            }
            case 79: {
                return this.parseListOrRangeExpression(this.scan());
            }
            case 2: {
                Operator op = this.operator;
                return new ELNode.PREFIX(this.scan(), op.name, op.token2, this.parseTerm());
            }
            case 24: {
                int p = this.scan();
                if (this.token == 50) {
                    Number v = this.numberValue;
                    return new ELNode.NUMBER(this.scan(), v);
                }
                return new ELNode.POS(p, this.parseTerm());
            }
            case 25: {
                int p = this.scan();
                if (this.token == 50) {
                    Number v = this.numberValue;
                    v = v instanceof BigInteger ? ((BigInteger)v).negate() : (v instanceof BigDecimal ? ((BigDecimal)v).negate() : (v instanceof Decimal ? ((Decimal)v).negate() : (v instanceof Rational ? ((Rational)v).negate() : (v instanceof Double ? (Number)(-v.doubleValue()) : (Number)(v instanceof Long ? (Number)(-v.longValue()) : (Number)(-v.intValue()))))));
                    return new ELNode.NUMBER(this.scan(), v);
                }
                return new ELNode.NEG(p, this.parseTerm());
            }
            case 37: {
                int p = this.scan();
                ELNode e = this.parseTerm();
                this.expect_lvalue(e);
                return new ELNode.INC(p, e, true);
            }
            case 38: {
                int p = this.scan();
                ELNode e = this.parseTerm();
                this.expect_lvalue(e);
                return new ELNode.DEC(p, e, true);
            }
            case 33: {
                return new ELNode.NOT(this.scan(), this.parseTerm());
            }
            case 34: {
                return new ELNode.BITNOT(this.scan(), this.parseTerm());
            }
            case 39: {
                return new ELNode.EMPTY(this.scan(), this.parseTerm());
            }
            case 97: {
                return this.parseLetExpression(this.scan());
            }
            case 103: {
                return this.parseWithExpression(this.scan());
            }
            case 111: {
                return this.parseCatchExpression(this.scan());
            }
            case 77: {
                int p = this.scan();
                if (this.token == 78) {
                    this.scan();
                    return new ELNode.TUPLE(p, EMPTY_EXPS);
                }
                switch (this.token) {
                    case 2: 
                    case 3: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 29: 
                    case 30: 
                    case 33: 
                    case 34: 
                    case 39: {
                        String id = this.idValue != null ? this.idValue : this.operator.name;
                        this.mark();
                        this.scan();
                        if (this.scan(78)) {
                            return new ELNode.IDENT(p, id);
                        }
                        this.reset();
                        break;
                    }
                    case 47: {
                        Operator op = this.getOperator(this.idValue);
                        if (op == null) break;
                        this.mark();
                        this.scan();
                        if (this.scan(78)) {
                            return new ELNode.IDENT(p, op.name);
                        }
                        this.reset();
                    }
                }
                ELNode e = this.parseSyntaxExpression();
                if (this.token == 87) {
                    ArrayList<ELNode> elems = new ArrayList<ELNode>();
                    elems.add(e);
                    while (this.scan(87) && this.token != 78) {
                        elems.add(this.parseSyntaxExpression());
                    }
                    this.expect(78);
                    return new ELNode.TUPLE(p, Parser.to_a(elems));
                }
                this.expect(78);
                return new ELNode.EXPR(p, e);
            }
            case 17: {
                if (this.xmlparser == null) {
                    this.xmlparser = new XMLParser(this);
                }
                return this.xmlparser.parse();
            }
            case -1: {
                throw this.incomplete(Resources._T("EL_MISSING_TERM"));
            }
        }
        throw this.parseError(Resources._T("EL_MISSING_TERM"));
    }

    private ELNode parseNonColonExpression(boolean allowSyntaxRules) {
        if (this.token == 47) {
            this.mark();
            String id = this.idValue;
            int p = this.scan();
            if (this.token == 74) {
                return new ELNode.IDENT(p, id);
            }
            this.reset();
        }
        return allowSyntaxRules ? this.parseSyntaxExpression() : this.parseExpression();
    }

    private String scanQName() {
        String id = this.idValue;
        if (id == null) {
            return null;
        }
        if (this.ch == 58 && Character.isJavaIdentifierStart((char)this.lookahead(0))) {
            this.scan();
            assert (this.token == 74);
            this.scan();
            assert (this.idValue != null);
            id = id + ":" + this.idValue;
            this.token = 47;
        }
        return id;
    }

    private String scanQAName() {
        if (this.idValue != null) {
            return this.scanQName();
        }
        if (this.token == 83) {
            this.scan();
            String id = "@";
            while (this.token == 83) {
                id = id + "@";
                this.scan();
            }
            if (this.idValue != null) {
                id = id + this.scanQName();
                this.token = 47;
                return id;
            }
        }
        return null;
    }

    private ELNode parseBinaryExpression(ELNode e) {
        Operator op;
        if (e == null) {
            return null;
        }
        if (this.token == 47 && (op = this.getOperator(this.idValue)) != null) {
            this.operator = op;
            this.token = op.token;
        }
        switch (this.token) {
            case 79: {
                int p = this.scan();
                ELNode index = this.parseExpression();
                if (this.token == 58) {
                    index = this.parseRangeExpression(p, index, null);
                } else if (this.token == 87) {
                    this.scan();
                    index = this.parseRangeExpression(p, index, this.parseExpression());
                } else {
                    this.expect(80);
                }
                ELNode.Unary e2 = new ELNode.ACCESS(p, e, index);
                if (this.token == 81) {
                    e2 = new ELNode.APPLY(p, ((ELNode)e2).order(), this.parseBlock(this.scan()));
                }
                return e2;
            }
            case 42: {
                String id;
                int p = this.scan();
                if (this.token == 79) {
                    this.scan();
                    ELNode e2 = this.parseSyntaxExpression();
                    this.expect(80);
                    return this.translateShortcut(p, e, e2, "filter");
                }
                if (this.token == 81) {
                    ELNode e2 = this.parseCompoundExpression(this.scan(), true);
                    this.expect(82);
                    e = new ELNode.ACCESS(p, e, (ELNode)new ELNode.STRINGVAL(p, "do"));
                    e2 = new ELNode.LAMBDA(e2.pos, this.filename, EMPTY_DEFS, e2);
                    return new ELNode.APPLY(p, e.order(), e2);
                }
                if (this.token == 77) {
                    return new ELNode.ACCESS(p, e, (ELNode)new ELNode.STRINGVAL(p, "curry"));
                }
                switch (this.token) {
                    case 39: 
                    case 45: 
                    case 93: {
                        id = this.scanQName();
                        this.scan();
                        break;
                    }
                    case 83: {
                        id = this.scanQAName();
                        this.expect(47);
                        break;
                    }
                    default: {
                        id = this.scanQName();
                        this.expect(47);
                    }
                }
                e = new ELNode.ACCESS(p, e, (ELNode)new ELNode.STRINGVAL(p, id));
                if (this.token == 81) {
                    e = new ELNode.APPLY(p, e.order(), this.parseBlock(this.scan()));
                }
                return e;
            }
            case 77: {
                return this.parseApplyExpression(this.scan(), e);
            }
            case 40: {
                return new ELNode.XFORM(this.scan(), e, this.parseTerm());
            }
            case 37: {
                this.expect_lvalue(e);
                return new ELNode.INC(this.scan(), e, false);
            }
            case 38: {
                this.expect_lvalue(e);
                return new ELNode.DEC(this.scan(), e, false);
            }
            case 31: {
                if (this.idValue.equals("is")) {
                    int p = this.scan();
                    if (this.token == 33 && this.idValue != null) {
                        return new ELNode.INSTANCEOF(this.scan(), e, this.parseClassLiteral(false), true);
                    }
                    return new ELNode.INSTANCEOF(p, e, this.parseClassLiteral(false), false);
                }
                return new ELNode.INSTANCEOF(this.scan(), e, this.parseClassLiteral(false), false);
            }
            case 32: {
                return new ELNode.IN(this.scan(), e, this.parseTerm(), false);
            }
            case 33: {
                if (this.idValue == null) {
                    return null;
                }
                int p = this.scan();
                if (this.scan(31)) {
                    return new ELNode.INSTANCEOF(p, e, this.parseClassLiteral(false), true);
                }
                if (this.scan(32)) {
                    return new ELNode.IN(p, e, this.parseTerm(), true);
                }
                if (this.token == -1) {
                    throw this.incomplete(Resources._T("EL_TOKEN_EXPECTED", "in, instanceof", "<EOF>"));
                }
                throw this.parseError(Resources._T("EL_TOKEN_EXPECTED", "in, instanceof", this.idValue != null ? this.idValue : Token.opNames[this.token]));
            }
            case 0: {
                this.expect_lvalue(e);
                return new ELNode.ASSIGN(this.scan(), e, this.parseTerm());
            }
            case 1: {
                this.expect_lvalue(e);
                int op2 = this.operator.token2;
                int p = this.scan();
                ELNode e2 = this.parseTerm();
                switch (op2) {
                    case 24: {
                        return new ELNode.ASSIGNOP(p, new ELNode.ADD(p, e, e2));
                    }
                    case 25: {
                        return new ELNode.ASSIGNOP(p, new ELNode.SUB(p, e, e2));
                    }
                    case 26: {
                        return new ELNode.ASSIGNOP(p, new ELNode.MUL(p, e, e2));
                    }
                    case 27: {
                        return new ELNode.ASSIGNOP(p, new ELNode.DIV(p, e, e2));
                    }
                    case 29: {
                        return new ELNode.ASSIGNOP(p, new ELNode.REM(p, e, e2));
                    }
                    case 30: {
                        return new ELNode.ASSIGNOP(p, new ELNode.POW(p, e, e2));
                    }
                    case 10: {
                        return new ELNode.ASSIGNOP(p, new ELNode.BITOR(p, e, e2));
                    }
                    case 12: {
                        return new ELNode.ASSIGNOP(p, new ELNode.BITAND(p, e, e2));
                    }
                    case 11: {
                        return new ELNode.ASSIGNOP(p, new ELNode.XOR(p, e, e2));
                    }
                    case 21: {
                        return new ELNode.ASSIGNOP(p, new ELNode.SHL(p, e, e2));
                    }
                    case 22: {
                        return new ELNode.ASSIGNOP(p, new ELNode.SHR(p, e, e2));
                    }
                    case 23: {
                        return new ELNode.ASSIGNOP(p, new ELNode.USHR(p, e, e2));
                    }
                    case 6: {
                        return new ELNode.ASSIGNOP(p, new ELNode.COALESCE(p, e, e2));
                    }
                }
                throw new AssertionError();
            }
            case 3: {
                op = this.operator;
                return new ELNode.INFIX(this.scan(), op.name, op.token2, e, this.parseTerm());
            }
            case 24: {
                return new ELNode.ADD(this.scan(), e, this.parseTerm());
            }
            case 25: {
                return new ELNode.SUB(this.scan(), e, this.parseTerm());
            }
            case 26: {
                return new ELNode.MUL(this.scan(), e, this.parseTerm());
            }
            case 27: {
                return new ELNode.DIV(this.scan(), e, this.parseTerm());
            }
            case 28: {
                return new ELNode.IDIV(this.scan(), e, this.parseTerm());
            }
            case 29: {
                return new ELNode.REM(this.scan(), e, this.parseTerm());
            }
            case 30: {
                return new ELNode.POW(this.scan(), e, this.parseTerm());
            }
            case 17: {
                return new ELNode.LT(this.scan(), e, this.parseTerm());
            }
            case 19: {
                return new ELNode.LE(this.scan(), e, this.parseTerm());
            }
            case 18: {
                return new ELNode.GT(this.scan(), e, this.parseTerm());
            }
            case 20: {
                return new ELNode.GE(this.scan(), e, this.parseTerm());
            }
            case 13: {
                return new ELNode.EQ(this.scan(), e, this.parseTerm());
            }
            case 14: {
                return new ELNode.NE(this.scan(), e, this.parseTerm());
            }
            case 15: {
                return new ELNode.IDEQ(this.scan(), e, this.parseTerm());
            }
            case 16: {
                return new ELNode.IDNE(this.scan(), e, this.parseTerm());
            }
            case 9: {
                return new ELNode.AND(this.scan(), e, this.parseTerm());
            }
            case 8: {
                return new ELNode.OR(this.scan(), e, this.parseTerm());
            }
            case 12: {
                return new ELNode.BITAND(this.scan(), e, this.parseTerm());
            }
            case 10: {
                return new ELNode.BITOR(this.scan(), e, this.parseTerm());
            }
            case 11: {
                return new ELNode.XOR(this.scan(), e, this.parseTerm());
            }
            case 21: {
                return new ELNode.SHL(this.scan(), e, this.parseTerm());
            }
            case 22: {
                return new ELNode.SHR(this.scan(), e, this.parseTerm());
            }
            case 23: {
                return new ELNode.USHR(this.scan(), e, this.parseTerm());
            }
            case 6: {
                return new ELNode.COALESCE(this.scan(), e, this.parseTerm());
            }
            case 7: {
                return new ELNode.SAFEREF(this.scan(), e, this.parseTerm());
            }
            case 76: {
                int p = this.scan();
                ELNode second = this.parseNonColonExpression(false);
                this.expect(74);
                ELNode third = this.parseExpression();
                return new ELNode.COND(p, e, second, third);
            }
        }
        return null;
    }

    private ELNode translateShortcut(int p, ELNode e, ELNode e2, String action) {
        int p2 = e2.pos;
        if (e2.op != 60) {
            String t = this.tempvar();
            e2 = new ELNode.LAMBDA(p2, this.filename, EMPTY_DEFS, e2);
            e2 = new ELNode.APPLY(p2, new ELNode.ACCESS(p2, e2, (ELNode)new ELNode.STRINGVAL(p2, "call_with")), (ELNode)new ELNode.IDENT(p2, t));
            e2 = new ELNode.LAMBDA(p2, this.filename, new ELNode.DEFINE[]{new ELNode.DEFINE(p2, t, null)}, e2);
        }
        e = new ELNode.ACCESS(p, e, (ELNode)new ELNode.STRINGVAL(p, action));
        e = new ELNode.APPLY(p, e.order(), e2);
        return e;
    }

    private ELNode parseExpression() {
        for (ELNode e = this.parseTerm(); e != null; e = e.order()) {
            ELNode more = this.parseBinaryExpression(e);
            if (more == null) {
                return e;
            }
            e = more;
        }
        return null;
    }

    private ELNode parseSyntaxExpression() {
        ELNode more;
        ELNode e = this.matchPrefixSyntaxRule();
        if (e != null) {
            return e;
        }
        e = this.parseExpression();
        while ((more = this.matchInfixSyntaxRule(e)) != null) {
            e = more;
        }
        return e;
    }

    private ELNode parseSubExpression(SyntaxRule.Machine machine) {
        ELNode e = this.parseTerm();
        while (true) {
            switch (this.token) {
                case 37: 
                case 38: 
                case 77: 
                case 79: {
                    if (!this.sawSpace()) break;
                    return e;
                }
            }
            if (machine.isDelimiter(this)) {
                return e;
            }
            ELNode more = this.parseBinaryExpression(e);
            if (more == null) {
                return e;
            }
            e = more.order();
        }
    }

    private ELNode parseExpressionStatement() {
        ELNode more;
        ELNode e = this.matchPrefixSyntaxRule();
        if (e != null) {
            return e;
        }
        e = this.parseTerm();
        while (true) {
            switch (this.token) {
                case 37: 
                case 38: 
                case 77: 
                case 79: 
                case 81: {
                    if (!this.scanLayout()) break;
                    return e;
                }
            }
            more = this.parseBinaryExpression(e);
            if (more == null) break;
            e = more.order();
        }
        while (!this.scanLayout() && (more = this.matchInfixSyntaxRule(e)) != null) {
            e = more;
        }
        return e;
    }

    private ELNode parseApplyExpression(int p, ELNode e) {
        ELNode[] args;
        String[] keys;
        if (this.token == 78) {
            this.scan();
            keys = null;
            args = this.token == 81 ? new ELNode[]{this.parseBlock(this.scan())} : EMPTY_EXPS;
        } else {
            ArrayList<ELNode> vlst = new ArrayList<ELNode>();
            ArrayList<String> klst = new ArrayList<String>();
            this.parseNamedArguments(vlst, klst);
            this.expect(78);
            if (this.token == 81) {
                vlst.add(this.parseBlock(this.scan()));
                klst.add(null);
            }
            args = Parser.to_a(vlst);
            keys = Parser.check_keys(klst);
        }
        return new ELNode.APPLY(p, e, args, keys);
    }

    private ELNode parseNewExpression(int p) {
        String cls = this.parseClassLiteral(false);
        if (this.token == 77) {
            ELNode[] args;
            String[] keys;
            this.scan();
            if (this.token == 78) {
                this.scan();
                keys = null;
                args = EMPTY_EXPS;
            } else {
                ArrayList<ELNode> vlst = new ArrayList<ELNode>();
                ArrayList<String> klst = new ArrayList<String>();
                this.parseNamedArguments(vlst, klst);
                this.expect(78);
                keys = Parser.check_keys(klst);
                args = Parser.to_a(vlst);
            }
            if (this.token != 81) {
                return new ELNode.NEW(p, cls, args, keys, null);
            }
            if (this.looksLikeMap()) {
                ELNode.MAP props = this.parseMapExpression(this.scan());
                return new ELNode.NEW(p, cls, args, keys, props);
            }
            this.scan();
            String clstag = Parser.clstag();
            ELNode.DEFINE[] body = this.parseClassBody();
            if (args.length != 0) {
                ELNode.DEFINE initproc = new ELNode.DEFINE(p, clstag, null, null, new ELNode.LAMBDA(p, this.filename, EMPTY_DEFS, new ELNode.APPLY(p, new ELNode.IDENT(p, "super"), args, keys)), true);
                ELNode.DEFINE[] tmp = new ELNode.DEFINE[body.length + 1];
                tmp[0] = initproc;
                System.arraycopy(body, 0, tmp, 1, body.length);
                body = tmp;
            }
            return new ELNode.NEWOBJ(p, this.filename, cls, clstag, body);
        }
        if (this.token == 79) {
            ELNode[] dims = this.parseArrayDimensions();
            ELNode[] init = null;
            if ((dims == null || dims.length == 1) && this.token == 81) {
                this.scan();
                init = this.parseArrayInitializer();
            }
            return new ELNode.ARRAY(p, cls, dims, init);
        }
        if (this.token != 81) {
            return new ELNode.NEW(p, cls, EMPTY_EXPS, null, null);
        }
        if (this.looksLikeMap()) {
            ELNode.MAP props = this.parseMapExpression(this.scan());
            return new ELNode.NEW(p, cls, EMPTY_EXPS, null, props);
        }
        this.scan();
        return new ELNode.NEWOBJ(p, this.filename, cls, Parser.clstag(), this.parseClassBody());
    }

    private void parseNamedArguments(List<ELNode> args, List<String> keys) {
        do {
            String key = this.parseArgumentName();
            ELNode arg = this.parseSyntaxExpression();
            if (key != null && keys.contains(key)) {
                throw this.parseError(Resources._T("EL_DUPLICATE_ARG_NAME", key));
            }
            keys.add(key);
            args.add(arg);
        } while (this.scan(87));
    }

    private static String[] check_keys(List<String> keys) {
        for (int i = 0; i < keys.size(); ++i) {
            if (keys.get(i) == null) continue;
            return Parser.to_a(keys);
        }
        return null;
    }

    private String parseArgumentName() {
        String key = null;
        if (this.token == 47) {
            this.mark();
            key = this.scanQName();
            this.scan();
        } else if (this.token == 52) {
            this.mark();
            key = this.stringValue;
            this.scan();
        } else {
            return null;
        }
        if (this.token == 0) {
            this.scan();
            return key;
        }
        this.reset();
        return null;
    }

    private ELNode[] parseArrayDimensions() {
        this.expect(79);
        if (this.token == 80) {
            this.scan();
            return null;
        }
        ArrayList<ELNode> dims = new ArrayList<ELNode>();
        do {
            dims.add(this.parseExpression());
            this.expect(80);
        } while (this.scan(79));
        return Parser.to_a(dims);
    }

    private ELNode[] parseArrayInitializer() {
        ArrayList<ELNode> elems = new ArrayList<ELNode>();
        while (this.token != 82) {
            elems.add(this.parseSyntaxExpression());
            if (this.scan(87)) continue;
        }
        this.expect(82);
        return Parser.to_a(elems);
    }

    ELNode parseEmbedExpression(int p, String str) {
        if (str.indexOf(36) == -1 && str.indexOf(35) == -1 && str.indexOf(92) == -1) {
            return new ELNode.STRINGVAL(p, str);
        }
        Parser parser = new Parser(str);
        parser.setFileName(this.filename);
        parser.setLineNumber(Position.line(p));
        parser.importSyntaxRules(this);
        ELNode exp = parser.parseExpressionString(true);
        if (exp instanceof ELNode.LITERAL) {
            return new ELNode.STRINGVAL(p, ((ELNode.LITERAL)exp).value);
        }
        if (exp instanceof ELNode.STRINGVAL) {
            return exp;
        }
        if (exp instanceof ELNode.Composite) {
            return exp;
        }
        return new ELNode.Composite(p, new ELNode[]{exp});
    }

    private ELNode parseListOrRangeExpression(int p) {
        if (this.token == 80) {
            this.scan();
            return new ELNode.LIST(p, EMPTY_EXPS, null);
        }
        ELNode e1 = this.parseNonColonExpression(true);
        ELNode e2 = null;
        if (this.token == 87) {
            this.scan();
            e2 = this.parseNonColonExpression(true);
        }
        if (this.token == 58) {
            return this.parseRangeExpression(p, e1, e2);
        }
        return this.parseListExpression(p, e1, e2);
    }

    private ELNode parseListExpression(int p, ELNode e1, ELNode e2) {
        if (e2 == null) {
            switch (this.token) {
                case 47: {
                    if (!this.idValue.equals("where")) break;
                }
                case 97: 
                case 98: 
                case 100: {
                    this.scan();
                    return this.parseListComprehension(e1);
                }
            }
        }
        ArrayList<ELNode> elems = new ArrayList<ELNode>();
        ELNode tail = null;
        boolean delay = false;
        elems.add(e1);
        if (e2 != null) {
            elems.add(e2);
        }
        while (this.scan(87) && this.token != 80) {
            elems.add(this.parseNonColonExpression(true));
        }
        if (this.scan(74)) {
            delay = this.scan(12);
            tail = this.parseSyntaxExpression();
        }
        this.expect(80);
        return new ELNode.LIST(p, Parser.to_a(elems), tail, delay);
    }

    private ELNode parseListComprehension(ELNode e) {
        Qualifier Qs = null;
        do {
            switch (this.token) {
                case 100: {
                    this.scan();
                    ELNode pat = (ELNode)((Object)this.parsePattern());
                    this.expect(32);
                    Qs = new Qualifier(0, pat, this.parseExpression(), Qs);
                    break;
                }
                case 97: {
                    this.scan();
                    ELNode pat = (ELNode)((Object)this.parsePattern());
                    this.expect(0);
                    Qs = new Qualifier(1, pat, this.parseExpression(), Qs);
                    break;
                }
                case 98: {
                    this.scan();
                    Qs = new Qualifier(2, null, this.parseExpression(), Qs);
                    break;
                }
                default: {
                    Scanner mark = this.save();
                    ELNode pat = (ELNode)((Object)this.parsePatternOpt());
                    if (pat != null) {
                        if (this.scan(32)) {
                            Qs = new Qualifier(0, pat, this.parseExpression(), Qs);
                            break;
                        }
                        if (this.scan(0)) {
                            Qs = new Qualifier(1, pat, this.parseExpression(), Qs);
                            break;
                        }
                        this.restore(mark);
                        Qs = new Qualifier(2, null, this.parseExpression(), Qs);
                        break;
                    }
                    this.restore(mark);
                    Qs = new Qualifier(2, null, this.parseExpression(), Qs);
                }
            }
        } while (this.scan(87) || this.token == 100 || this.token == 97 || this.token == 98);
        this.expect(80);
        e = new ELNode.LIST(e.pos, new ELNode[]{e}, null);
        while (Qs != null) {
            if (Qs.type == 2) {
                ELNode F = Qs.exp;
                e = new ELNode.COND(F.pos, F, e, (ELNode)new ELNode.NULL(F.pos));
            } else {
                ELNode.DEFINE V;
                if (Parser.isVariablePattern(Qs.pat)) {
                    V = (ELNode.DEFINE)Qs.pat;
                } else {
                    ELNode P = Qs.pat;
                    String t = this.tempvar();
                    V = new ELNode.DEFINE(P.pos, t, null);
                    e = new ELNode.WITH(P.pos, (ELNode)new ELNode.IDENT(P.pos, t), new ELNode.MATCHCASE(P.pos, (ELNode.Pattern)((Object)P), null, e), (ELNode)new ELNode.NULL(P.pos));
                }
                if (Qs.type == 0) {
                    ELNode L = Qs.exp;
                    e = new ELNode.APPLY(L.pos, new ELNode.ACCESS(L.pos, L, (ELNode)new ELNode.STRINGVAL(L.pos, "mappend")), (ELNode)new ELNode.LAMBDA(L.pos, this.filename, new ELNode.DEFINE[]{V}, e));
                } else {
                    ELNode E = Qs.exp;
                    e = new ELNode.APPLY(E.pos, new ELNode.LAMBDA(E.pos, this.filename, new ELNode.DEFINE[]{V}, e), E);
                }
            }
            Qs = Qs.next;
        }
        return e;
    }

    private ELNode parseRangeExpression(int p, ELNode begin, ELNode next) {
        ELNode end = null;
        boolean exclude = false;
        this.expect(58);
        if (this.token == 26) {
            this.scan();
            if (this.token != 80) {
                end = this.parseExpression();
                exclude = true;
            }
        } else {
            end = this.parseExpression();
        }
        this.expect(80);
        return new ELNode.RANGE(p, begin, next, end, exclude);
    }

    private ELNode.MAP parseMapExpression(int p) {
        ArrayList<ELNode> keys = new ArrayList<ELNode>();
        ArrayList<ELNode> values = new ArrayList<ELNode>();
        while (this.token != 82) {
            int pp;
            String id;
            ELNode k = null;
            if (this.token == 47) {
                this.mark();
                id = this.idValue;
                pp = this.scan();
                if (this.token == 74) {
                    k = new ELNode.STRINGVAL(pp, id);
                } else {
                    this.reset();
                    k = this.parseExpression();
                }
            } else if (this.token == 83) {
                this.mark();
                id = "@";
                pp = this.scan();
                while (this.token == 83) {
                    this.scan();
                    id = id + "@";
                }
                if (this.idValue != null) {
                    id = id + this.idValue;
                    this.scan();
                    if (this.token == 74) {
                        k = new ELNode.STRINGVAL(pp, id);
                    }
                }
                if (k == null) {
                    this.reset();
                    k = this.parseExpression();
                }
            } else {
                k = this.parseExpression();
            }
            this.expect(74);
            ELNode v = this.parseSyntaxExpression();
            keys.add(k);
            values.add(v);
            if (this.token == 87) {
                this.scan();
                continue;
            }
            if (this.token == 82) break;
            if (this.sawNewLine()) continue;
            this.expect(87);
        }
        this.expect(82);
        return new ELNode.MAP(p, Parser.to_a(keys), Parser.to_a(values));
    }

    private boolean looksLikeMap() {
        boolean ret = false;
        this.mark();
        if (this.token == 81) {
            this.scan();
            if (this.token == 47 || this.token == 52) {
                this.scan();
                ret = this.token == 74;
            } else if (this.token == 83) {
                do {
                    this.scan();
                } while (this.token == 83);
                if (this.idValue != null) {
                    this.scan();
                    ret = this.token == 74;
                }
            }
        }
        this.reset();
        return ret;
    }

    private String parseClassLiteral(boolean pkg) {
        if (!pkg && this.ch == 58 && Character.isJavaIdentifierStart((char)this.lookahead(0))) {
            String id = this.scanQName();
            this.expect(47);
            return id;
        }
        String id = this.idValue;
        this.expect(47);
        StringBuilder buf = new StringBuilder(id);
        while (this.token == 42) {
            this.scan();
            if (pkg && this.token == 26) {
                this.scan();
                buf.append(".*");
                break;
            }
            buf.append('.').append(this.idValue);
            this.expect(47);
        }
        return buf.toString();
    }

    private String parseTypeNameOpt() {
        if (this.token == 75) {
            this.scan();
            return this.parseClassLiteral(false);
        }
        return null;
    }

    private ELNode parseLambdaExpressionOpt(int p) {
        ArrayList<ELNode.Pattern> pats = new ArrayList<ELNode.Pattern>();
        boolean varargs = false;
        if (this.token == 85) {
            this.scan();
        } else {
            Scanner mark = this.save();
            do {
                ELNode.Pattern pat;
                if ((pat = this.parsePatternOpt()) == null) {
                    this.restore(mark);
                    return null;
                }
                pats.add(pat);
                if (this.token != 86) continue;
                this.scan();
                varargs = true;
                break;
            } while (this.scan(87));
            if (varargs) {
                this.expect(85);
            } else if (this.token == 85) {
                this.scan();
            } else {
                this.restore(mark);
                return null;
            }
        }
        return this.translateLambda(p, null, null, pats, varargs, this.parseCompoundExpression(p));
    }

    private ELNode parseBlock(int p) {
        ArrayList<ELNode.Pattern> pats = new ArrayList<ELNode.Pattern>();
        boolean varargs = false;
        boolean block = false;
        if (this.token == 85) {
            this.scan();
        } else {
            Scanner mark = this.save();
            do {
                ELNode.Pattern pat;
                if ((pat = this.parsePatternOpt()) == null) {
                    this.restore(mark);
                    block = true;
                    break;
                }
                pats.add(pat);
                if (this.token != 86) continue;
                this.scan();
                varargs = true;
                break;
            } while (this.scan(87));
            if (varargs) {
                this.expect(85);
            } else if (this.token == 85) {
                this.scan();
            } else {
                this.restore(mark);
                block = true;
            }
        }
        ELNode body = this.parseCompoundExpression(p);
        this.expect(82);
        if (block) {
            return new ELNode.BLOCK(p, this.filename, body);
        }
        return this.translateLambda(p, null, null, pats, varargs, body);
    }

    private ELNode.LAMBDA translateLambda(int p, String name, String type, List<ELNode.Pattern> patterns, boolean varargs, ELNode body) {
        int npats = patterns.size();
        ELNode.DEFINE[] vars = new ELNode.DEFINE[npats];
        boolean simple = true;
        for (int i = 0; i < npats; ++i) {
            ELNode pat = (ELNode)((Object)patterns.get(i));
            if (Parser.isVariablePattern(pat)) {
                vars[i] = (ELNode.DEFINE)pat;
                continue;
            }
            vars[i] = new ELNode.DEFINE(pat.pos, this.tempvar(), null);
            simple = false;
        }
        if (!simple) {
            ELNode.Pattern[] pats = new ELNode.Pattern[npats];
            ELNode[] args = new ELNode.IDENT[npats];
            for (int i = 0; i < npats; ++i) {
                pats[i] = patterns.get(i);
                args[i] = new ELNode.IDENT(vars[i].pos, vars[i].id);
            }
            body = new ELNode.WITH(body.pos, args, new ELNode.MATCHCASE(p, pats, null, body), null);
        }
        this.checkVars(p, vars, varargs);
        return new ELNode.LAMBDA(p, this.filename, name, type, vars, varargs, body);
    }

    private ELNode parseProcedureDefinition(String name, String rtype, ELNode.METASET meta) {
        boolean isAbstract;
        ELNode body;
        List vars;
        int p = this.pos;
        ArrayList vars_list = new ArrayList();
        BitSet vararg_flags = new BitSet();
        this.expect(77);
        do {
            vars = new ArrayList<ELNode.DEFINE>();
            if (this.token != 78) {
                do {
                    vars.add(this.parseParameter());
                    if (this.token != 86) continue;
                    this.scan();
                    vararg_flags.set(vars_list.size());
                    break;
                } while (this.scan(87));
            }
            this.expect(78);
            vars_list.add(vars);
        } while (this.scan(77));
        if (this.token == 85) {
            this.scan();
            body = this.parseExpressionStatement();
        } else if (this.token == 81) {
            this.scan();
            if (this.looksLikeWithPattern()) {
                vars = (List)vars_list.get(0);
                ELNode[] args = new ELNode[vars.size()];
                for (int i = 0; i < args.length; ++i) {
                    ELNode.DEFINE var = (ELNode.DEFINE)vars.get(i);
                    args[i] = new ELNode.IDENT(var.pos, var.id);
                }
                body = this.parseWithPatterns(this.pos, args);
            } else {
                body = this.parseCompoundExpression(this.pos);
            }
            this.expect(82);
        } else {
            body = null;
        }
        boolean bl = isAbstract = meta != null && (meta.modifiers & 0x400) != 0;
        if (isAbstract && body != null) {
            throw this.parseError(p, Resources._T("EL_INVALID_METHOD_BODY"));
        }
        if (!isAbstract && body == null) {
            throw this.parseError(p, Resources._T("EL_NO_METHOD_BODY"));
        }
        int i = vars_list.size();
        while (--i >= 0) {
            boolean vararg = vararg_flags.get(i);
            ELNode.DEFINE[] vars2 = this.checkVars(p, (List)vars_list.get(i), vararg);
            if (i == 0) {
                body = new ELNode.LAMBDA(p, this.filename, name, rtype, vars2, vararg, body);
                continue;
            }
            body = new ELNode.LAMBDA(p, this.filename, null, null, vars2, vararg, body);
        }
        return body;
    }

    private ELNode.DEFINE parseParameter() {
        ELNode exp;
        int p = this.pos;
        boolean immediate = !this.scan(12);
        String var = this.scanQName();
        this.expect(47);
        String type = this.parseTypeNameOpt();
        ELNode eLNode = exp = this.scan(0) ? this.parseExpression() : null;
        if ("_".equals(var)) {
            var = this.tempvar();
        }
        return new ELNode.DEFINE(p, var, type, null, exp, immediate);
    }

    private ELNode.DEFINE[] checkVars(int p, List<ELNode.DEFINE> varlist, boolean varargs) {
        ELNode.DEFINE[] vars = Parser.to_a(varlist);
        this.checkVars(p, vars, varargs);
        return vars;
    }

    private void checkVars(int p, ELNode.DEFINE[] vars, boolean varargs) {
        for (int i = 1; i < vars.length; ++i) {
            String id = vars[i].id;
            for (int j = 0; j < i; ++j) {
                if (!id.equals(vars[j].id)) continue;
                throw this.parseError(p, Resources._T("EL_DUPLICATE_VAR_NAME", id));
            }
        }
        boolean found_dval = false;
        for (ELNode.DEFINE var : vars) {
            if (var.expr != null) {
                found_dval = true;
                continue;
            }
            if (!found_dval) continue;
            throw this.parseError(p, Resources._T("EL_NON_DFLT_ARG_FOLLOWS_DFLT_ARG"));
        }
        if (found_dval && varargs) {
            throw this.parseError(p, Resources._T("EL_NON_DFLT_ARG_FOLLOWS_DFLT_ARG"));
        }
    }

    private ELNode parseCompoundExpression(int p) {
        return this.parseCompoundExpression(p, false);
    }

    private ELNode parseCompoundExpression(int p, boolean atexp) {
        ArrayList<ELNode> exps = new ArrayList<ELNode>();
        while (this.token != 82) {
            if (this.token == 83 && atexp) {
                exps.add(this.parseExpressionStatement());
                continue;
            }
            this.parseStatementList(exps);
        }
        if (exps.size() == 0) {
            return new ELNode.NULL(p);
        }
        if (exps.size() == 1) {
            return (ELNode)exps.get(0);
        }
        return new ELNode.COMPOUND(p, Parser.to_a(exps));
    }

    private void parseStatementList(List<ELNode> stmts) {
        switch (this.token) {
            case 88: {
                this.scan();
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 83: 
            case 92: {
                for (ELNode.DEFINE e : this.parseDefinitions(this.parseMetaData())) {
                    this.checkVar(e, false);
                    stmts.add(e);
                }
                break;
            }
            case 93: {
                stmts.add(this.parseClassDefinition(this.scan(), null));
                break;
            }
            case 73: {
                stmts.add(this.parseVoidExpression());
                this.expect(88);
                break;
            }
            case 81: {
                stmts.add(this.parseExpressionStatement());
                this.expect(88);
                break;
            }
            default: {
                ELNode stmt = this.parseStatement();
                if (stmt instanceof ELNode.COMPOUND) {
                    if (((ELNode.COMPOUND)stmt).exps.length == 0) break;
                    stmts.add(stmt);
                    break;
                }
                stmts.add(stmt);
            }
        }
    }

    private ELNode parseStatement() {
        ELNode e;
        switch (this.token) {
            case 88: {
                e = new ELNode.COMPOUND(this.scan(), EMPTY_EXPS);
                break;
            }
            case 81: {
                e = this.parseCompoundExpression(this.scan());
                this.expect(82);
                break;
            }
            case 98: {
                e = this.parseIfExpression(this.scan());
                break;
            }
            case 101: {
                e = this.parseWhileExpression(this.scan());
                break;
            }
            case 100: {
                e = this.parseForExpression(this.scan());
                break;
            }
            case 97: {
                int p = this.scan();
                Scanner mark = this.save();
                ELNode pattern = (ELNode)((Object)this.parsePatternOpt());
                if (pattern != null && this.scan(0)) {
                    return new ELNode.LET(p, pattern, this.parseExpressionStatement());
                }
                this.restore(mark);
                return this.parseLetExpression(p);
            }
            case 102: {
                e = this.parseSwitchExpression(this.scan());
                break;
            }
            case 110: {
                e = this.parseTryExpression(this.scan());
                break;
            }
            case 69: {
                e = this.parseSynchronizedExpression(this.scan());
                break;
            }
            case 96: {
                e = new ELNode.UNDEF(this.scan(), this.scanQName());
                this.expect(47);
                this.expect(88);
                break;
            }
            case 106: {
                e = new ELNode.BREAK(this.scan());
                this.expect(88);
                break;
            }
            case 107: {
                e = new ELNode.CONTINUE(this.scan());
                this.expect(88);
                break;
            }
            case 108: {
                int p = this.scan();
                e = this.scanLayout() ? new ELNode.RETURN(p, new ELNode.NULL(p)) : new ELNode.RETURN(p, this.parseExpression());
                this.expect(88);
                break;
            }
            case 109: {
                e = new ELNode.THROW(this.scan(), this.parseExpression());
                this.expect(88);
                break;
            }
            case 113: {
                e = this.parseAssertExpression(this.scan());
                break;
            }
            default: {
                e = this.parseExpressionStatement();
                this.expect(88);
            }
        }
        return e;
    }

    private List<ELNode.DEFINE> parseDefinitions(ELNode.METASET meta) {
        ArrayList<ELNode.DEFINE> defs = new ArrayList<ELNode.DEFINE>();
        if (this.token == 93) {
            defs.add(this.parseClassDefinition(this.scan(), meta));
        } else {
            do {
                defs.add(this.parseSingleDefinition(meta, false));
            } while (this.scan(87));
            this.expect(88);
        }
        return defs;
    }

    private ELNode.DEFINE parseSingleDefinition(ELNode.METASET meta, boolean toplevel) {
        ELNode exp;
        boolean immediate;
        int p = this.pos;
        int oper = -1;
        int prec = 0;
        if (toplevel && meta != null) {
            for (ELNode.METADATA data : meta.metadata) {
                if (data.type.equals("infix")) {
                    oper = 3;
                    prec = this.getOperatorPrecedence(data);
                    break;
                }
                if (data.type.equals("prefix")) {
                    oper = 2;
                    prec = this.getOperatorPrecedence(data);
                    break;
                }
                if (!data.type.equals("keyword")) continue;
                oper = 4;
                break;
            }
        }
        if (this.token == 73) {
            this.scan();
            String id = this.scanVarName(oper, prec);
            ELNode exp2 = this.parseProcedureDefinition(id, "void", meta);
            return new ELNode.DEFINE(p, id, null, meta, exp2, true);
        }
        String id = this.scanVarName(oper, prec);
        String type = this.parseTypeNameOpt();
        switch (this.token) {
            case 0: {
                this.scan();
                if (this.token == 12) {
                    immediate = false;
                    this.scan();
                } else {
                    immediate = true;
                }
                exp = this.parseExpressionStatement();
                break;
            }
            case 77: {
                exp = this.parseProcedureDefinition(id, type, meta);
                type = null;
                immediate = true;
                break;
            }
            case 85: {
                this.scan();
                ELNode body = this.parseExpressionStatement();
                exp = new ELNode.LAMBDA(p, this.filename, id, type, EMPTY_DEFS, false, body);
                type = null;
                immediate = true;
                break;
            }
            default: {
                if (oper != -1) {
                    return null;
                }
                exp = new ELNode.NULL(this.pos);
                immediate = true;
            }
        }
        return new ELNode.DEFINE(p, id, type, meta, exp, immediate);
    }

    private String scanVarName(int oper, int prec) {
        String id;
        if (oper != -1 && this.token == 52) {
            id = this.stringValue;
            this.scan();
        } else if (this.token == 2 || this.token == 3) {
            id = this.operator.name;
            this.scan();
        } else {
            id = this.scanQName();
            this.expect(47);
        }
        if (oper != -1) {
            this.addOperator(id, oper, prec);
        }
        return id;
    }

    private int getOperatorPrecedence(ELNode.METADATA data) {
        if (data.keys.length == 0) {
            return 17;
        }
        if (data.keys.length == 1 && data.keys[0].equals("value") && data.values[0] instanceof ELNode.NUMBER) {
            return ((ELNode.NUMBER)data.values[0]).value.intValue();
        }
        throw this.parseError(data.pos, "Invalid precedence declaration.");
    }

    private ELNode parseVoidExpression() {
        this.mark();
        int p = this.scan();
        if (this.token == 47) {
            String id = this.scanQName();
            this.scan();
            if (this.token == 77) {
                ELNode e = this.parseProcedureDefinition(id, "void", null);
                return new ELNode.DEFINE(p, id, null, null, e, true);
            }
        }
        this.reset();
        return this.parseExpressionStatement();
    }

    private ELNode.DEFINE parseClassDefinition(int p, ELNode.METASET meta) {
        String base = null;
        String[] ifaces = null;
        ELNode.DEFINE[] vars = null;
        ELNode.DEFINE[] body = null;
        String id = this.scanQName();
        this.expect(47);
        if (this.token == 77) {
            this.scan();
            if (this.token != 78) {
                ArrayList<ELNode.DEFINE> vlist = new ArrayList<ELNode.DEFINE>();
                do {
                    ELNode.METASET vmeta = this.parseMetaData();
                    String var = this.scanQName();
                    this.expect(47);
                    String type = this.parseTypeNameOpt();
                    ELNode exp = this.scan(0) ? this.parseExpression() : null;
                    ELNode.DEFINE def = new ELNode.DEFINE(p, var, type, vmeta, exp, true);
                    vlist.add(this.checkMember(def, vlist));
                } while (this.scan(87));
                vars = Parser.to_a(vlist);
            }
            this.expect(78);
        }
        if (this.token == 75) {
            this.scan();
            base = this.parseClassLiteral(false);
        } else if (this.token == 94 || this.token == 95) {
            if (this.token == 94) {
                this.scan();
                base = this.parseClassLiteral(false);
            }
            if (this.token == 95) {
                this.scan();
                ArrayList<String> iflist = new ArrayList<String>();
                do {
                    iflist.add(this.parseClassLiteral(false));
                } while (this.scan(87));
                ifaces = Parser.to_a(iflist);
            }
        }
        if (this.token == 81) {
            this.scan();
            body = this.parseClassBody();
        } else {
            body = EMPTY_DEFS;
        }
        ELNode.CLASSDEF cdef = new ELNode.CLASSDEF(p, this.filename, id, base, ifaces, vars, body);
        return new ELNode.DEFINE(p, id, null, meta, cdef, true);
    }

    private ELNode.DEFINE[] parseClassBody() {
        ArrayList<ELNode.DEFINE> body = new ArrayList<ELNode.DEFINE>();
        ArrayList<ELNode> clinit = new ArrayList<ELNode>();
        block7: while (true) {
            ELNode.DEFINE def;
            if (this.token == 88) {
                this.scan();
                continue;
            }
            if (this.token == 82) break;
            if (this.token == 66) {
                this.mark();
                this.scan();
                if (this.token == 81) {
                    clinit.add(this.parseCompoundExpression(this.scan()));
                    this.expect(82);
                    continue;
                }
                this.reset();
            }
            ELNode.METASET meta = this.parseMetaData();
            ELNode rule = this.matchPrefixSyntaxRule();
            if (rule != null) {
                if (!(rule instanceof ELNode.NULL)) {
                    if (rule instanceof ELNode.DEFINE) {
                        ELNode.DEFINE def2 = this.combineMetaData((ELNode.DEFINE)rule, meta);
                        body.add(this.checkMember(def2, body));
                    } else if (rule instanceof ELNode.COMPOUND) {
                        for (ELNode e : ((ELNode.COMPOUND)rule).exps) {
                            if (!(e instanceof ELNode.DEFINE)) {
                                throw this.parseError(e.pos, Resources._T("EL_IDENTIFIER_EXPECTED"));
                            }
                            def = this.combineMetaData((ELNode.DEFINE)e, meta);
                            body.add(this.checkMember(def, body));
                        }
                    } else {
                        throw this.parseError(rule.pos, Resources._T("EL_IDENTIFIER_EXPECTED"));
                    }
                }
                this.expect(88);
                continue;
            }
            if (this.token == 47 || this.token == 73 || this.token == 93) {
                Iterator<ELNode.DEFINE> i$ = this.parseDefinitions(meta).iterator();
                while (true) {
                    if (!i$.hasNext()) continue block7;
                    ELNode.DEFINE e = i$.next();
                    body.add(this.checkMember(e, body));
                }
            }
            int p = this.pos;
            String opname = null;
            boolean reverse = false;
            if (this.token == 76) {
                this.scan();
                reverse = true;
            }
            switch (this.token) {
                case 3: 
                case 10: 
                case 11: 
                case 12: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 29: 
                case 30: {
                    opname = this.operator.name;
                    if (reverse) {
                        opname = "?" + opname;
                    }
                    this.scan();
                    break;
                }
                case 1: 
                case 2: 
                case 13: 
                case 14: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 33: 
                case 34: 
                case 37: 
                case 38: 
                case 40: {
                    opname = this.operator.name;
                    this.scan();
                    break;
                }
                case 79: {
                    this.scan();
                    this.expect(80);
                    if (this.token == 0) {
                        this.scan();
                        opname = "[]=";
                        break;
                    }
                    opname = "[]";
                    break;
                }
                case 47: {
                    assert (reverse);
                    opname = "?" + this.idValue;
                    this.scan();
                    break;
                }
                case -1: {
                    throw this.incomplete("Unexpected EOF");
                }
                default: {
                    throw this.parseError("Unexpected token: " + this.token_value());
                }
            }
            if (reverse && !opname.startsWith("?")) {
                throw this.parseError("Unexpected token: " + opname);
            }
            ELNode exp = this.parseProcedureDefinition(opname, null, meta);
            def = new ELNode.DEFINE(p, opname, null, meta, exp, true);
            body.add(this.checkMember(def, body));
            this.expect(88);
        }
        this.scan();
        if (!clinit.isEmpty()) {
            int p = ((ELNode)clinit.get((int)0)).pos;
            ELNode.COMPOUND stmt = new ELNode.COMPOUND(p, Parser.to_a(clinit));
            ELNode.LAMBDA proc = new ELNode.LAMBDA(p, this.filename, EMPTY_DEFS, stmt);
            ELNode.METASET meta = new ELNode.METASET(p, 8);
            body.add(new ELNode.DEFINE(p, "__clinit__", null, meta, proc, true));
        }
        return Parser.to_a(body);
    }

    private ELNode.DEFINE combineMetaData(ELNode.DEFINE def, ELNode.METASET meta) {
        if (meta == null) {
            return def;
        }
        if (def.meta != null) {
            meta = def.meta.combine(meta);
        }
        return new ELNode.DEFINE(def.pos, def.id, def.type, meta, def.expr, def.immediate);
    }

    private ELNode.DEFINE checkMember(ELNode.DEFINE var, List<ELNode.DEFINE> vars) {
        String name = var.id;
        for (ELNode.DEFINE v : vars) {
            if (!name.equals(v.id)) continue;
            throw this.parseError(var.pos, Resources._T("EL_DUPLICATE_VAR_NAME", name));
        }
        if (var.meta != null) {
            int mod = var.meta.modifiers;
            int mask = 31;
            if (var.expr instanceof ELNode.CLASSDEF) {
                mask |= 0x411;
            } else if (var.expr instanceof ELNode.LAMBDA) {
                mask |= 0x420;
            }
            int illegal = var.meta.modifiers & ~mask;
            if (illegal != 0) {
                throw this.parseError(var.pos, Resources._T("EL_INVALID_MODIFIER", this.modifierNames(illegal)));
            }
            if (var.expr instanceof ELNode.CLASSDEF) {
                this.checkDisjoint(var.pos, mod, 1024, 16);
            } else if (var.expr instanceof ELNode.LAMBDA) {
                this.checkDisjoint(var.pos, mod, 1024, 56);
            }
            this.checkDisjoint(var.pos, mod, 1, 6);
            this.checkDisjoint(var.pos, mod, 2, 5);
        }
        return var;
    }

    private ELNode.DEFINE checkVar(ELNode.DEFINE var, boolean toplevel) {
        if (var.meta != null) {
            int illegal;
            int mod = var.meta.modifiers;
            int mask = var.expr instanceof ELNode.CLASSDEF ? 1041 : (var.expr instanceof ELNode.LAMBDA ? 0 : 16);
            if (toplevel) {
                mask |= 7;
            }
            if ((illegal = mod & ~mask) != 0) {
                throw this.parseError(var.pos, Resources._T("EL_INVALID_MODIFIER", this.modifierNames(illegal)));
            }
            if (var.expr instanceof ELNode.CLASSDEF) {
                this.checkDisjoint(var.pos, mod, 1024, 16);
            }
        }
        return var;
    }

    private void checkDisjoint(int pos, int mod, int set1, int set2) {
        if ((mod & set1) != 0 && (mod & set2) != 0) {
            throw this.parseError(pos, Resources._T("EL_INVALID_MODIFIER_COMBINATION", this.modifierNames(mod & set1), this.modifierNames(mod & set2)));
        }
    }

    private String modifierNames(int mod) {
        StringBuilder buf = new StringBuilder();
        if ((mod & 1) != 0) {
            buf.append("public ");
        }
        if ((mod & 4) != 0) {
            buf.append("protected ");
        }
        if ((mod & 2) != 0) {
            buf.append("private ");
        }
        if ((mod & 8) != 0) {
            buf.append("static ");
        }
        if ((mod & 0x10) != 0) {
            buf.append("final ");
        }
        if ((mod & 0x400) != 0) {
            buf.append("abstract ");
        }
        if ((mod & 0x20) != 0) {
            buf.append("synchronized ");
        }
        return buf.toString().trim();
    }

    private ELNode parseMetaExpression() {
        if (this.token == 83) {
            boolean nokey;
            int p = this.scan();
            String type = this.idValue;
            this.expect(47);
            if (this.token != 77) {
                return new ELNode.METADATA(p, type, EMPTY_VARS, EMPTY_EXPS);
            }
            this.scan();
            if (this.token == 78) {
                this.scan();
                return new ELNode.METADATA(p, type, EMPTY_VARS, EMPTY_EXPS);
            }
            ArrayList<String> keys = new ArrayList<String>();
            ArrayList<ELNode> values = new ArrayList<ELNode>();
            if (this.token == 47) {
                this.mark();
                this.scan();
                nokey = this.token != 0;
                this.reset();
            } else {
                nokey = true;
            }
            if (nokey) {
                keys.add("value");
                values.add(this.parseMetaExpression());
            } else {
                do {
                    keys.add(this.idValue);
                    this.expect(47);
                    this.expect(0);
                    values.add(this.parseMetaExpression());
                } while (this.scan(87));
            }
            this.expect(78);
            return new ELNode.METADATA(p, type, Parser.to_a(keys), Parser.to_a(values));
        }
        if (this.token == 79 || this.token == 81) {
            this.mark();
            int close = this.token == 79 ? 80 : 82;
            int p = this.scan();
            if (this.token == 83) {
                ArrayList<ELNode> elems = new ArrayList<ELNode>();
                do {
                    if (this.token != 83) {
                        this.expect(83);
                        continue;
                    }
                    elems.add(this.parseMetaExpression());
                } while (this.scan(87));
                this.expect(close);
                return new ELNode.LIST(p, Parser.to_a(elems), null);
            }
            this.reset();
            return this.parseExpression();
        }
        return this.parseExpression();
    }

    private ELNode.METASET parseMetaData() {
        ArrayList<ELNode.METADATA> data = new ArrayList<ELNode.METADATA>();
        int mod = 0;
        while (this.token == 83) {
            data.add((ELNode.METADATA)this.parseMetaExpression());
        }
        if (this.token == 92) {
            this.scan();
        }
        block11: while (true) {
            int nextmod = 0;
            switch (this.token) {
                case 63: {
                    nextmod = 1;
                    break;
                }
                case 64: {
                    nextmod = 4;
                    break;
                }
                case 65: {
                    nextmod = 2;
                    break;
                }
                case 66: {
                    nextmod = 8;
                    break;
                }
                case 67: {
                    nextmod = 16;
                    break;
                }
                case 68: {
                    nextmod = 1024;
                    break;
                }
                case 69: {
                    nextmod = 32;
                    break;
                }
                case 83: {
                    data.add((ELNode.METADATA)this.parseMetaExpression());
                    break;
                }
                default: {
                    break block11;
                }
            }
            if (nextmod == 0) continue;
            if ((mod & nextmod) != 0) {
                throw this.parseError(Resources._T("EL_REPEATED_MODIFIER", this.idValue));
            }
            mod |= nextmod;
            this.scan();
        }
        if (data.size() == 0 && mod == 0) {
            return null;
        }
        ELNode.METADATA[] meta = data.toArray(new ELNode.METADATA[data.size()]);
        return new ELNode.METASET(this.pos, meta, mod);
    }

    private ELNode parseLetExpression(int p) {
        ELNode body;
        String type;
        String name;
        ArrayList<ELNode.Pattern> pats = new ArrayList<ELNode.Pattern>();
        ArrayList<ELNode> exps = new ArrayList<ELNode>();
        if (this.idValue != null) {
            name = this.scanQName();
            this.expect(47);
            type = this.parseTypeNameOpt();
        } else {
            type = null;
            name = null;
        }
        this.expect(77);
        if (this.token != 78) {
            do {
                pats.add(this.parsePattern());
                this.expect(0);
                exps.add(this.parseExpression());
            } while (this.scan(87));
        }
        this.expect(78);
        if (this.token == 81) {
            body = this.parseCompoundExpression(this.scan());
            this.expect(82);
        } else {
            body = this.parseSyntaxExpression();
        }
        ELNode.LAMBDA lambda = this.translateLambda(p, name, type, pats, false, body);
        return new ELNode.APPLY(p, lambda, Parser.to_a(exps), null);
    }

    private ELNode parseIfExpression(int p) {
        this.expect(77);
        ELNode c = this.parseSyntaxExpression();
        this.expect(78);
        ELNode t = this.parseStatement();
        if (this.token == 99) {
            this.scan();
            return new ELNode.COND(p, c, t, this.parseStatement());
        }
        return new ELNode.COND(p, c, t, (ELNode)new ELNode.NULL(this.pos));
    }

    private ELNode parseForExpression(int p) {
        boolean foreach = false;
        ELNode idx_pat = null;
        ELNode var_pat = null;
        ELNode range = null;
        ELNode[] init = null;
        ELNode cond = null;
        ELNode[] step = null;
        this.expect(77);
        boolean local = this.scan(92);
        Scanner mark = this.save();
        var_pat = (ELNode)((Object)this.parsePatternOpt());
        if (var_pat != null) {
            if (this.scan(87)) {
                idx_pat = var_pat;
                var_pat = (ELNode)((Object)this.parsePatternOpt());
            }
            if (var_pat != null && this.scan(32)) {
                foreach = true;
                range = this.parseExpression();
            }
        }
        if (!foreach) {
            this.restore(mark);
            if (this.token != 88) {
                if (local) {
                    init = Parser.to_a(this.parseDefinitions(null));
                } else {
                    ArrayList<ELNode> exps = new ArrayList<ELNode>();
                    do {
                        exps.add(this.parseExpression());
                    } while (this.scan(87));
                    init = Parser.to_a(exps);
                    this.expect(88);
                }
            } else {
                this.scan();
            }
            cond = this.token != 88 ? this.parseExpression() : new ELNode.BOOLEANVAL(this.pos, true);
            this.expect(88);
            if (this.token != 78) {
                ArrayList<ELNode> args = new ArrayList<ELNode>();
                do {
                    args.add(this.parseExpression());
                } while (this.scan(87));
                step = Parser.to_a(args);
            }
        }
        this.expect(78);
        ELNode body = this.parseStatement();
        if (foreach) {
            ELNode.DEFINE var_def;
            ELNode.DEFINE idx_def = null;
            if (idx_pat == null) {
                if (Parser.isVariablePattern(var_pat)) {
                    var_def = (ELNode.DEFINE)var_pat;
                } else {
                    String var_t = this.tempvar();
                    var_def = new ELNode.DEFINE(p, var_t, null);
                    body = new ELNode.WITH(p, (ELNode)new ELNode.IDENT(p, var_t), new ELNode.MATCHCASE(p, (ELNode.Pattern)((Object)var_pat), null, body), (ELNode)new ELNode.NULL(p));
                }
            } else if (Parser.isVariablePattern(var_pat) && Parser.isVariablePattern(idx_pat)) {
                var_def = (ELNode.DEFINE)var_pat;
                idx_def = (ELNode.DEFINE)idx_pat;
            } else {
                String var_t = this.tempvar();
                String idx_t = this.tempvar();
                var_def = new ELNode.DEFINE(p, var_t, null);
                idx_def = new ELNode.DEFINE(p, idx_t, null);
                body = new ELNode.WITH(p, new ELNode[]{new ELNode.IDENT(p, idx_t), new ELNode.IDENT(p, var_t)}, new ELNode.MATCHCASE(p, new ELNode.Pattern[]{(ELNode.Pattern)((Object)idx_pat), (ELNode.Pattern)((Object)var_pat)}, null, body), (ELNode)new ELNode.NULL(p));
            }
            return new ELNode.FOREACH(p, idx_def, var_def, range, body);
        }
        return new ELNode.FOR(p, init, cond, step, body, local);
    }

    private ELNode parseWhileExpression(int p) {
        this.expect(77);
        ELNode cond = this.parseSyntaxExpression();
        this.expect(78);
        return new ELNode.WHILE(p, cond, this.parseStatement());
    }

    private ELNode parseSwitchExpression(int p) {
        ArrayList<ELNode.CASE> cases = new ArrayList<ELNode.CASE>();
        ArrayList<ELNode> exps = new ArrayList<ELNode>();
        ArrayList<ELNode> list = new ArrayList<ELNode>();
        int caseIndex = 0;
        this.expect(77);
        ELNode arg = this.parseSyntaxExpression();
        this.expect(78);
        this.expect(81);
        while (this.token != -1 && this.token != 82) {
            do {
                if (this.token == 104) {
                    int p2 = this.scan();
                    do {
                        cases.add(new ELNode.CASE(p2, this.parseNonColonExpression(false)));
                    } while (this.scan(87));
                    this.expect(74);
                    continue;
                }
                if (this.token == 105) {
                    cases.add(new ELNode.CASE(this.scan(), null));
                    this.expect(74);
                    continue;
                }
                this.expect(104);
            } while (this.token == 104 || this.token == 105);
            list.clear();
            while (this.token != 104 && this.token != 105 && this.token != 82) {
                this.parseStatementList(list);
            }
            int expIndex = exps.size();
            while (caseIndex < cases.size()) {
                ((ELNode.CASE)cases.get((int)caseIndex++)).index = expIndex;
            }
            if (list.size() == 0) {
                exps.add(new ELNode.NULL(this.pos));
                continue;
            }
            if (list.size() == 1) {
                exps.add((ELNode)list.get(0));
                continue;
            }
            exps.add(new ELNode.COMPOUND(p, Parser.to_a(list)));
        }
        this.expect(82);
        return new ELNode.SWITCH(p, arg, cases.toArray(new ELNode.CASE[cases.size()]), Parser.to_a(exps));
    }

    private ELNode parseWithExpression(int p) {
        ArrayList<ELNode> args = new ArrayList<ELNode>();
        this.expect(77);
        do {
            args.add(this.parseSyntaxExpression());
        } while (this.scan(87));
        this.expect(78);
        this.expect(81);
        ELNode exp = this.parseWithPatterns(p, Parser.to_a(args));
        this.expect(82);
        return exp;
    }

    private ELNode parseWithPatterns(int p, ELNode[] args) {
        ArrayList<ELNode.MATCHCASE> alternates = new ArrayList<ELNode.MATCHCASE>();
        ELNode deflt = null;
        while (this.scan(74)) {
            ELNode body;
            ELNode.Pattern[] patterns = null;
            ELNode guard = null;
            int p2 = this.pos;
            if (this.token == 99) {
                this.scan();
            } else {
                if (this.token != 98) {
                    ArrayList<ELNode.Pattern> pats = new ArrayList<ELNode.Pattern>();
                    do {
                        pats.add(this.parsePattern());
                    } while (this.scan(87));
                    if (pats.size() != args.length) {
                        throw this.parseError("argument pattern doesn't match.");
                    }
                    patterns = pats.toArray(new ELNode.Pattern[pats.size()]);
                }
                if (this.scan(98)) {
                    guard = this.parseExpression();
                }
            }
            this.expect(85);
            if (this.token == 81) {
                body = this.parseCompoundExpression(this.scan());
                this.expect(82);
            } else {
                int p3 = this.pos;
                ArrayList<ELNode> stmts = new ArrayList<ELNode>();
                do {
                    this.parseStatementList(stmts);
                } while (this.token != 82 && !this.looksLikeWithPattern());
                body = new ELNode.COMPOUND(p3, Parser.to_a(stmts));
            }
            if (patterns == null && guard == null) {
                deflt = body;
                break;
            }
            alternates.add(new ELNode.MATCHCASE(p2, patterns, guard, body));
        }
        ELNode.MATCHCASE[] alts = alternates.toArray(new ELNode.MATCHCASE[alternates.size()]);
        return new ELNode.WITH(p, args, alts, deflt);
    }

    private boolean looksLikeWithPattern() {
        if (this.token != 74) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(this.ch)) {
            return true;
        }
        Scanner mark = this.save();
        this.scan();
        if (this.token == 99 || this.token == 98) {
            this.restore(mark);
            return true;
        }
        do {
            if (this.parsePatternOpt() != null) continue;
            this.restore(mark);
            return false;
        } while (this.scan(87));
        int t = this.token;
        this.restore(mark);
        return t == 98 || t == 85;
    }

    private static boolean isVariablePattern(Object pat) {
        return pat instanceof ELNode.DEFINE && ((ELNode.DEFINE)pat).expr == null;
    }

    private ELNode.Pattern parsePatternOpt() {
        try {
            return this.parsePattern();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private ELNode.Pattern parsePattern() {
        switch (this.token) {
            case 47: {
                String id = this.idValue;
                int p = this.scan();
                if (this.token == 77) {
                    this.scan();
                    return this.parseConstructorPattern(p, id);
                }
                String type = this.parseTypeNameOpt();
                ELNode apat = null;
                if (this.token == 83) {
                    this.scan();
                    apat = (ELNode)((Object)this.parsePattern());
                }
                return new ELNode.DEFINE(p, id, type, null, apat, true);
            }
            case 12: {
                int p = this.scan();
                String id = this.idValue;
                this.expect(47);
                String type = this.parseTypeNameOpt();
                return new ELNode.DEFINE(p, id, type, null, null, false);
            }
            case 49: {
                char val = this.charValue;
                return new ELNode.CHARVAL(this.scan(), val);
            }
            case 50: {
                Number val = this.numberValue;
                return new ELNode.NUMBER(this.scan(), val);
            }
            case 52: {
                String val = this.stringValue;
                return new ELNode.STRINGVAL(this.scan(), val);
            }
            case 74: {
                if (Character.isJavaIdentifierStart((char)this.ch)) {
                    this.scan();
                    String id = this.idValue;
                    return new ELNode.SYMBOL(this.scan(), Symbol.valueOf(id));
                }
                if (this.ch != 39 && this.ch != 34) break;
                this.scan();
                String id = this.stringValue;
                return new ELNode.SYMBOL(this.scan(), Symbol.valueOf(id));
            }
            case 27: {
                ELNode.REGEXP exp = new ELNode.REGEXP(this.pos, this.scanRegexp());
                this.scan();
                return exp;
            }
            case 70: {
                return new ELNode.BOOLEANVAL(this.scan(), true);
            }
            case 71: {
                return new ELNode.BOOLEANVAL(this.scan(), false);
            }
            case 72: {
                return new ELNode.NULL(this.scan());
            }
            case 24: {
                int p = this.scan();
                Number v = this.numberValue;
                this.expect(50);
                return new ELNode.NUMBER(p, v);
            }
            case 25: {
                int p = this.scan();
                Number v = this.numberValue;
                this.expect(50);
                v = v instanceof BigInteger ? ((BigInteger)v).negate() : (v instanceof BigDecimal ? ((BigDecimal)v).negate() : (v instanceof Decimal ? ((Decimal)v).negate() : (v instanceof Rational ? ((Rational)v).negate() : (v instanceof Double ? (Number)(-v.doubleValue()) : (Number)(v instanceof Long ? (Number)(-v.longValue()) : (Number)(-v.intValue()))))));
                return new ELNode.NUMBER(p, v);
            }
            case 79: {
                return this.parseListPattern(this.scan());
            }
            case 77: {
                return this.parseTuplePattern(this.scan());
            }
            case 81: {
                return this.parseMapPattern(this.scan());
            }
        }
        throw this.parseError("Invalid pattern.");
    }

    private ELNode.Pattern parseListPattern(int p) {
        ArrayList<ELNode> head = new ArrayList<ELNode>();
        ELNode tail = null;
        if (this.token != 80) {
            do {
                head.add((ELNode)((Object)this.parsePattern()));
            } while (this.scan(87));
        }
        if (this.token == 74) {
            this.scan();
            tail = (ELNode)((Object)this.parsePattern());
        }
        this.expect(80);
        return new ELNode.LIST(p, Parser.to_a(head), tail);
    }

    private ELNode.Pattern parseTuplePattern(int p) {
        ArrayList<ELNode> elems = new ArrayList<ELNode>();
        if (this.token != 78) {
            do {
                elems.add((ELNode)((Object)this.parsePattern()));
            } while (this.scan(87));
        }
        this.expect(78);
        return new ELNode.TUPLE(p, Parser.to_a(elems));
    }

    private ELNode.Pattern parseMapPattern(int p) {
        ArrayList<ELNode> keys = new ArrayList<ELNode>();
        ArrayList<ELNode> values = new ArrayList<ELNode>();
        do {
            if (this.token == 47) {
                keys.add(new ELNode.STRINGVAL(this.pos, this.idValue));
                this.scan();
            } else if (this.token == 52) {
                keys.add(new ELNode.STRINGVAL(this.pos, this.stringValue));
                this.scan();
            } else {
                this.expect(47);
                return null;
            }
            this.expect(74);
            values.add((ELNode)((Object)this.parsePattern()));
        } while (this.scan(87));
        this.expect(82);
        return new ELNode.MAP(p, Parser.to_a(keys), Parser.to_a(values));
    }

    private ELNode.Pattern parseConstructorPattern(int p, String id) {
        ArrayList<ELNode> args = new ArrayList<ELNode>();
        ArrayList<String> keys = new ArrayList<String>();
        if (this.token != 78) {
            do {
                String key;
                if ((key = this.parseArgumentName()) != null) {
                    if (keys.contains(key)) {
                        throw this.parseError(Resources._T("EL_DUPLICATE_ARG_NAME", key));
                    }
                    keys.add(key);
                }
                args.add((ELNode)((Object)this.parsePattern()));
            } while (this.scan(87));
        }
        if (!keys.isEmpty() && keys.size() != args.size()) {
            throw this.parseError(p, "Missing parameter key");
        }
        this.expect(78);
        return new ELNode.NEW(p, id, Parser.to_a(args), keys.isEmpty() ? null : Parser.to_a(keys), null);
    }

    private ELNode parseTryExpression(int p) {
        ELNode.DEFINE[] handlers = null;
        ELNode finalizer = null;
        this.expect(81);
        ELNode body = this.parseCompoundExpression(this.pos);
        this.expect(82);
        if (this.token == 111) {
            ArrayList<ELNode.DEFINE> hlist = new ArrayList<ELNode.DEFINE>();
            while (this.token == 111) {
                int p2 = this.scan();
                this.expect(77);
                String var = this.idValue;
                this.expect(47);
                String type = this.parseTypeNameOpt();
                this.expect(78);
                this.expect(81);
                ELNode handler = this.parseCompoundExpression(this.pos);
                this.expect(82);
                hlist.add(new ELNode.DEFINE(p2, var, type, null, handler, true));
            }
            handlers = Parser.to_a(hlist);
        }
        if (this.token == 112) {
            this.scan();
            this.expect(81);
            finalizer = this.parseCompoundExpression(this.pos);
            this.expect(82);
        }
        if (handlers == null && finalizer == null) {
            if (this.token == -1) {
                throw this.incomplete(Resources._T("EL_TOKEN_EXPECTED", "catch"));
            }
            throw this.parseError(Resources._T("EL_TOKEN_EXPECTED", "catch"));
        }
        return new ELNode.TRY(p, body, handlers, finalizer);
    }

    private ELNode parseCatchExpression(int p) {
        this.expect(77);
        String var = this.idValue;
        this.expect(47);
        this.expect(78);
        this.expect(81);
        ELNode body = this.parseCompoundExpression(this.pos);
        this.expect(82);
        return new ELNode.CATCH(p, var, body);
    }

    private ELNode parseSynchronizedExpression(int p) {
        this.expect(77);
        ELNode exp = this.parseExpression();
        this.expect(78);
        this.expect(81);
        ELNode body = this.parseCompoundExpression(this.pos);
        this.expect(82);
        return new ELNode.SYNCHRONIZED(p, exp, body);
    }

    private ELNode parseAssertExpression(int p) {
        ELNode exp = this.parseExpression();
        ELNode msg = null;
        if (this.scan(87)) {
            msg = this.parseExpression();
        }
        this.expect(88);
        boolean assertionEnabled = false;
        if (!$assertionsDisabled) {
            assertionEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertionEnabled) {
            return new ELNode.ASSERT(p, exp, msg);
        }
        return new ELNode.COMPOUND(p, EMPTY_EXPS);
    }

    private ELNode parseTopLevelExpression() {
        this.nextchar();
        int p = this.scan();
        ELNode e = this.parseLambdaExpressionOpt(p);
        if (e == null) {
            e = this.parseCompoundExpression(p);
        }
        if (this.token == -1) {
            throw this.incomplete(Resources._T("EL_TOKEN_EXPECTED", "}"));
        }
        if (this.token != 82) {
            throw this.parseError(Resources._T("EL_TOKEN_EXPECTED", "}"));
        }
        return e;
    }

    private void parseProgram(ELProgram prog) {
        if (this.nextchar() == 35 && this.lookahead(0) == 33) {
            do {
                this.nextchar();
            } while (this.ch != 13 && this.ch != 10 && this.ch != -1);
        }
        this.scan();
        while (this.token != -1) {
            if (this.token == 83) {
                this.mark();
                this.scan();
                if (this.token == 47 && "compile_time".equals(this.idValue)) {
                    this.scan();
                    Object obj = this.executeCompileTimeProcessor();
                    if (!(obj instanceof Expression)) continue;
                    prog.addExpression(((Expression)obj).getNode());
                    continue;
                }
                this.reset();
                this.parseProgramElement(prog);
                continue;
            }
            this.parseProgramElement(prog);
        }
    }

    private void parseProgramElement(ELProgram prog) {
        switch (this.token) {
            case 88: {
                this.scan();
                break;
            }
            case 89: {
                this.scan();
                String file = this.stringValue;
                this.expect(52);
                this.expect(88);
                this.parseScript(prog, file);
                break;
            }
            case 90: {
                int p = this.scan();
                if (this.scan(66)) {
                    String name = this.parseClassLiteral(true);
                    this.expect(88);
                    prog.addLibrary(name);
                    break;
                }
                if (this.scan(91)) {
                    String prefix = null;
                    if (this.token == 47) {
                        prefix = this.idValue;
                        this.mark();
                        this.scan();
                        if (this.token == 74) {
                            this.scan();
                        } else {
                            this.reset();
                            prefix = null;
                        }
                    }
                    String name = this.parseClassLiteral(false);
                    this.expect(88);
                    prog.addModule(name, prefix);
                    break;
                }
                String name = this.parseClassLiteral(true);
                this.expect(88);
                prog.addImport(name);
                if (name.endsWith(".*")) break;
                String id = name.substring(name.lastIndexOf(46) + 1);
                ELNode.CLASS c = new ELNode.CLASS(p, name);
                prog.addExpression(new ELNode.DEFINE(p, id, null, null, c, true));
                break;
            }
            case 92: {
                this.mark();
                this.scan();
                if (this.token == 47 && this.idValue.equals("syntax")) {
                    this.scan();
                    this.parseSyntaxRule();
                    break;
                }
                if (this.token == 47 && this.idValue.equals("pattern")) {
                    this.scan();
                    this.parseSyntaxPattern();
                    break;
                }
                this.reset();
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 83: {
                ELNode.METASET meta = this.parseMetaData();
                if (this.token == 93) {
                    ELNode.DEFINE e = this.parseClassDefinition(this.scan(), meta);
                    this.checkVar(e, true);
                    prog.addExpression(e);
                    break;
                }
                do {
                    ELNode.DEFINE e;
                    if ((e = this.parseSingleDefinition(meta, true)) == null) continue;
                    this.checkVar(e, true);
                    prog.addExpression(e);
                } while (this.scan(87));
                this.expect(88);
                break;
            }
            case 96: {
                int p = this.scan();
                if (this.token == 2 || this.token == 3 || this.token == 4) {
                    String id = this.operator.name;
                    this.removeOperator(id);
                    prog.addExpression(new ELNode.UNDEF(p, id));
                    this.scan();
                } else {
                    String id = this.scanQName();
                    this.expect(47);
                    if (id.equals("syntax")) {
                        this.scan();
                        id = this.idValue;
                        this.expect(47);
                        this.prefix_syntax_rules.remove(id);
                        this.infix_syntax_rules.remove(id);
                    } else if (id.equals("pattern")) {
                        this.scan();
                        id = this.idValue;
                        this.expect(47);
                        this.pattern_rules.remove(id);
                    } else {
                        prog.addExpression(new ELNode.UNDEF(p, id));
                    }
                }
                this.expect(88);
                break;
            }
            case 93: {
                prog.addExpression(this.parseClassDefinition(this.scan(), null));
                break;
            }
            case 73: {
                prog.addExpression(this.parseVoidExpression());
                this.expect(88);
                break;
            }
            case 81: {
                prog.addExpression(this.parseExpressionStatement());
                this.expect(88);
                break;
            }
            default: {
                ELNode stmt = this.parseStatement();
                if (stmt instanceof ELNode.COMPOUND) {
                    if (((ELNode.COMPOUND)stmt).exps.length == 0) break;
                    prog.addExpression(stmt);
                    break;
                }
                prog.addExpression(stmt);
            }
        }
    }

    private Object executeCompileTimeProcessor() {
        ELProgram processor = new ELProgram();
        int line = Position.line(this.pos);
        this.expect(81);
        while (this.token != -1 && this.token != 82) {
            this.parseProgramElement(processor);
        }
        this.expect(82);
        ELContext elctx = this.getParseContext().getELContext();
        return processor.execute(elctx, this.filename, line);
    }

    private EvaluationContext getParseContext() {
        if (this.parse_context == null) {
            ELContext elctx = ELEngine.createELContext();
            ClassResolver.getInstance(elctx).addImport("elite.ast.*");
            MethodResolver.getInstance(elctx).addGlobalMethods(Expression.class);
            this.parse_context = new EvaluationContext(elctx);
        }
        return this.parse_context;
    }

    private void parseSyntaxRule() {
        String keyword;
        boolean sensitive = true;
        SyntaxRule.Lexeme prefix = null;
        SyntaxRule.KeywordLexeme infix = null;
        SyntaxRule.Accept accept = new SyntaxRule.Accept(this.filename);
        if (this.token == 27) {
            this.scan();
            if (this.token == 47 && this.idValue.equals("ci")) {
                this.scan();
                sensitive = false;
            } else {
                throw this.parseError("Syntax error");
            }
        }
        this.expect(81);
        prefix = this.scanLexeme(sensitive, accept);
        SyntaxRule.NFA start = new SyntaxRule.NFA(prefix);
        SyntaxRule.NFA end = start.next = new SyntaxRule.NFA();
        if (prefix instanceof SyntaxRule.KeywordLexeme) {
            keyword = ((SyntaxRule.KeywordLexeme)prefix).keyword;
        } else if (prefix instanceof SyntaxRule.SymbolLexeme) {
            if (this.idValue != null) {
                keyword = this.idValue;
            } else if (this.token == 4) {
                keyword = this.operator.name;
            } else {
                throw this.parseError("Syntax rule must have an infix keyword");
            }
            infix = new SyntaxRule.KeywordLexeme(keyword, sensitive);
            end.edge = infix;
            end = end.next = new SyntaxRule.NFA();
            this.scan();
        } else {
            throw this.parseError("Syntax rule must hava a prefix keyword");
        }
        while (this.token != 85 && this.token != -1) {
            end = this.buildPattern(end, this.scanLexeme(sensitive, accept));
        }
        this.parseAcceptProduction(accept);
        end.accept = accept;
        if (infix != null) {
            this.infix_syntax_rules.put(keyword, start, sensitive);
        } else {
            this.prefix_syntax_rules.put(keyword, start, sensitive);
        }
    }

    private void parseSyntaxPattern() {
        SyntaxRule.NFA end;
        boolean sensitive = true;
        SyntaxRule.Accept accept = new SyntaxRule.Accept(this.filename);
        if (this.token == 27) {
            this.scan();
            if (this.token == 47 && this.idValue.equals("ci")) {
                this.scan();
                sensitive = false;
            } else {
                throw this.parseError("Syntax error");
            }
        }
        String keyword = this.idValue;
        this.expect(47);
        this.expect(81);
        SyntaxRule.NFA start = end = new SyntaxRule.NFA();
        while (this.token != 85 && this.token != -1) {
            end = this.buildPattern(end, this.scanLexeme(sensitive, accept));
        }
        this.parseAcceptProduction(accept);
        end.accept = accept;
        this.pattern_rules.put(keyword, start, false);
    }

    private SyntaxRule.NFA buildPattern(SyntaxRule.NFA end, SyntaxRule.Lexeme lex) {
        int occurence = lex.getOccurence();
        SyntaxRule.Lexeme delimiter = null;
        if (lex instanceof SyntaxRule.PatternLexeme) {
            delimiter = ((SyntaxRule.PatternLexeme)lex).delimiter;
        }
        if (occurence != -1) {
            SyntaxRule.NFA e2_start = new SyntaxRule.NFA(lex);
            SyntaxRule.NFA e2_end = new SyntaxRule.NFA();
            e2_start.next = new SyntaxRule.NFA();
            e2_start.next.next = e2_end;
            if (occurence == 26 || occurence == 76) {
                end.next2 = e2_end;
            }
            if (occurence == 26 || occurence == 24) {
                if (delimiter != null) {
                    SyntaxRule.NFA e3_start = new SyntaxRule.NFA();
                    SyntaxRule.NFA e3_end = this.buildPattern(e3_start, delimiter);
                    e2_start.next.next2 = e3_start;
                    e3_end.next = e2_start;
                } else {
                    e2_start.next.next2 = e2_start;
                }
            }
            end.next = e2_start;
            end = e2_end;
        } else {
            end.edge = lex;
            end = end.next = new SyntaxRule.NFA();
        }
        return end;
    }

    private void parseAcceptProduction(SyntaxRule.Accept accept) {
        this.expect(85);
        if (this.token == 83) {
            this.mark();
            this.scan();
            if (this.token == 47 && "compile_time".equals(this.idValue)) {
                this.scan();
                if (this.token == 81) {
                    accept.ppexp = this.parseCompoundExpression(this.scan());
                    this.expect(82);
                } else {
                    this.reset();
                }
            } else {
                this.reset();
            }
        }
        accept.template = this.parseCompoundExpression(this.pos);
        this.expect(82);
    }

    private SyntaxRule.Lexeme scanLexeme(boolean sensitive, SyntaxRule.Accept accept) {
        SyntaxRule.Lexeme lex;
        switch (this.token) {
            case 47: {
                String id = this.idValue;
                this.scan();
                if (id.charAt(0) == '$') {
                    if (!accept.addVariable(id)) {
                        throw this.parseError("Duplicate variable name: " + id);
                    }
                    if (this.token == 86 && !this.sawSpace()) {
                        this.scan();
                        lex = new SyntaxRule.IdentifierListLexeme(id);
                        break;
                    }
                    lex = new SyntaxRule.IdentifierLexeme(id);
                    break;
                }
                lex = new SyntaxRule.KeywordLexeme(id, sensitive);
                break;
            }
            case 4: {
                lex = new SyntaxRule.KeywordLexeme(this.operator.name, sensitive);
                this.scan();
                break;
            }
            case 74: {
                if (Character.isJavaIdentifierStart(this.ch)) {
                    this.scan();
                    String id = this.idValue;
                    this.scan();
                    if (!accept.addVariable(id)) {
                        throw this.parseError("Duplicate variable name: " + id);
                    }
                    if (this.token == 86 && !this.sawSpace()) {
                        this.scan();
                        lex = new SyntaxRule.SymbolListLexeme(Symbol.valueOf(id));
                        break;
                    }
                    if (this.token == 0 && this.ch == 47 && !this.sawSpace()) {
                        this.scan();
                        String re = this.scanRegexp();
                        this.scan();
                        lex = new SyntaxRule.RegexLexeme(Pattern.compile(re), Symbol.valueOf(id));
                        break;
                    }
                    lex = new SyntaxRule.SymbolLexeme(Symbol.valueOf(id));
                    break;
                }
                this.scan();
                lex = new SyntaxRule.GenericLexeme(74);
                break;
            }
            case 81: {
                if (this.ch == 58 && Character.isJavaIdentifierStart(this.lookahead(0))) {
                    this.scan();
                    this.scan();
                    String id = this.idValue;
                    this.scan();
                    if (!accept.addVariable(id)) {
                        throw this.parseError("Duplicate variable name: " + id);
                    }
                    if (this.token == 86) {
                        this.scan();
                        this.expect(82);
                        if (this.idValue == null) {
                            throw this.parseError("Statement list must be delimited by keyword");
                        }
                        lex = new SyntaxRule.StatementListLexeme(Symbol.valueOf(id));
                        break;
                    }
                    this.expect(82);
                    lex = new SyntaxRule.StatementLexeme(Symbol.valueOf(id));
                    break;
                }
                if (this.ch == 60 && Character.isJavaIdentifierStart(this.lookahead(0))) {
                    this.scan();
                    lex = this.scanLexeme(sensitive, accept);
                    if (lex instanceof SyntaxRule.PatternLexeme) {
                        ((SyntaxRule.PatternLexeme)lex).transform_to = 2;
                        this.expect(82);
                        break;
                    }
                    throw this.parseError("Syntax error");
                }
                this.scan();
                lex = new SyntaxRule.GenericLexeme(81);
                break;
            }
            case 17: {
                if (Character.isJavaIdentifierStart(this.ch)) {
                    Symbol symbol;
                    SyntaxRule.Lexeme delimiter = null;
                    this.scan();
                    String id = this.idValue;
                    this.scan();
                    if (this.token == 74) {
                        this.scan();
                        symbol = Symbol.valueOf(id);
                        id = this.idValue;
                        this.expect(47);
                    } else {
                        symbol = Symbol.valueOf(id);
                    }
                    if (!accept.addVariable(symbol.getName())) {
                        throw this.parseError("Duplicate variable name: " + symbol.getName());
                    }
                    if (this.token == 79) {
                        this.scan();
                        delimiter = this.scanLexeme(sensitive, accept);
                        this.expect(80);
                    }
                    this.expect(18);
                    lex = new SyntaxRule.PatternLexeme(id, symbol, delimiter);
                    break;
                }
                this.scan();
                lex = new SyntaxRule.GenericLexeme(17);
                break;
            }
            case 49: {
                lex = new SyntaxRule.CharLexeme(this.charValue);
                this.scan();
                break;
            }
            case 50: {
                lex = new SyntaxRule.NumberLexeme(this.numberValue);
                this.scan();
                break;
            }
            case 52: {
                lex = new SyntaxRule.StringLexeme(this.stringValue);
                this.scan();
                break;
            }
            default: {
                lex = this.idValue != null ? new SyntaxRule.KeywordLexeme(this.idValue, sensitive) : new SyntaxRule.GenericLexeme(this.token);
                this.scan();
            }
        }
        if (((SyntaxRule.Lexeme)lex).isExact() && !this.sawSpace() && (this.token == 76 || this.token == 26 || this.token == 24)) {
            lex.setOccurence(this.token);
            this.scan();
        }
        return lex;
    }

    private ELNode matchPrefixSyntaxRule() {
        SyntaxRule rule;
        if (this.token == 47) {
            rule = this.prefix_syntax_rules.get(this.idValue);
        } else if (this.token == 4) {
            rule = this.prefix_syntax_rules.get(this.operator.name);
        } else {
            return null;
        }
        if (rule != null) {
            return this.matchSyntaxRule(rule, new MachineImpl());
        }
        return null;
    }

    private ELNode matchInfixSyntaxRule(ELNode exp) {
        SyntaxRule rule;
        if (this.idValue != null) {
            rule = this.infix_syntax_rules.get(this.idValue);
        } else if (this.token == 4) {
            rule = this.infix_syntax_rules.get(this.operator.name);
        } else {
            return null;
        }
        if (rule != null) {
            return this.matchSyntaxRule(rule, new MachineImpl(exp));
        }
        return null;
    }

    private ELNode matchSyntaxRule(SyntaxRule rule, MachineImpl machine) {
        Scanner mark = this.save();
        SyntaxRule.Accept accept = null;
        boolean conflict = false;
        try {
            machine.init(rule.start);
            while (true) {
                if (!machine.move(this)) {
                    conflict = true;
                    break;
                }
                if (!machine.hasMore()) {
                    accept = machine.accept;
                    break;
                }
                machine.next();
            }
        }
        catch (ParseException ex) {
            this.restore(mark);
            return null;
        }
        if (conflict) {
            this.restore(mark);
            throw this.parseError("Conflict in syntax rules");
        }
        if (accept == null) {
            this.restore(mark);
            return null;
        }
        return accept.transform(this.getParseContext(), machine.variables, machine.bindings);
    }

    public void importSyntaxRules(Parser from) {
        this.prefix_syntax_rules.putAll(from.prefix_syntax_rules);
        this.infix_syntax_rules.putAll(from.infix_syntax_rules);
        this.pattern_rules.putAll(from.pattern_rules);
        this.operator_manager.importFrom(from.operator_manager);
    }

    private void parseScript(ELProgram prog, String path) {
        try {
            String script = this.readScript(path);
            Parser parser = new Parser(script);
            parser.setFileName(path);
            parser.setResourceResolver(this.resolver);
            parser.allowComment(true);
            parser.parseProgram(prog);
            this.importSyntaxRules(parser);
        }
        catch (IOException ex) {
            throw this.parseError(ex.getMessage());
        }
    }

    private String readScript(String path) throws IOException {
        String resname;
        Reader reader = null;
        try {
            if (!path.startsWith("/") && this.filename != null) {
                String base = this.filename.replace(File.separatorChar, '/');
                resname = base.substring(0, base.lastIndexOf(47) + 1).concat(path);
            } else {
                resname = path;
            }
            reader = this.resolver != null ? this.resolver.open(resname) : new InputStreamReader((InputStream)new FileInputStream(resname), "UTF-8");
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        if (reader == null) {
            resname = path.indexOf(46) == -1 ? SCRIPT_PATH + path + SCRIPT_EXT : path.replace('.', '/') + SCRIPT_EXT;
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(resname);
            if (stream != null) {
                reader = new InputStreamReader(stream, "UTF-8");
            }
        }
        if (reader != null) {
            return this.readScript(reader);
        }
        throw this.parseError(path + ": resource not found.");
    }

    private String readScript(Reader reader) throws IOException {
        int len;
        StringBuilder buf = new StringBuilder();
        char[] cbuf = new char[8192];
        while ((len = reader.read(cbuf)) != -1) {
            buf.append(cbuf, 0, len);
        }
        reader.close();
        return buf.toString();
    }

    public ELProgram parse() {
        ELProgram prog = new ELProgram();
        this.allowComment(true);
        this.parseProgram(prog);
        return prog;
    }

    private ELNode parseExpressionString(boolean embed) {
        ArrayList<ELNode> elems = new ArrayList<ELNode>();
        StringBuilder buf = new StringBuilder();
        int delimiter = 0;
        int p = this.pos;
        this.nextchar();
        while (this.ch != -1) {
            if (this.ch == 36 || this.ch == 35) {
                int delim = this.ch;
                if (this.nextchar() == 123) {
                    if (delimiter == 0) {
                        delimiter = delim;
                    } else if (delimiter != delim) {
                        throw this.parseError(Resources._T("EL_MIXED_SYNTAX"));
                    }
                    if (buf.length() > 0) {
                        elems.add(new ELNode.LITERAL(p, buf.toString()));
                        buf.setLength(0);
                    }
                    elems.add(this.parseTopLevelExpression());
                    p = this.pos;
                    continue;
                }
                if (embed && Character.isJavaIdentifierStart((char)this.ch)) {
                    if (buf.length() > 0) {
                        elems.add(new ELNode.LITERAL(p, buf.toString()));
                        buf.setLength(0);
                    }
                    do {
                        buf.append((char)this.ch);
                    } while (Character.isJavaIdentifierPart((char)this.nextchar()));
                    elems.add(new ELNode.IDENT(this.pos, buf.toString()));
                    buf.setLength(0);
                    p = this.pos;
                    continue;
                }
                buf.append((char)delim);
                if (this.ch == -1 || this.ch == 36 || this.ch == 35) continue;
                buf.append((char)this.ch);
                this.nextchar();
                continue;
            }
            if (this.ch == 92) {
                this.nextchar();
                if (this.ch != 36 && this.ch != 35 && this.ch != 92) {
                    buf.append('\\');
                }
                if (this.ch == -1) continue;
                buf.append((char)this.ch);
                this.nextchar();
                continue;
            }
            buf.append((char)this.ch);
            this.nextchar();
        }
        if (buf.length() > 0) {
            elems.add(new ELNode.LITERAL(p, buf.toString()));
        }
        if (elems.size() == 0) {
            return new ELNode.LITERAL(0, "");
        }
        if (elems.size() == 1) {
            return (ELNode)elems.get(0);
        }
        return new ELNode.Composite(0, Parser.to_a(elems));
    }

    public static ELNode parse(String expression) throws ELException {
        return Parser.parse(expression, false);
    }

    public static ELNode parse(String expression, boolean allowKeywords) throws ELException {
        ELNode e = cache.get(expression);
        if (e == null) {
            Parser parser = new Parser(expression);
            parser.allowComment(false);
            parser.allowKeywords(allowKeywords);
            e = parser.parseExpressionString(false);
            cache.put(expression, e);
        }
        return e;
    }

    class MachineImpl
    extends SyntaxRule.Machine {
        Map<Symbol, ELNode> bindings = new HashMap<Symbol, ELNode>();
        Map<String, String> variables = new HashMap<String, String>();
        private ELNode exp;
        private MachineImpl nested_machine;

        MachineImpl() {
            this.exp = null;
        }

        MachineImpl(ELNode exp) {
            this.exp = exp;
        }

        public void expression(Symbol symbol) {
            if (this.exp == null) {
                this.exp = Parser.this.parseSubExpression(this);
            }
            this.bindings.put(symbol, this.exp);
        }

        public void expressionList(Symbol symbol) {
            if (this.exp == null) {
                int p = Parser.this.pos;
                ArrayList<ELNode> exps = new ArrayList<ELNode>();
                do {
                    exps.add(Parser.this.parseSubExpression(this));
                } while (Parser.this.scan(87));
                this.exp = new ELNode.PATTERN_TUPLE(p, Parser.to_a(exps));
            }
            this.bindings.put(symbol, this.exp);
        }

        public void statement(Symbol symbol) {
            if (this.exp == null) {
                this.exp = Parser.this.parseStatement();
            }
            this.bindings.put(symbol, this.exp);
        }

        public void statementList(Symbol symbol) {
            if (this.exp == null) {
                int p = Parser.this.pos;
                ArrayList exps = new ArrayList();
                while (Parser.this.token != -1 && !this.isDelimiter(Parser.this)) {
                    Parser.this.parseStatementList(exps);
                }
                this.exp = exps.size() == 0 ? new ELNode.NULL(p) : (exps.size() == 1 ? (ELNode)exps.get(0) : new ELNode.COMPOUND(p, Parser.to_a(exps)));
            }
            this.bindings.put(symbol, this.exp);
        }

        public void variable(String name) {
            assert (this.exp == null && Parser.this.token == 47);
            this.variables.put(name, Parser.this.idValue);
        }

        public void arguments(String name) {
            if (this.exp == null) {
                int p = Parser.this.pos;
                ArrayList<ELNode.DEFINE> args = new ArrayList<ELNode.DEFINE>();
                boolean varargs = false;
                if (!this.isDelimiter(Parser.this)) {
                    do {
                        args.add(Parser.this.parseParameter());
                        if (Parser.this.token != 86) continue;
                        Parser.this.scan();
                        varargs = true;
                        break;
                    } while (Parser.this.scan(87));
                }
                ELNode.DEFINE[] vars = Parser.this.checkVars(p, args, varargs);
                this.exp = new ELNode.LAMBDA(p, Parser.this.filename, null, null, vars, varargs, null);
            }
            this.bindings.put(Symbol.valueOf(name), this.exp);
        }

        protected boolean matchPattern(String name) {
            SyntaxRule rule = Parser.this.pattern_rules.get(name);
            if (rule == null) {
                return false;
            }
            Scanner mark = Parser.this.save();
            ELNode exp = Parser.this.matchSyntaxRule(rule, this.getNestedMachine());
            Parser.this.restore(mark);
            return exp != null;
        }

        protected void pattern(SyntaxRule.PatternLexeme lex) {
            if (this.exp == null) {
                SyntaxRule rule = Parser.this.pattern_rules.get(lex.name);
                if (rule == null) {
                    throw Parser.this.parseError("Pattern not found: " + lex.name);
                }
                this.exp = Parser.this.matchSyntaxRule(rule, this.getNestedMachine());
                if (this.exp == null) {
                    throw Parser.this.parseError("Pattern mismatch: " + lex.name);
                }
            }
            ELNode prev = this.bindings.get(lex.symbol);
            switch (lex.transform_to) {
                case 0: {
                    this.bindings.put(lex.symbol, this.exp);
                    break;
                }
                case 1: {
                    ELNode.PATTERN_TUPLE t;
                    if (prev == null) {
                        t = new ELNode.PATTERN_TUPLE(this.exp.pos, new ELNode[]{this.exp});
                    } else if (prev instanceof ELNode.PATTERN_TUPLE) {
                        ELNode[] prev_elems = ((ELNode.PATTERN_TUPLE)prev).elems;
                        ELNode[] elems = new ELNode[prev_elems.length + 1];
                        System.arraycopy(prev_elems, 0, elems, 0, prev_elems.length);
                        elems[elems.length - 1] = this.exp;
                        t = new ELNode.PATTERN_TUPLE(prev.pos, elems);
                    } else {
                        t = new ELNode.PATTERN_TUPLE(prev.pos, new ELNode[]{prev, this.exp});
                    }
                    this.bindings.put(lex.symbol, t);
                    break;
                }
                case 2: {
                    ELNode s;
                    if (prev == null) {
                        s = this.exp;
                    } else if (prev instanceof ELNode.COMPOUND) {
                        ELNode[] prev_stmts = ((ELNode.COMPOUND)prev).exps;
                        ELNode[] stmts = new ELNode[prev_stmts.length + 1];
                        System.arraycopy(prev_stmts, 0, stmts, 0, prev_stmts.length);
                        stmts[stmts.length - 1] = this.exp;
                        s = new ELNode.COMPOUND(prev.pos, stmts);
                    } else {
                        s = new ELNode.COMPOUND(prev.pos, new ELNode[]{prev, this.exp});
                    }
                    this.bindings.put(lex.symbol, s);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }

        protected void regex(Pattern pattern, Symbol symbol) {
            if (this.exp == null) {
                int p = Parser.this.pos;
                String str = Parser.this.scanPatternString(pattern, true);
                if (str != null) {
                    this.exp = new ELNode.STRINGVAL(p, str);
                    Parser.this.scan();
                }
            }
            if (this.exp != null) {
                this.bindings.put(symbol, this.exp);
            }
        }

        public void next() {
            if (this.exp != null) {
                this.exp = null;
            } else {
                Parser.this.scan();
            }
        }

        public void reset() {
            this.bindings.clear();
            this.variables.clear();
            this.exp = null;
            this.accept = null;
        }

        private MachineImpl getNestedMachine() {
            if (this.nested_machine == null) {
                this.nested_machine = new MachineImpl();
            } else {
                this.nested_machine.reset();
            }
            return this.nested_machine;
        }
    }

    private static class SyntaxRuleMap {
        private Map<String, SyntaxRule> map = new HashMap<String, SyntaxRule>();
        private static final String CI_SUFFIX = "/ci";

        private SyntaxRuleMap() {
        }

        public SyntaxRule get(String keyword) {
            SyntaxRule result = this.map.get(keyword);
            if (result != null) {
                return result;
            }
            return this.map.get(keyword.toLowerCase() + CI_SUFFIX);
        }

        public SyntaxRule put(String keyword, SyntaxRule.NFA start, boolean sensitive) {
            if (sensitive) {
                SyntaxRule rule = this.map.get(keyword);
                if (rule != null) {
                    rule.connect(start);
                    return rule;
                }
                rule = this.map.get(keyword.toLowerCase() + CI_SUFFIX);
                if (rule != null) {
                    rule.connect(start);
                    return rule;
                }
                rule = new SyntaxRule(start);
                this.map.put(keyword, rule);
                return rule;
            }
            String keyword_ci = keyword.toLowerCase() + CI_SUFFIX;
            SyntaxRule rule = this.map.get(keyword_ci);
            if (rule != null) {
                rule.connect(start);
                return rule;
            }
            Iterator<Map.Entry<String, SyntaxRule>> i = this.map.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<String, SyntaxRule> e = i.next();
                if (!e.getKey().equalsIgnoreCase(keyword)) continue;
                if (rule == null) {
                    rule = e.getValue();
                } else {
                    rule.connect(e.getValue().start);
                }
                i.remove();
            }
            if (rule != null) {
                rule.connect(start);
            } else {
                rule = new SyntaxRule(start);
            }
            this.map.put(keyword_ci, rule);
            return rule;
        }

        public void remove(String keyword) {
            this.map.remove(keyword);
            this.map.remove(keyword.toLowerCase() + CI_SUFFIX);
        }

        public void putAll(SyntaxRuleMap other) {
            for (Map.Entry<String, SyntaxRule> e : other.map.entrySet()) {
                String key = e.getKey();
                SyntaxRule.NFA start = e.getValue().start;
                if (key.endsWith(CI_SUFFIX)) {
                    key = key.substring(0, key.length() - CI_SUFFIX.length());
                    this.put(key, start, false);
                    continue;
                }
                this.put(key, start, true);
            }
        }
    }

    private static class Qualifier {
        int type;
        ELNode pat;
        ELNode exp;
        Qualifier next;

        Qualifier(int type, ELNode pat, ELNode exp, Qualifier next) {
            this.type = type;
            this.pat = pat;
            this.exp = exp;
            this.next = next;
        }
    }
}

