/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import elite.lang.Decimal;
import elite.lang.Rational;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.el.ELException;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.parser.IncompleteException;
import org.operamasks.el.parser.Operator;
import org.operamasks.el.parser.OperatorManager;
import org.operamasks.el.parser.ParseException;
import org.operamasks.el.parser.Position;
import org.operamasks.el.parser.State;
import org.operamasks.el.parser.Token;
import org.operamasks.el.resources.Resources;

public class Scanner
implements Cloneable {
    public int token;
    protected int next;
    protected int prev;
    protected int ch;
    public String filename;
    public int pos;
    public int prevPos;
    public String idValue;
    public Operator operator;
    public char charValue;
    public Number numberValue;
    public String stringValue;
    private int layout;
    private static final int SPACE_LAYOUT = 1;
    private static final int NEWLINE_LAYOUT = 2;
    private Scanner mark;
    private char[] sbuf = new char[128];
    private int sp;
    private char[] buf;
    private int buflen;
    private boolean allowComment;
    private Map<String, Integer> keywords = xelKeywords;
    private static Map<String, Integer> xelKeywords = new HashMap<String, Integer>();
    private static Map<String, Integer> elKeywords;
    protected OperatorManager operator_manager = OperatorManager.newInstance();

    protected String token_value() {
        String tok;
        if (this.token == -1) {
            tok = "<EOF>";
        } else if (this.idValue != null) {
            tok = this.idValue;
        } else if (this.operator != null) {
            tok = this.operator.name;
        } else if (this.token == 50) {
            tok = this.numberValue.toString();
        } else if (this.token == 52) {
            tok = this.stringValue;
            if (tok.length() > 20) {
                tok = tok.substring(0, 20) + "...";
            }
            tok = TypeCoercion.escape(tok);
        } else {
            tok = this.token == 49 ? ((tok = TypeCoercion.escape(this.charValue)) == null ? "#'" + this.charValue + "'" : "#'" + tok + "'") : Token.opNames[this.token];
        }
        return tok;
    }

    private void growBuffer() {
        char[] newsbuf = new char[this.sbuf.length * 2];
        System.arraycopy(this.sbuf, 0, newsbuf, 0, this.sbuf.length);
        this.sbuf = newsbuf;
    }

    protected void putc(int ch) {
        if (this.sp == this.sbuf.length) {
            this.growBuffer();
        }
        this.sbuf[this.sp++] = (char)ch;
    }

    protected String sbuf() {
        return new String(this.sbuf, 0, this.sp);
    }

    public void allowComment(boolean allowance) {
        this.allowComment = allowance;
    }

    public void allowKeywords(boolean allowance) {
        this.keywords = allowance ? xelKeywords : elKeywords;
    }

    protected void addOperator(String id, int token, int token2) {
        this.operator_manager.dirtyCopy();
        this.operator_manager.addOperator(id, token, token2);
    }

    protected void removeOperator(String id) {
        this.operator_manager.dirtyCopy();
        this.operator_manager.removeOperator(id);
    }

    protected Operator getOperator(String id) {
        return this.operator_manager.getOperator(id);
    }

    public Scanner(String expression) {
        this.buf = expression.toCharArray();
        this.buflen = this.buf.length;
        this.next = 0;
        this.pos = 1025;
        this.mark = this.save();
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public void setLineNumber(int line) {
        this.pos = Position.make(line, 1);
    }

    protected ELException parseError(String message) {
        return this.parseError(this.prevPos, message);
    }

    protected ELException parseError(int pos, String message) {
        return new ParseException(this.filename, Position.line(pos), Position.column(pos), message);
    }

    protected ELException incomplete(String message) {
        return this.incomplete(this.prevPos, message);
    }

    protected ELException incomplete(int pos, String message) {
        return new IncompleteException(this.filename, Position.line(pos), Position.column(pos), message);
    }

    protected int nextchar() {
        if (this.next < this.buflen) {
            ++this.pos;
            this.ch = this.buf[this.next++];
            return this.ch;
        }
        this.ch = -1;
        return -1;
    }

    protected int lookahead(int n) {
        return this.next + n < this.buflen ? this.buf[this.next + n] : -1;
    }

    protected Scanner save() {
        try {
            return (Scanner)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    protected void restore(Scanner state) {
        this.next = state.next;
        this.prev = state.prev;
        this.ch = state.ch;
        this.pos = state.pos;
        this.prevPos = state.prevPos;
        this.token = state.token;
        this.idValue = state.idValue;
        this.operator = state.operator;
        this.charValue = state.charValue;
        this.numberValue = state.numberValue;
        this.stringValue = state.stringValue;
        this.layout = state.layout;
    }

    protected void mark() {
        this.mark.restore(this);
    }

    protected void reset() {
        this.restore(this.mark);
    }

    private void scanNumber() throws ELException {
        boolean overflow = false;
        long value = this.ch - 48;
        this.sp = 0;
        this.putc(this.ch);
        block6: while (true) {
            switch (this.nextchar()) {
                case 39: 
                case 95: {
                    continue block6;
                }
                case 69: 
                case 77: 
                case 101: 
                case 109: {
                    this.scanReal();
                    return;
                }
                case 46: {
                    int cc = this.lookahead(0);
                    if (!Character.isJavaIdentifierStart(cc) && cc != 46 && cc != 64) {
                        this.scanReal();
                        return;
                    }
                    break block6;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putc(this.ch);
                    overflow = overflow || value * 10L / 10L != value;
                    value = value * 10L + (long)(this.ch - 48);
                    overflow = overflow || value - 1L < -1L;
                    continue block6;
                }
            }
            break;
        }
        this.token = 50;
        if (this.ch == 98 || this.ch == 66) {
            this.nextchar();
            this.numberValue = new BigInteger(this.sbuf());
        } else if (this.ch == 114 || this.ch == 82) {
            this.nextchar();
            this.numberValue = Rational.make(new BigInteger(this.sbuf()), BigInteger.ONE);
        } else {
            this.numberValue = overflow ? new BigInteger(this.sbuf()) : ((long)((int)value) == value ? (Number)((int)value) : (Number)value);
        }
    }

    private void scanHexadecimal() throws ELException {
        long value = 0L;
        boolean overflow = false;
        this.sp = 0;
        block6: while (true) {
            switch (this.nextchar()) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putc(this.ch);
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + (long)(this.ch - 48);
                    continue block6;
                }
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: {
                    this.putc(this.ch);
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + (long)(this.ch - 97 + 10);
                    continue block6;
                }
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: {
                    this.putc(this.ch);
                    overflow = overflow || value >>> 60 != 0L;
                    value = (value << 4) + (long)(this.ch - 65 + 10);
                    continue block6;
                }
                case 39: 
                case 95: {
                    continue block6;
                }
            }
            break;
        }
        this.token = 50;
        this.numberValue = overflow ? new BigInteger(this.sbuf(), 16) : ((long)((int)value) == value ? (Number)((int)value) : (Number)value);
    }

    private void scanReal() throws ELException {
        char lastChar;
        boolean seenExponent = false;
        if (this.ch == 46) {
            this.putc(this.ch);
            this.nextchar();
        } else if (this.ch == 101 || this.ch == 69) {
            this.putc(this.ch);
            seenExponent = true;
            this.nextchar();
        }
        block9: while (true) {
            switch (this.ch) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    this.putc(this.ch);
                    break;
                }
                case 39: 
                case 95: {
                    break;
                }
                case 69: 
                case 101: {
                    if (seenExponent) break block9;
                    this.putc(this.ch);
                    seenExponent = true;
                    break;
                }
                case 43: 
                case 45: {
                    lastChar = this.sbuf[this.sp - 1];
                    if (lastChar != 'e' && lastChar != 'E') break block9;
                    this.putc(this.ch);
                    break;
                }
                default: {
                    break block9;
                }
            }
            this.nextchar();
        }
        this.token = 50;
        try {
            lastChar = this.sbuf[this.sp - 1];
            if (lastChar == 'e' || lastChar == 'E' || lastChar == '+' || lastChar == '-') {
                throw this.parseError(Resources._T("EL_FLOATING_LITERAL_FORMAT_ERROR"));
            }
            if (this.ch == 109 || this.ch == 77) {
                this.nextchar();
                this.numberValue = Decimal.valueOf(this.sbuf());
            } else if (this.ch == 98 || this.ch == 66) {
                this.nextchar();
                this.numberValue = new BigDecimal(this.sbuf());
            } else if (this.ch == 114 || this.ch == 82) {
                this.nextchar();
                this.numberValue = Rational.valueOf((Number)new BigDecimal(this.sbuf()));
            } else {
                String str = this.sbuf();
                double dbl = Double.parseDouble(str);
                if (Double.isInfinite(dbl)) {
                    throw this.parseError(Resources._T("EL_FLOATING_LITERAL_OVERFLOW"));
                }
                if (dbl == 0.0 && !Scanner.looksLikeZero(str)) {
                    throw this.parseError(Resources._T("EL_FLOATING_LITERAL_UNDERFLOW"));
                }
                this.numberValue = dbl;
            }
        }
        catch (ArithmeticException ex) {
            throw this.parseError(Resources._T("EL_FLOATING_LITERAL_OVERFLOW"));
        }
        catch (NumberFormatException ex) {
            throw this.parseError(Resources._T("EL_FLOATING_LITERAL_FORMAT_ERROR"));
        }
    }

    private static boolean looksLikeZero(String token) {
        int length = token.length();
        block5: for (int i = 0; i < length; ++i) {
            switch (token.charAt(i)) {
                case '\u0000': 
                case '.': {
                    continue block5;
                }
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return false;
                }
                case 'E': 
                case 'e': {
                    return true;
                }
            }
        }
        return true;
    }

    private int scanEscapeChar(int c) {
        switch (c) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int n = this.ch - 48;
                block15: for (int i = 0; i < 2; ++i) {
                    switch (this.nextchar()) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            n = (n << 3) + this.ch - 48;
                            continue block15;
                        }
                        default: {
                            return n;
                        }
                    }
                }
                if (n > 255) {
                    throw this.parseError(Resources._T("EL_ILLEGAL_ESCAPE_CHAR"));
                }
                this.nextchar();
                return n;
            }
            case 114: {
                this.nextchar();
                return 13;
            }
            case 110: {
                this.nextchar();
                return 10;
            }
            case 102: {
                this.nextchar();
                return 12;
            }
            case 98: {
                this.nextchar();
                return 8;
            }
            case 116: {
                this.nextchar();
                return 9;
            }
            case 115: {
                this.nextchar();
                return 32;
            }
            case 92: {
                this.nextchar();
                return 92;
            }
            case 34: {
                this.nextchar();
                return 34;
            }
            case 39: {
                this.nextchar();
                return 39;
            }
        }
        throw this.parseError(Resources._T("EL_ILLEGAL_ESCAPE_CHAR"));
    }

    private void scanString() throws ELException {
        int spos = this.pos;
        int delim = this.ch;
        boolean multiline = false;
        this.token = 52;
        this.charValue = (char)delim;
        this.sp = 0;
        if (this.nextchar() == delim) {
            if (this.nextchar() == delim) {
                this.nextchar();
                multiline = true;
            } else {
                this.stringValue = "";
                return;
            }
        }
        block7: while (true) {
            switch (this.ch) {
                case -1: {
                    if (multiline) {
                        throw this.incomplete(spos, Resources._T("EL_UNTERMINATED_STRING"));
                    }
                    throw this.parseError(spos, Resources._T("EL_UNTERMINATED_STRING"));
                }
                case 34: 
                case 39: {
                    if (this.ch == delim) {
                        if (!multiline) {
                            this.nextchar();
                            this.stringValue = this.sbuf();
                            return;
                        }
                        if (this.nextchar() != delim) {
                            this.putc(delim);
                            continue block7;
                        }
                        if (this.nextchar() != delim) {
                            this.putc(delim);
                            this.putc(delim);
                            continue block7;
                        }
                        this.nextchar();
                        this.stringValue = this.sbuf();
                        return;
                    }
                    this.putc(this.ch);
                    this.nextchar();
                    continue block7;
                }
                case 92: {
                    int c = this.nextchar();
                    if (c == 13 || c == 10) {
                        if (this.nextchar() == 10 && c == 13) {
                            this.nextchar();
                        }
                        this.pos = Position.nextline(this.pos);
                        continue block7;
                    }
                    if (delim == 39) {
                        this.putc(92);
                        continue block7;
                    }
                    if (c == 36 || c == 35 || c == 92) {
                        this.putc(92);
                        this.putc(c);
                        this.nextchar();
                        continue block7;
                    }
                    this.putc(this.scanEscapeChar(c));
                    continue block7;
                }
                case 13: {
                    if (multiline) {
                        this.putc(13);
                        if (this.nextchar() == 10) {
                            this.putc(10);
                            this.nextchar();
                        }
                        this.pos = Position.nextline(this.pos);
                        continue block7;
                    }
                    throw this.parseError(spos, Resources._T("EL_UNTERMINATED_STRING"));
                }
                case 10: {
                    if (multiline) {
                        this.putc(10);
                        this.nextchar();
                        this.pos = Position.nextline(this.pos);
                        continue block7;
                    }
                    throw this.parseError(spos, Resources._T("EL_UNTERMINATED_STRING"));
                }
            }
            this.putc(this.ch);
            this.nextchar();
        }
    }

    private void scanCharacter() throws ELException {
        this.token = 49;
        switch (this.nextchar()) {
            case 92: {
                this.charValue = (char)this.scanEscapeChar(this.nextchar());
                break;
            }
            case 10: 
            case 13: {
                throw this.parseError("Invalid character literal.");
            }
            default: {
                this.charValue = (char)this.ch;
                this.nextchar();
            }
        }
        if (this.ch != 39) {
            throw this.parseError("Invalid character literal.");
        }
        this.nextchar();
    }

    protected String scanRegexp() throws ELException {
        this.sp = 0;
        block5: while (true) {
            switch (this.ch) {
                case -1: 
                case 10: 
                case 13: {
                    throw this.parseError(Resources._T("EL_UNTERMINATED_STRING"));
                }
                case 47: {
                    this.nextchar();
                    return this.sbuf();
                }
                case 92: {
                    if (this.nextchar() == 47) {
                        this.putc(47);
                    } else {
                        this.putc(92);
                        this.putc(this.ch);
                    }
                    this.nextchar();
                    continue block5;
                }
            }
            this.putc(this.ch);
            this.nextchar();
        }
    }

    protected String scanPatternString(Pattern pattern, boolean eat) {
        char c;
        int p;
        for (p = this.prev; p < this.buflen; ++p) {
            c = this.buf[p];
            if (c == '\n' || c == '\r') {
                return null;
            }
            if (c != ' ' && c != '\t' && c != '\f') break;
        }
        int start = p;
        while (p < this.buflen && (c = this.buf[p]) != '\n' && c != '\r') {
            ++p;
        }
        int end = p;
        if (start == end) {
            return null;
        }
        Matcher matcher = pattern.matcher(new String(this.buf, start, end - start));
        if (matcher.lookingAt()) {
            if (eat) {
                this.next = start + matcher.end();
                this.nextchar();
            }
            return matcher.group();
        }
        return null;
    }

    private void scanIdentifier() {
        this.sp = 0;
        block3: while (true) {
            this.putc(this.ch);
            switch (this.nextchar()) {
                case 36: 
                case 39: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 95: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: {
                    continue block3;
                }
            }
            if (!Character.isJavaIdentifierPart((char)this.ch)) break;
        }
        String str = this.sbuf().intern();
        Integer key = this.keywords.get(str);
        this.token = key != null ? key : 47;
        this.idValue = str;
    }

    private void skipWhitespaces() {
        this.layout = 0;
        block6: while (true) {
            switch (this.ch) {
                case 9: 
                case 12: 
                case 32: {
                    this.nextchar();
                    this.layout |= 1;
                    continue block6;
                }
                case 13: {
                    if (this.nextchar() == 10) {
                        this.nextchar();
                    }
                    this.pos = Position.nextline(this.pos);
                    this.layout |= 2;
                    continue block6;
                }
                case 10: {
                    this.nextchar();
                    this.pos = Position.nextline(this.pos);
                    this.layout |= 2;
                    continue block6;
                }
                case 47: {
                    if (!this.allowComment) {
                        return;
                    }
                    int c = this.lookahead(0);
                    if (c == 47) {
                        while ((c = this.nextchar()) != 10 && c != 13 && c != -1) {
                        }
                        continue block6;
                    }
                    if (c == 42) {
                        int p = this.pos;
                        this.nextchar();
                        while ((c = this.nextchar()) != -1) {
                            if (c == 42 && this.lookahead(0) == 47) {
                                this.nextchar();
                                this.nextchar();
                                break;
                            }
                            if (c == 13) {
                                if (this.lookahead(0) == 10) {
                                    this.nextchar();
                                }
                                this.pos = Position.nextline(this.pos);
                                continue;
                            }
                            if (c != 10) continue;
                            this.pos = Position.nextline(this.pos);
                        }
                        if (c != -1) continue block6;
                        throw this.incomplete(p, "End of file in comment");
                    }
                    return;
                }
            }
            if (!Character.isWhitespace((char)this.ch)) break;
            this.nextchar();
            this.layout |= 1;
        }
    }

    public int scan() throws ELException {
        this.skipWhitespaces();
        this.prevPos = this.pos;
        this.prev = this.next - 1;
        this.idValue = null;
        this.operator = null;
        switch (this.ch) {
            case -1: {
                this.token = -1;
                return this.prevPos;
            }
            case 34: 
            case 39: {
                this.scanString();
                return this.prevPos;
            }
            case 48: {
                if (this.lookahead(0) == 120 || this.lookahead(0) == 88) {
                    this.nextchar();
                    this.scanHexadecimal();
                } else {
                    this.scanNumber();
                }
                return this.prevPos;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.scanNumber();
                return this.prevPos;
            }
            case 46: {
                int c = this.lookahead(0);
                if (c < 48 || c > 57) break;
                this.sp = 0;
                this.putc(46);
                this.nextchar();
                this.scanReal();
                return this.prevPos;
            }
            case 35: {
                if (this.lookahead(0) != 39) break;
                this.nextchar();
                this.scanCharacter();
                return this.prevPos;
            }
        }
        if (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch == 95 || this.ch == 36) {
            this.scanIdentifier();
            return this.prevPos;
        }
        Operator accept = null;
        int last = this.next;
        int lastch = this.ch;
        int lastpos = this.pos;
        State t = this.operator_manager.start;
        while (this.ch != -1 && (t = this.operator_manager.dispatch(t, this.ch)) != null) {
            this.nextchar();
            if (t.accept == null) continue;
            accept = t.accept;
            last = this.next;
            lastch = this.ch;
            lastpos = this.pos;
            lastch = this.ch;
        }
        if (accept != null) {
            this.operator = accept;
            this.token = accept.token;
            this.next = last;
            this.ch = lastch;
            this.pos = lastpos;
        } else if (Character.isJavaIdentifierStart((char)this.ch)) {
            this.scanIdentifier();
        } else {
            throw this.parseError(Resources._T("EL_ILLEGAL_CHARACTER", Character.valueOf((char)this.ch)));
        }
        return this.prevPos;
    }

    public boolean scan(int t) {
        Operator op;
        if (this.token == t) {
            this.scan();
            return true;
        }
        if (this.token == 47 && (op = this.operator_manager.getOperator(this.idValue)) != null && t == op.token) {
            this.scan();
            return true;
        }
        return false;
    }

    public boolean scanLayout() {
        return (this.layout & 2) != 0 || this.token == 88 || this.token == -1 || this.token == 82;
    }

    public boolean sawSpace() {
        return this.layout != 0;
    }

    public boolean sawNewLine() {
        return (this.layout & 2) != 0;
    }

    static {
        xelKeywords.put("not", 33);
        xelKeywords.put("true", 70);
        xelKeywords.put("false", 71);
        xelKeywords.put("null", 72);
        xelKeywords.put("void", 73);
        xelKeywords.put("empty", 39);
        xelKeywords.put("instanceof", 31);
        xelKeywords.put("new", 45);
        xelKeywords.put("require", 89);
        xelKeywords.put("import", 90);
        xelKeywords.put("define", 92);
        xelKeywords.put("undef", 96);
        xelKeywords.put("public", 63);
        xelKeywords.put("protected", 64);
        xelKeywords.put("private", 65);
        xelKeywords.put("static", 66);
        xelKeywords.put("final", 67);
        xelKeywords.put("abstract", 68);
        xelKeywords.put("class", 93);
        xelKeywords.put("extends", 94);
        xelKeywords.put("implements", 95);
        xelKeywords.put("let", 97);
        xelKeywords.put("if", 98);
        xelKeywords.put("else", 99);
        xelKeywords.put("for", 100);
        xelKeywords.put("while", 101);
        xelKeywords.put("switch", 102);
        xelKeywords.put("with", 103);
        xelKeywords.put("case", 104);
        xelKeywords.put("default", 105);
        xelKeywords.put("break", 106);
        xelKeywords.put("continue", 107);
        xelKeywords.put("return", 108);
        xelKeywords.put("throw", 109);
        xelKeywords.put("try", 110);
        xelKeywords.put("catch", 111);
        xelKeywords.put("finally", 112);
        xelKeywords.put("synchronized", 69);
        xelKeywords.put("assert", 113);
        elKeywords = new HashMap<String, Integer>();
        elKeywords.put("not", 33);
        elKeywords.put("true", 70);
        elKeywords.put("false", 71);
        elKeywords.put("null", 72);
        elKeywords.put("empty", 39);
        elKeywords.put("instanceof", 31);
        elKeywords.put("new", 45);
        elKeywords.put("let", 97);
    }
}

