/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.parser;

import elite.ast.Expression;
import elite.lang.Symbol;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ValueExpression;
import org.operamasks.el.eval.Control;
import org.operamasks.el.eval.EvaluationContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.Frame;
import org.operamasks.el.eval.StackTrace;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.parser.ELNode;
import org.operamasks.el.parser.ParseException;
import org.operamasks.el.parser.Scanner;
import org.operamasks.el.parser.TreeTransformer;

final class SyntaxRule {
    static final Lexeme EPSILON = null;
    NFA start;

    SyntaxRule(NFA start) {
        this.start = start;
    }

    void connect(NFA nfa) {
        NFA end;
        if (this.start.edge == EPSILON) {
            end = this.start;
            while (end.next2 != null) {
                end = end.next2;
            }
        } else {
            end = new NFA();
            end.next = this.start;
            this.start = end;
        }
        if (nfa.edge == EPSILON) {
            end.next2 = nfa;
        } else {
            end.next2 = new NFA();
            end.next2.next = nfa;
        }
    }

    public static class RegexLexeme
    extends Lexeme {
        public final Pattern pattern;
        public final Symbol symbol;

        public RegexLexeme(Pattern pattern, Symbol symbol) {
            this.pattern = pattern;
            this.symbol = symbol;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return s.scanPatternString(this.pattern, false) != null;
        }

        public void bind(Machine context) {
            context.regex(this.pattern, this.symbol);
        }
    }

    public static class StringLexeme
    extends Lexeme {
        public final String stringValue;

        public StringLexeme(String stringValue) {
            this.stringValue = stringValue;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return 52 == s.token && this.stringValue.equals(s.stringValue);
        }
    }

    public static class NumberLexeme
    extends Lexeme {
        public final Number numberValue;

        public NumberLexeme(Number numberValue) {
            this.numberValue = numberValue;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return 50 == s.token && this.numberValue.equals(s.numberValue);
        }
    }

    public static class CharLexeme
    extends Lexeme {
        public final char charValue;

        public CharLexeme(char charValue) {
            this.charValue = charValue;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return 49 == s.token && this.charValue == s.charValue;
        }
    }

    public static class PatternLexeme
    extends Lexeme {
        public final String name;
        public final Symbol symbol;
        public final Lexeme delimiter;
        public int transform_to = 0;
        public static final int TRANSFORM_TO_EXPRESSION = 0;
        public static final int TRANSFORM_TO_EXPRESSION_LIST = 1;
        public static final int TRANSFORM_TO_STATEMENT = 2;

        public PatternLexeme(String name, Symbol symbol, Lexeme delimiter) {
            this.name = name;
            this.symbol = symbol;
            this.delimiter = delimiter;
        }

        public void setOccurence(int occurence) {
            super.setOccurence(occurence);
            this.transform_to = occurence == 26 || occurence == 24 ? 1 : 0;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return context.matchPattern(this.name);
        }

        public void bind(Machine context) {
            context.pattern(this);
        }
    }

    public static class StatementListLexeme
    extends Lexeme {
        public final Symbol symbol;

        public StatementListLexeme(Symbol symbol) {
            this.symbol = symbol;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return true;
        }

        public void bind(Machine context) {
            context.statementList(this.symbol);
        }
    }

    public static class StatementLexeme
    extends Lexeme {
        public final Symbol symbol;

        public StatementLexeme(Symbol symbol) {
            this.symbol = symbol;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return true;
        }

        public void bind(Machine context) {
            context.statement(this.symbol);
        }
    }

    public static class SymbolListLexeme
    extends Lexeme {
        public final Symbol symbol;

        public SymbolListLexeme(Symbol symbol) {
            this.symbol = symbol;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return true;
        }

        public void bind(Machine context) {
            context.expressionList(this.symbol);
        }
    }

    public static class SymbolLexeme
    extends Lexeme {
        public final Symbol symbol;

        public SymbolLexeme(Symbol symbol) {
            this.symbol = symbol;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return true;
        }

        public void bind(Machine context) {
            context.expression(this.symbol);
        }
    }

    public static class IdentifierListLexeme
    extends Lexeme {
        public final String id;

        public IdentifierListLexeme(String id) {
            this.id = id;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return true;
        }

        public void bind(Machine context) {
            context.arguments(this.id);
        }
    }

    public static class IdentifierLexeme
    extends Lexeme {
        public final String id;

        public IdentifierLexeme(String id) {
            this.id = id;
        }

        public boolean isExact() {
            return false;
        }

        public boolean matches(Scanner s, Machine context) {
            return s.token == 47;
        }

        public void bind(Machine context) {
            context.variable(this.id);
        }
    }

    public static class KeywordLexeme
    extends Lexeme {
        public final String keyword;
        public final boolean sensitive;

        public KeywordLexeme(String keyword) {
            this(keyword, true);
        }

        public KeywordLexeme(String keyword, boolean sensitive) {
            this.keyword = keyword;
            this.sensitive = sensitive;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            String id;
            String string = id = s.token == 4 ? s.operator.name : s.idValue;
            if (id == null) {
                return false;
            }
            if (this.sensitive) {
                return this.keyword.equals(id);
            }
            return this.keyword.equalsIgnoreCase(id);
        }
    }

    public static class GenericLexeme
    extends Lexeme {
        public final int token;

        public GenericLexeme(int token) {
            this.token = token;
        }

        public boolean isExact() {
            return true;
        }

        public boolean matches(Scanner s, Machine context) {
            return this.token == s.token;
        }
    }

    public static abstract class Lexeme {
        private int occurence = -1;

        public int getOccurence() {
            return this.occurence;
        }

        public void setOccurence(int occurence) {
            this.occurence = occurence;
        }

        public abstract boolean isExact();

        public abstract boolean matches(Scanner var1, Machine var2);

        public void bind(Machine context) {
        }
    }

    static abstract class Machine {
        Accept accept;
        private NFAState state;
        private NFAState next_state;
        private Stack<NFA> stack;

        Machine() {
        }

        void init(NFA start) {
            this.state = new NFAState();
            this.next_state = new NFAState();
            this.stack = new Stack();
            this.state.add(start);
            this.e_closure(this.state);
        }

        boolean hasMore() {
            return !this.state.isEmpty();
        }

        boolean move(Scanner s) {
            int i;
            boolean exact = false;
            PatternLexeme pattern = null;
            Class<?> type = null;
            this.next_state.clear();
            for (i = 0; i < this.state.size; ++i) {
                NFA p = this.state.get(i);
                Lexeme lex = p.edge;
                if (exact && lex instanceof PatternLexeme) {
                    if (pattern == null || !pattern.name.equals(((PatternLexeme)lex).name)) continue;
                    this.next_state.add(p);
                    continue;
                }
                if (lex == EPSILON || !lex.matches(s, this)) continue;
                if (lex.isExact()) {
                    if (!exact || pattern != null) {
                        this.next_state.clear();
                        exact = true;
                        pattern = null;
                    }
                    if (lex instanceof PatternLexeme) {
                        pattern = (PatternLexeme)lex;
                    }
                } else if (!exact) {
                    if (type == null) {
                        type = lex.getClass();
                    } else if (type != lex.getClass()) {
                        return false;
                    }
                }
                this.next_state.add(p);
            }
            if (this.next_state.isEmpty()) {
                this.state.clear();
                return true;
            }
            this.state.clear();
            for (i = 0; i < this.next_state.size; ++i) {
                this.state.add(this.next_state.get((int)i).next);
            }
            this.e_closure(this.state);
            for (i = 0; i < this.next_state.size; ++i) {
                this.next_state.get((int)i).edge.bind(this);
            }
            return true;
        }

        boolean isDelimiter(Scanner s) {
            for (int i = 0; i < this.state.size; ++i) {
                Lexeme p = this.state.get((int)i).edge;
                if (p == EPSILON || !p.isExact() || !p.matches(s, this)) continue;
                return true;
            }
            return false;
        }

        private void e_closure(NFAState state) {
            if (state.isEmpty()) {
                return;
            }
            for (int i = 0; i < state.size; ++i) {
                this.stack.push(state.get(i));
            }
            this.accept = null;
            while (!this.stack.isEmpty()) {
                NFA p = this.stack.pop();
                if (p.accept != null) {
                    this.accept = p.accept;
                }
                if (p.edge != EPSILON) continue;
                if (p.next != null && state.add(p.next)) {
                    this.stack.push(p.next);
                }
                if (p.next2 == null || !state.add(p.next2)) continue;
                this.stack.push(p.next2);
            }
        }

        protected abstract void expression(Symbol var1);

        protected abstract void expressionList(Symbol var1);

        protected abstract void statement(Symbol var1);

        protected abstract void statementList(Symbol var1);

        protected abstract void variable(String var1);

        protected abstract void arguments(String var1);

        protected abstract boolean matchPattern(String var1);

        protected abstract void pattern(PatternLexeme var1);

        protected abstract void regex(Pattern var1, Symbol var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PatternTransformer
    extends TreeTransformer {
        private Map<String, String> variables;
        private Map<Symbol, ELNode> bindings;

        PatternTransformer(Map<String, String> variables, Map<Symbol, ELNode> bindings) {
            this.variables = variables;
            this.bindings = bindings;
        }

        @Override
        public String transform(String id) {
            String var;
            if (id != null && (var = this.variables.get(id)) != null) {
                return var;
            }
            return id;
        }

        @Override
        public String[] transform(String[] ids) {
            if (ids == null) {
                return null;
            }
            String[] result = new String[ids.length];
            for (int i = 0; i < ids.length; ++i) {
                result[i] = this.transform(ids[i]);
            }
            return result;
        }

        @Override
        public void visit(ELNode.IDENT e) {
            String var;
            if (e.id.startsWith("$$") && (var = this.variables.get(e.id.substring(1))) != null) {
                this.result = new ELNode.STRINGVAL(e.pos, var);
                return;
            }
            super.visit(e);
        }

        @Override
        public void visit(ELNode.LAMBDA e) {
            ELNode exp;
            if (e.vars.length == 1 && (exp = this.bindings.get(Symbol.valueOf(e.vars[0].id))) instanceof ELNode.LAMBDA) {
                this.result = new ELNode.LAMBDA(e.pos, e.file, this.transform(e.name), this.transform(e.rtype), ((ELNode.LAMBDA)exp).vars, e.varargs || ((ELNode.LAMBDA)exp).varargs, this.transform(e.body));
                return;
            }
            super.visit(e);
        }

        @Override
        public void visit(ELNode.SYMBOL sym) {
            ELNode binding = this.bindings.get(sym.value);
            this.result = binding != null ? binding : sym;
        }

        @Override
        public ELNode[] transform(ELNode[] args) {
            Symbol sym;
            ELNode binding;
            if (args != null && args.length == 1 && args[0] instanceof ELNode.SYMBOL && (binding = this.bindings.get(sym = ((ELNode.SYMBOL)args[0]).value)) != null) {
                if (binding instanceof ELNode.TUPLE) {
                    return ((ELNode.TUPLE)binding).elems;
                }
                if (binding instanceof ELNode.NULL) {
                    return new ELNode[0];
                }
                return new ELNode[]{binding};
            }
            return super.transform(args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Accept {
        public final Set<String> variables = new HashSet<String>();
        private String source;
        public ELNode ppexp;
        public ELNode template;

        public Accept(String source) {
            this.source = source;
        }

        public boolean addVariable(String name) {
            return this.variables.add(name);
        }

        public ELNode transform(EvaluationContext context, Map<String, String> variables, Map<Symbol, ELNode> bindings) {
            ELNode pp;
            Iterator<String> vars = variables.keySet().iterator();
            while (vars.hasNext()) {
                String var = vars.next();
                if (this.variables.contains(var)) continue;
                vars.remove();
            }
            Iterator<Symbol> syms = bindings.keySet().iterator();
            while (syms.hasNext()) {
                Symbol sym = syms.next();
                if (this.variables.contains(sym.getName())) continue;
                syms.remove();
            }
            if (this.ppexp != null && (pp = this.preProcess(context, variables, bindings)) != null) {
                return pp;
            }
            for (String var : this.variables) {
                Symbol sym;
                if (var.startsWith("$") || bindings.containsKey(sym = Symbol.valueOf(var))) continue;
                bindings.put(sym, new ELNode.NULL(0));
            }
            return new PatternTransformer(variables, bindings).transform(this.template);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ELNode preProcess(EvaluationContext context, Map<String, String> variables, Map<Symbol, ELNode> bindings) {
            VariableMapperImpl vm = new VariableMapperImpl();
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                vm.setVariable(entry.getKey(), new LiteralClosure(entry.getValue()));
            }
            for (Map.Entry<Object, Object> entry : bindings.entrySet()) {
                String name = ((Symbol)entry.getKey()).getName();
                ELNode node = (ELNode)entry.getValue();
                if (node instanceof ELNode.PATTERN_TUPLE) {
                    ELNode[] elems = ((ELNode.PATTERN_TUPLE)node).elems;
                    Expression[] tuple = new Expression[elems.length];
                    for (int i = 0; i < elems.length; ++i) {
                        tuple[i] = Expression.valueOf(elems[i]);
                    }
                    vm.setVariable(name, new LiteralClosure(tuple));
                    continue;
                }
                Expression exp = Expression.valueOf(node);
                vm.setVariable(name, new LiteralClosure(exp));
            }
            for (String string : this.variables) {
                if (string.startsWith("$") || bindings.containsKey(Symbol.valueOf(string))) continue;
                vm.setVariable(string, new LiteralClosure(null));
            }
            ELContext elctx = context.getELContext();
            Frame frame = StackTrace.addFrame(elctx, "__preprocess__", this.source, this.ppexp.pos);
            EvaluationContext env = context.pushContext(vm);
            try {
                if (this.ppexp instanceof ELNode.COMPOUND) {
                    for (ELNode stmt : ((ELNode.COMPOUND)this.ppexp).exps) {
                        stmt.pos(frame).getValue(env);
                    }
                } else {
                    this.ppexp.pos(frame).getValue(env);
                }
            }
            catch (EvaluationException ex) {
                throw new ParseException(ex.getFileName(), ex.getLineNumber(), ex.getColumnNumber(), ex.getMessage());
            }
            catch (Control.Return ret) {
                Object result = ret.getResult();
                if (result instanceof Expression) {
                    ELNode i$ = ((Expression)result).getNode();
                    return i$;
                }
            }
            finally {
                StackTrace.removeFrame(elctx);
            }
            for (Map.Entry<String, ValueExpression> e : vm.getVariableMap().entrySet()) {
                String id = e.getKey();
                Object value = e.getValue().getValue(elctx);
                if (id.startsWith("$")) {
                    if (!(value instanceof String)) continue;
                    variables.put(id, (String)value);
                    continue;
                }
                if (!(value instanceof Expression)) continue;
                bindings.put(Symbol.valueOf(id), ((Expression)value).getNode());
            }
            return null;
        }
    }

    static class NFAState {
        NFA[] set = new NFA[10];
        int size;

        NFAState() {
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        boolean add(NFA p) {
            for (int i = 0; i < this.size; ++i) {
                if (this.set[i] != p) continue;
                return false;
            }
            if (this.size >= this.set.length) {
                NFA[] new_set = new NFA[this.set.length * 2];
                System.arraycopy(this.set, 0, new_set, 0, this.set.length);
                this.set = new_set;
            }
            this.set[this.size++] = p;
            return true;
        }

        NFA get(int index) {
            assert (index >= 0 && index < this.size);
            return this.set[index];
        }

        void clear() {
            this.size = 0;
        }
    }

    static class NFA {
        Lexeme edge;
        NFA next;
        NFA next2;
        Accept accept;

        NFA() {
            this.edge = EPSILON;
        }

        NFA(Lexeme edge) {
            this.edge = edge;
        }
    }
}

