/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Range;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.TypeCoercion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayELResolver
extends ELResolver {
    private boolean isReadOnly;

    public ArrayELResolver() {
        this.isReadOnly = false;
    }

    public ArrayELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Class<?> getType(ELContext elctx, Object base, Object property) {
        if (base != null && base.getClass().isArray()) {
            if (property instanceof Range) {
                elctx.setPropertyResolved(true);
                return base.getClass();
            }
            if ("length".equals(property) || "size".equals(property)) {
                elctx.setPropertyResolved(true);
                return Integer.class;
            }
            if (property instanceof Number) {
                elctx.setPropertyResolved(true);
                return base.getClass().getComponentType();
            }
        }
        return null;
    }

    public Object getValue(ELContext elctx, Object base, Object property) {
        if (base == null || !base.getClass().isArray()) {
            return null;
        }
        if (property instanceof Range) {
            elctx.setPropertyResolved(true);
            return this.extractRange(base, (Range)property);
        }
        if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property)) {
                elctx.setPropertyResolved(true);
                return Array.getLength(base);
            }
            if ("first".equals(property)) {
                elctx.setPropertyResolved(true);
                if (Array.getLength(base) > 0) {
                    return Array.get(base, 0);
                }
            } else if ("last".equals(property)) {
                elctx.setPropertyResolved(true);
                int length = Array.getLength(base);
                if (length > 0) {
                    return Array.get(base, length - 1);
                }
            }
        } else if (property instanceof Number) {
            elctx.setPropertyResolved(true);
            int length = Array.getLength(base);
            int index = ((Number)property).intValue();
            if (index >= 0 && index < length) {
                return Array.get(base, index);
            }
        } else if (property instanceof List && ((List)property).isEmpty()) {
            elctx.setPropertyResolved(true);
            return Array.newInstance(base.getClass().getComponentType(), 0);
        }
        return null;
    }

    public void setValue(ELContext elctx, Object base, Object property, Object value) {
        if (base == null || !base.getClass().isArray()) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException();
        }
        if (property instanceof Range) {
            if (value != null && value.getClass().isArray()) {
                this.copyRangeWithArray(elctx, base, (Range)property, value);
            } else if (value instanceof Collection) {
                this.copyRangeWithCollection(elctx, base, (Range)property, (Collection)value);
            } else {
                this.copyRangeWithSingle(elctx, base, (Range)property, value);
            }
            elctx.setPropertyResolved(true);
        } else if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property)) {
                throw new PropertyNotWritableException();
            }
        } else if (property instanceof Number) {
            Class<?> type = base.getClass().getComponentType();
            int length = Array.getLength(base);
            int index = ((Number)property).intValue();
            this.rangeCheck(index, length);
            Array.set(base, index, TypeCoercion.coerce(elctx, value, type));
            elctx.setPropertyResolved(true);
        }
    }

    public boolean isReadOnly(ELContext elctx, Object base, Object property) {
        if (base != null && base.getClass().isArray()) {
            elctx.setPropertyResolved(true);
        }
        return this.isReadOnly;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext elctx, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext elctx, Object base) {
        if (base != null && base.getClass().isArray()) {
            return Integer.class;
        }
        return null;
    }

    private Object extractRange(Object base, Range range) {
        int size;
        Class<?> type = base.getClass().getComponentType();
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = Array.getLength(base);
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (begin < 0L && end < 0L || begin >= length && end >= length) {
            return Array.newInstance(type, 0);
        }
        if (step > 0L) {
            begin = begin < 0L ? 0L : begin;
            long l = end = end >= length ? length - 1L : end;
            assert (begin < length && end < length && end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            end = end < 0L ? 0L : end;
            long l = begin = begin >= length ? length - 1L : begin;
            assert (begin < length && end < length && begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        Object array = Array.newInstance(type, size);
        if (step == 1L) {
            System.arraycopy(base, (int)begin, array, 0, size);
        } else {
            int i = 0;
            while (i < size) {
                Array.set(array, i, Array.get(base, (int)begin));
                ++i;
                begin += step;
            }
        }
        return array;
    }

    private void copyRangeWithArray(ELContext elctx, Object base, Range range, Object value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = Array.getLength(base);
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (begin < 0L && end < 0L || begin >= length && end >= length) {
            return;
        }
        if (step > 0L) {
            begin = begin < 0L ? 0L : begin;
            long l = end = end >= length ? length - 1L : end;
            assert (begin < length && end < length && end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            end = end < 0L ? 0L : end;
            long l = begin = begin >= length ? length - 1L : begin;
            assert (begin < length && end < length && begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        int value_size = Array.getLength(value);
        if (size > value_size) {
            size = value_size;
        }
        if (step == 1L && value.getClass() == base.getClass()) {
            System.arraycopy(value, 0, base, (int)begin, size);
        } else {
            Class<?> type = base.getClass().getComponentType();
            int i = 0;
            while (i < size) {
                Array.set(base, (int)begin, TypeCoercion.coerce(elctx, Array.get(value, i), type));
                ++i;
                begin += step;
            }
        }
    }

    private void copyRangeWithCollection(ELContext elctx, Object base, Range range, Collection value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = Array.getLength(base);
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (begin < 0L && end < 0L || begin >= length && end >= length) {
            return;
        }
        if (step > 0L) {
            begin = begin < 0L ? 0L : begin;
            long l = end = end >= length ? length - 1L : end;
            assert (begin < length && end < length && end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            end = end < 0L ? 0L : end;
            long l = begin = begin >= length ? length - 1L : begin;
            assert (begin < length && end < length && begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        Class<?> type = base.getClass().getComponentType();
        Iterator it = value.iterator();
        int i = 0;
        while (i < size && it.hasNext()) {
            Array.set(base, (int)begin, TypeCoercion.coerce(elctx, it.next(), type));
            ++i;
            begin += step;
        }
    }

    private void copyRangeWithSingle(ELContext elctx, Object base, Range range, Object value) {
        int size;
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        long length = Array.getLength(base);
        if (range.isUnbound()) {
            long l = end = step > 0L ? length : 0L;
        }
        if (begin < 0L && end < 0L || begin >= length && end >= length) {
            return;
        }
        if (step > 0L) {
            begin = begin < 0L ? 0L : begin;
            long l = end = end >= length ? length - 1L : end;
            assert (begin < length && end < length && end >= begin);
            size = (int)((end - begin + step) / step);
        } else {
            end = end < 0L ? 0L : end;
            long l = begin = begin >= length ? length - 1L : begin;
            assert (begin < length && end < length && begin >= end);
            size = (int)((begin - end - step) / -step);
        }
        value = TypeCoercion.coerce(elctx, value, base.getClass().getComponentType());
        int i = 0;
        while (i < size) {
            Array.set(base, (int)begin, value);
            ++i;
            begin += step;
        }
    }

    private void rangeCheck(int index, int length) {
        if (index < 0 || index >= length) {
            throw new IndexOutOfBoundsException("Array index out of bounds: " + index);
        }
    }
}

