/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Closure;
import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.MethodInfo;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.PropertyDelegate;
import org.operamasks.el.eval.PropertyResolvable;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.closure.ClassDefinition;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.MethodClosure;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertyELResolver
extends ELResolver {
    private SimpleCache<Class, BeanFields> cache = SimpleCache.make(200);

    public Class<?> getType(ELContext context, Object base, Object property) {
        MethodClosure expando;
        Field field;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        if ("@@class".equals(property)) {
            context.setPropertyResolved(true);
            if (base instanceof ClosureObject) {
                return ClassDefinition.class;
            }
            return Class.class;
        }
        if (base instanceof Class && (field = this.getBeanField((Class)base, property)) != null && Modifier.isStatic(field.getModifiers())) {
            context.setPropertyResolved(true);
            return field.getType();
        }
        if (!(base instanceof PropertyDelegate)) {
            BeanProperty bp = this.getBeanProperty(base.getClass(), property);
            if (bp != null) {
                if (bp.getReadMethod() == null) {
                    throw new PropertyNotFoundException();
                }
                context.setPropertyResolved(true);
                return bp.getType();
            }
            Field field2 = this.getBeanField(base.getClass(), property);
            if (field2 != null) {
                context.setPropertyResolved(true);
                return field2.getType();
            }
        }
        if (base instanceof PropertyResolvable) {
            Class<?> type = ((PropertyResolvable)base).getType(context, property);
            if (context.isPropertyResolved()) {
                return type;
            }
        }
        if (!(base instanceof ClosureObject) && (expando = MethodResolver.getInstance(context).resolveMethod(base.getClass(), "[]")) != null) {
            MethodInfo info = expando.getMethodInfo(context);
            context.setPropertyResolved(true);
            return info == null ? null : info.getReturnType();
        }
        throw new PropertyNotFoundException();
    }

    public Object getValue(ELContext context, Object base, Object property) {
        MethodClosure expando;
        Field field;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        if ("@@class".equals(property)) {
            context.setPropertyResolved(true);
            if (base instanceof ClosureObject) {
                return ((ClosureObject)base).get_class();
            }
            return base.getClass();
        }
        if (base instanceof Class && (field = this.getBeanField((Class)base, property)) != null && Modifier.isStatic(field.getModifiers())) {
            Object value = this.getFieldValue(field, null);
            context.setPropertyResolved(true);
            return value;
        }
        if (!(base instanceof PropertyDelegate)) {
            BeanProperty bp = this.getBeanProperty(base.getClass(), property);
            if (bp != null) {
                if (bp.getReadMethod() == null) {
                    throw new PropertyNotFoundException();
                }
                Object value = this.getPropertyValue(bp.getReadMethod(), base);
                context.setPropertyResolved(true);
                return value;
            }
            Field field2 = this.getBeanField(base.getClass(), property);
            if (field2 != null) {
                Object value = this.getFieldValue(field2, base);
                context.setPropertyResolved(true);
                return value;
            }
        }
        if (base instanceof PropertyResolvable) {
            Object value = ((PropertyResolvable)base).getValue(context, property);
            if (context.isPropertyResolved()) {
                return value;
            }
        }
        if (!(base instanceof ClosureObject) && (expando = MethodResolver.getInstance(context).resolveMethod(base.getClass(), "[]")) != null) {
            Closure[] args = new Closure[]{new LiteralClosure(property)};
            Object value = expando.invoke(context, base, args);
            context.setPropertyResolved(true);
            return value;
        }
        throw new PropertyNotFoundException();
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        MethodClosure expando;
        Field field;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if ("@@class".equals(property)) {
            throw new PropertyNotWritableException();
        }
        if (base instanceof Class && (field = this.getBeanField((Class)base, property)) != null && Modifier.isStatic(field.getModifiers())) {
            if (Modifier.isFinal(field.getModifiers())) {
                throw new PropertyNotWritableException(((Class)base).getName() + "." + property);
            }
            this.setFieldValue(field, null, value);
            context.setPropertyResolved(true);
            return;
        }
        if (!(base instanceof PropertyDelegate)) {
            BeanProperty bp = this.getBeanProperty(base.getClass(), property);
            if (bp != null) {
                if (bp.getWriteMethod() == null) {
                    throw new PropertyNotWritableException();
                }
                value = TypeCoercion.coerce(context, value, bp.getType());
                this.setPropertyValue(bp.getWriteMethod(), base, value);
                context.setPropertyResolved(true);
                return;
            }
            Field field2 = this.getBeanField(base.getClass(), property);
            if (field2 != null) {
                this.setFieldValue(field2, base, value);
                context.setPropertyResolved(true);
                return;
            }
        }
        if (base instanceof PropertyResolvable) {
            ((PropertyResolvable)base).setValue(context, property, value);
            if (context.isPropertyResolved()) {
                return;
            }
        }
        if (!(base instanceof ClosureObject) && (expando = MethodResolver.getInstance(context).resolveMethod(base.getClass(), "[]=")) != null) {
            Closure[] args = new Closure[]{new LiteralClosure(property), new LiteralClosure(value)};
            expando.invoke(context, base, args);
            context.setPropertyResolved(true);
            return;
        }
        throw new PropertyNotFoundException();
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        MethodResolver resolver;
        Field field;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        if ("@@class".equals(property)) {
            context.setPropertyResolved(true);
            return true;
        }
        if (base instanceof Class && (field = this.getBeanField((Class)base, property)) != null && Modifier.isStatic(field.getModifiers())) {
            context.setPropertyResolved(true);
            return Modifier.isFinal(field.getModifiers());
        }
        if (!(base instanceof PropertyDelegate)) {
            BeanProperty bp = this.getBeanProperty(base.getClass(), property);
            if (bp != null) {
                context.setPropertyResolved(true);
                return bp.getWriteMethod() == null;
            }
            Field field2 = this.getBeanField(base.getClass(), property);
            if (field2 != null) {
                context.setPropertyResolved(true);
                return Modifier.isFinal(field2.getModifiers());
            }
        }
        if (base instanceof PropertyResolvable) {
            boolean value = ((PropertyResolvable)base).isReadOnly(context, property);
            if (context.isPropertyResolved()) {
                return value;
            }
        }
        if (!(base instanceof ClosureObject) && (resolver = MethodResolver.getInstance(context)).resolveMethod(base.getClass(), "[]") != null) {
            context.setPropertyResolved(true);
            return resolver.resolveMethod(base.getClass(), "[]=") == null;
        }
        throw new PropertyNotFoundException();
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        Class<?> baseClass;
        if (base == null) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>();
        for (Class<?> c = baseClass = base.getClass(); c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                if (!this.fieldAccessible(baseClass, f)) continue;
                FeatureDescriptor feat = new FeatureDescriptor();
                feat.setName(f.getName());
                feat.setDisplayName(f.getName());
                feat.setExpert(false);
                feat.setHidden(false);
                feat.setPreferred(true);
                feat.setValue("resolvableAtDesignTime", Boolean.TRUE);
                feat.setValue("type", f.getType());
                list.add(feat);
            }
        }
        try {
            for (BeanProperty bp : BeanUtils.getProperties(baseClass)) {
                FeatureDescriptor feat = new FeatureDescriptor();
                feat.setName(bp.getName());
                feat.setDisplayName(bp.getName());
                feat.setExpert(false);
                feat.setHidden(false);
                feat.setPreferred(true);
                feat.setValue("resolvableAtDesignTime", Boolean.TRUE);
                feat.setValue("type", bp.getType());
                list.add(feat);
            }
        }
        catch (IntrospectionException ex) {
            // empty catch block
        }
        return list.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    protected BeanProperty getBeanProperty(Class baseClass, Object property) {
        try {
            return BeanUtils.getProperty(baseClass, property.toString());
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    protected Object getPropertyValue(Method method, Object base) {
        try {
            return method.invoke(base, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            throw new ELException(ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    protected void setPropertyValue(Method method, Object base, Object value) {
        try {
            method.invoke(base, value);
        }
        catch (InvocationTargetException ex) {
            throw new ELException(ex.getTargetException());
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    protected boolean fieldAccessible(Class baseClass, Field f) {
        return Modifier.isPublic(f.getModifiers());
    }

    protected Object getFieldValue(Field field, Object base) {
        try {
            return field.get(base);
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    protected void setFieldValue(Field field, Object base, Object value) {
        try {
            field.set(base, value);
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    protected Field getBeanField(Class baseClass, Object prop) {
        BeanFields fields = this.cache.get(baseClass);
        if (fields == null) {
            fields = new BeanFields(baseClass);
            this.cache.put(baseClass, fields);
        }
        return fields.getBeanField(prop.toString());
    }

    protected final class BeanFields {
        private final Map<String, Field> fieldMap = new HashMap<String, Field>();

        public BeanFields(final Class baseClass) {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    for (Class c = baseClass; c != null; c = c.getSuperclass()) {
                        for (Field f : c.getDeclaredFields()) {
                            if (!BeanPropertyELResolver.this.fieldAccessible(baseClass, f)) continue;
                            f.setAccessible(true);
                            BeanFields.this.fieldMap.put(f.getName(), f);
                        }
                    }
                    return null;
                }
            });
        }

        public Field getBeanField(String name) {
            return this.fieldMap.get(name);
        }
    }
}

