/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import elite.lang.Range;
import elite.lang.Seq;
import java.beans.FeatureDescriptor;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.el.eval.seq.Cons;
import org.operamasks.el.eval.seq.DelaySeq;
import org.operamasks.el.eval.seq.EmptySeq;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqELResolver
extends ELResolver {
    private boolean isReadOnly;

    public SeqELResolver() {
        this.isReadOnly = false;
    }

    public SeqELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        if (base instanceof Seq) {
            context.setPropertyResolved(true);
            if (property instanceof Range) {
                return Seq.class;
            }
            if ("length".equals(property) || "size".equals(property)) {
                return Integer.class;
            }
            return Object.class;
        }
        return null;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        if (!(base instanceof Seq)) {
            return null;
        }
        Seq seq = (Seq)base;
        Object result = null;
        if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property)) {
                result = seq.size();
                context.setPropertyResolved(true);
            } else if ("first".equals(property) || "head".equals(property)) {
                result = seq.get();
                context.setPropertyResolved(true);
            } else if ("last".equals(property)) {
                result = seq.last().get();
                context.setPropertyResolved(true);
            } else if ("rest".equals(property) || "tail".equals(property)) {
                result = seq.isEmpty() ? seq : seq.tail();
                context.setPropertyResolved(true);
            }
        } else if (property instanceof Range) {
            result = this.extractRange(seq, (Range)property);
            context.setPropertyResolved(true);
        } else if (property instanceof Number) {
            try {
                result = seq.get(((Number)property).intValue());
            }
            catch (IndexOutOfBoundsException ex) {
                result = null;
            }
            context.setPropertyResolved(true);
        } else if (property instanceof List && ((List)property).isEmpty()) {
            result = EmptySeq.make();
            context.setPropertyResolved(true);
        }
        return result;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (!(base instanceof Seq)) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException();
        }
        Seq seq = (Seq)base;
        if (property instanceof String) {
            if ("length".equals(property) || "size".equals(property)) {
                throw new PropertyNotWritableException(property.toString());
            }
            if ("first".equals(property) || "head".equals(property)) {
                if (seq.isEmpty()) {
                    seq.add(value);
                } else {
                    seq.set(value);
                }
                context.setPropertyResolved(true);
            } else if ("last".equals(property)) {
                Seq l = seq.last();
                if (l.isEmpty()) {
                    l.add(value);
                } else {
                    l.set(value);
                }
                context.setPropertyResolved(true);
            } else if ("rest".equals(property) || "tail".equals(property)) {
                seq.set_tail(TypeCoercion.coerceToSeq(value));
                context.setPropertyResolved(true);
            }
        } else if (property instanceof Range) {
            if (value instanceof Collection) {
                this.copyRangeWithCollection(seq, (Range)property, (Collection)value);
            } else if (value instanceof Object[]) {
                this.copyRangeWithArray(seq, (Range)property, (Object[])value);
            } else if (value.getClass().isArray()) {
                this.copyRangeWithPArray(seq, (Range)property, value);
            } else {
                this.copyRangeWithSingle(seq, (Range)property, value);
            }
            context.setPropertyResolved(true);
        } else if (property instanceof Number) {
            int index = ((Number)property).intValue();
            this.set(seq, index, value);
            context.setPropertyResolved(true);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof Seq) {
            context.setPropertyResolved(true);
            return this.isReadOnly;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base instanceof Seq) {
            return Integer.class;
        }
        return null;
    }

    private void set(Seq seq, int index, Object value) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index:" + index);
        }
        while (index > 0 && !seq.isEmpty()) {
            seq = seq.tail();
            --index;
        }
        if (!seq.isEmpty()) {
            seq.set(value);
        } else {
            while (index > 0) {
                seq.add(null);
                seq = seq.tail();
                --index;
            }
            seq.add(value);
        }
    }

    private Seq extractRange(Seq base, Range range) {
        long begin;
        long end = range.getEnd();
        long step = range.getStep();
        if (step == 1L && range.isUnbound()) {
            for (begin = range.getBegin(); begin > 0L && !base.isEmpty(); --begin) {
                base = base.tail();
            }
            return base;
        }
        if (step < 0L) {
            if (begin <= 0L) {
                return Cons.nil();
            }
            if (range.isUnbound() || end < 0L) {
                end = 0L;
            }
            step = -step;
            end = begin - (begin - end) / step * step;
            while (end > 0L && !base.isEmpty()) {
                base = base.tail();
                --end;
                --begin;
            }
            Cons rev = Cons.nil();
            while (begin >= 0L && !base.isEmpty()) {
                rev = new Cons(base.get(), rev);
                long i = step;
                while (!base.isEmpty() && --i >= 0L) {
                    base = base.tail();
                    --begin;
                }
            }
            return rev;
        }
        if (begin < 0L) {
            if (!range.isUnbound() && end < 0L) {
                return Cons.nil();
            }
            begin = 0L;
        }
        while (begin > 0L && !base.isEmpty()) {
            base = base.tail();
            --begin;
            --end;
        }
        if (base.isEmpty()) {
            return base;
        }
        return new RangeSeq(base, (int)step, (int)end);
    }

    private void copyRangeWithSingle(Seq base, Range range, Object value) {
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        boolean inf = range.isUnbound();
        if (step < 0L) {
            if (begin <= 0L) {
                return;
            }
            if (inf || end < 0L) {
                end = 0L;
            }
            step = -step;
            end = begin - (begin - end) / step * step;
            inf = false;
            long t = begin;
            begin = end;
            end = t;
        } else if (begin < 0L) {
            if (!inf && end < 0L) {
                return;
            }
            begin = 0L;
        }
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        while (inf || end >= 0L) {
            if (base.isEmpty()) {
                base.add(value);
            } else {
                base.set(value);
            }
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while ((inf || end >= 0L) && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private void copyRangeWithArray(Seq base, Range range, Object[] value) {
        if (value.length == 0) {
            return;
        }
        if (range.getStep() < 0L) {
            this.reverseCopyRangeWithArray(base, range, value);
            return;
        }
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        boolean inf = range.isUnbound();
        if (begin < 0L) {
            if (!inf && end < 0L) {
                return;
            }
            begin = 0L;
        }
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        int xl = value.length;
        int xi = 0;
        while (inf || end >= 0L) {
            if (base.isEmpty()) {
                base.add(value[xi]);
            } else {
                base.set(value[xi]);
            }
            if (++xi >= xl) break;
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while ((inf || end >= 0L) && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private void reverseCopyRangeWithArray(Seq base, Range range, Object[] value) {
        int xi;
        long begin = range.getEnd();
        long end = range.getBegin();
        long step = -range.getStep();
        if (end <= 0L) {
            return;
        }
        if (range.isUnbound() || begin < 0L) {
            begin = 0L;
        }
        long count = (end - begin + step) / step;
        begin = end - (count - 1L) * step;
        int n = xi = count >= (long)value.length ? value.length - 1 : (int)count - 1;
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        while (end >= 0L) {
            if (base.isEmpty()) {
                base.add(value[xi]);
            } else {
                base.set(value[xi]);
            }
            if (--xi < 0) break;
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while (end >= 0L && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private void copyRangeWithPArray(Seq base, Range range, Object value) {
        if (Array.getLength(value) == 0) {
            return;
        }
        if (range.getStep() < 0L) {
            this.reverseCopyRangeWithPArray(base, range, value);
            return;
        }
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        boolean inf = range.isUnbound();
        if (begin < 0L) {
            if (!inf && end < 0L) {
                return;
            }
            begin = 0L;
        }
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        int xl = Array.getLength(value);
        int xi = 0;
        while (inf || end >= 0L) {
            Object x = Array.get(value, xi);
            if (base.isEmpty()) {
                base.add(x);
            } else {
                base.set(x);
            }
            if (++xi >= xl) break;
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while ((inf || end >= 0L) && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private void reverseCopyRangeWithPArray(Seq base, Range range, Object value) {
        int xi;
        long begin = range.getEnd();
        long end = range.getBegin();
        long step = -range.getStep();
        if (end <= 0L) {
            return;
        }
        if (range.isUnbound() || begin < 0L) {
            begin = 0L;
        }
        long count = (end - begin + step) / step;
        begin = end - (count - 1L) * step;
        int xl = Array.getLength(value);
        int n = xi = count >= (long)xl ? xl - 1 : (int)count - 1;
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        while (end >= 0L) {
            Object x = Array.get(value, xi);
            if (base.isEmpty()) {
                base.add(x);
            } else {
                base.set(x);
            }
            if (--xi < 0) break;
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while (end >= 0L && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private void copyRangeWithCollection(Seq base, Range range, Collection c) {
        if (c.isEmpty()) {
            return;
        }
        if (range.getStep() < 0L) {
            this.copyRangeWithArray(base, range, c.toArray());
            return;
        }
        long begin = range.getBegin();
        long end = range.getEnd();
        long step = range.getStep();
        boolean inf = range.isUnbound();
        if (begin < 0L) {
            if (!inf && end < 0L) {
                return;
            }
            begin = 0L;
        }
        while (begin > 0L) {
            if (base.isEmpty()) {
                base.add(null);
            }
            base = base.tail();
            --begin;
            --end;
        }
        Iterator it = c.iterator();
        if (!it.hasNext()) {
            return;
        }
        while (inf || end >= 0L) {
            if (base.isEmpty()) {
                base.add(it.next());
            } else {
                base.set(it.next());
            }
            if (!it.hasNext()) break;
            if (step == 1L) {
                base = base.tail();
                --end;
                continue;
            }
            long i = step;
            while ((inf || end >= 0L) && --i >= 0L) {
                if (base.isEmpty()) {
                    base.add(null);
                }
                base = base.tail();
                --end;
            }
        }
    }

    private static class RangeSeq
    extends DelaySeq {
        private Seq seq;
        private int step;
        private int end;

        public RangeSeq(Seq seq, int step, int end) {
            this.seq = seq;
            this.step = step;
            this.end = end;
        }

        protected void force() {
            if (this.seq != null) {
                this.head = this.seq.get();
                Seq t = this.seq;
                int i = this.step;
                while (!t.isEmpty() && --i >= 0) {
                    t = t.tail();
                }
                this.tail = t.isEmpty() || this.end - this.step < 0 ? Cons.nil() : new RangeSeq(t, this.step, this.end - this.step);
                this.seq = null;
            }
        }
    }
}

