/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.resolver;

import java.beans.FeatureDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.PropertyNotWritableException;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.el.resolver.PackageCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemClassELResolver
extends ELResolver {
    private Map<String, JavaPackage> packages;
    private static List<String> systemPackages;
    private static PackageCollector collector;
    private static final String APUSIC_LOADER = "com.apusic.web.container.ServletClassLoader";
    private static final String APUSIC_JSP_LOADER = "getJspClassLoader";

    public static void setPackageCollector(PackageCollector collector) {
        SystemClassELResolver.collector = collector;
    }

    public SystemClassELResolver() {
        ClassLoader cl;
        ArrayList<String> names = new ArrayList<String>(systemPackages);
        if (collector != null) {
            names.addAll(collector.findPackages());
        }
        if ((cl = Thread.currentThread().getContextClassLoader()) == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        names.addAll(new TCLPackages(cl).findPackages());
        HashMap<String, JavaPackage> map = new HashMap<String, JavaPackage>();
        for (String name : names) {
            while (name != null) {
                int p;
                if (!map.containsKey(name)) {
                    map.put(name, new JavaPackage(name));
                }
                name = (p = name.lastIndexOf(46)) == -1 ? null : name.substring(0, p);
            }
        }
        this.packages = map;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        String clsname;
        if (property == null) {
            return null;
        }
        if (base == null) {
            clsname = property.toString();
        } else if (base instanceof JavaPackage) {
            clsname = ((JavaPackage)base).getName() + "." + property.toString();
        } else {
            if (base instanceof Class && "class".equals(property)) {
                context.setPropertyResolved(true);
                return base;
            }
            return null;
        }
        JavaPackage pkg = this.packages.get(clsname);
        if (pkg != null) {
            context.setPropertyResolved(true);
            return pkg;
        }
        try {
            Class<?> c = ClassResolver.getInstance(context).resolveClass(clsname);
            context.setPropertyResolved(true);
            return c;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public Class<?> getType(ELContext context, Object base, Object property) {
        String clsname;
        if (property == null) {
            return null;
        }
        if (base == null) {
            clsname = property.toString();
        } else if (base instanceof JavaPackage) {
            clsname = ((JavaPackage)base).getName() + "." + property.toString();
        } else {
            if (base instanceof Class && "class".equals(property)) {
                context.setPropertyResolved(true);
                return Class.class;
            }
            return null;
        }
        if (this.packages.containsKey(clsname)) {
            context.setPropertyResolved(true);
            return JavaPackage.class;
        }
        try {
            ClassResolver.getInstance(context).resolveClass(clsname);
            context.setPropertyResolved(true);
            return Class.class;
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof JavaPackage && property != null) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (base instanceof JavaPackage && property != null) {
            context.setPropertyResolved(true);
            return true;
        }
        return false;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        return null;
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        return null;
    }

    private static ClassLoader getActualClassLoader(ClassLoader cl) {
        try {
            if (cl.getClass().getName().equals(APUSIC_LOADER)) {
                Method method = cl.getClass().getMethod(APUSIC_JSP_LOADER, new Class[0]);
                return (ClassLoader)method.invoke((Object)cl, new Object[0]);
            }
            return cl;
        }
        catch (Throwable ex) {
            return cl;
        }
    }

    static {
        ArrayList<String> names = new ArrayList<String>();
        for (Package pkg : Package.getPackages()) {
            names.add(pkg.getName());
        }
        systemPackages = names;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TCLPackages
    extends ClassLoader
    implements PackageCollector {
        TCLPackages(ClassLoader cl) {
            super(SystemClassELResolver.getActualClassLoader(cl));
        }

        @Override
        public List<String> findPackages() {
            HashSet<String> pkgs = new HashSet<String>();
            for (Package pkg : super.getPackages()) {
                String name = pkg.getName();
                while (name != null) {
                    pkgs.add(name);
                    int p = name.lastIndexOf(46);
                    name = p == -1 ? null : name.substring(0, p);
                }
            }
            return new ArrayList<String>(pkgs);
        }
    }

    private static class JavaPackage
    implements Serializable {
        private final String name;
        private static final long serialVersionUID = 8152143883688685673L;

        public JavaPackage(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "package " + this.name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof JavaPackage) {
                return this.name.equals(((JavaPackage)obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

