/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.script;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.el.ELContext;
import javax.el.ELContextListener;
import javax.el.ExpressionFactory;
import javax.script.ScriptContext;
import javax.script.ScriptEngineFactory;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.resolver.ClassResolver;
import org.operamasks.el.resolver.PackageCollector;
import org.operamasks.el.resolver.SystemClassELResolver;
import org.operamasks.el.script.ELiteScriptEngineFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
PackageCollector,
BundleListener,
ServiceFactory {
    private BundleContext bc;
    private ServiceTracker tracker;
    private volatile List<String> packages;
    private static final String[] EMPTY_STRINGS = new String[0];

    public void start(BundleContext bc) throws Exception {
        this.bc = bc;
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ELiteScriptEngineFactory factory = new ELiteScriptEngineFactory();
        props.put("javax.script.engine", factory.getEngineName());
        props.put("javax.script.engine_version", factory.getEngineVersion());
        props.put("javax.script.language", factory.getLanguageName());
        props.put("javax.script.language_version", factory.getLanguageVersion());
        props.put("javax.script.name", factory.getNames().toArray(EMPTY_STRINGS));
        props.put("javax.script.extension", factory.getExtensions().toArray(EMPTY_STRINGS));
        props.put("javax.script.mime_type", factory.getMimeTypes().toArray(EMPTY_STRINGS));
        bc.registerService(ScriptEngineFactory.class.getName(), (Object)this, props);
        bc.registerService(ExpressionFactory.class.getName(), (Object)ELEngine.getExpressionFactory(), null);
        this.tracker = new ELContextListenerServiceTracker(bc);
        this.tracker.open();
        bc.addBundleListener((BundleListener)this);
        SystemClassELResolver.setPackageCollector(this);
    }

    public void stop(BundleContext bc) throws Exception {
        this.tracker.close();
        bc.removeBundleListener((BundleListener)this);
        SystemClassELResolver.setPackageCollector(null);
    }

    @Override
    public List<String> findPackages() {
        if (this.packages == null) {
            this.packages = this.findExportedPackages();
        }
        return this.packages;
    }

    private List<String> findExportedPackages() {
        ArrayList<String> names = new ArrayList<String>();
        ServiceReference ref = this.bc.getServiceReference(PackageAdmin.class.getName());
        if (ref != null) {
            PackageAdmin pkgadmin = (PackageAdmin)this.bc.getService(ref);
            ExportedPackage[] pkgs = pkgadmin.getExportedPackages((Bundle)null);
            if (pkgs != null) {
                for (ExportedPackage pkg : pkgs) {
                    names.add(pkg.getName());
                }
            }
            this.bc.ungetService(ref);
        }
        return names;
    }

    public void bundleChanged(BundleEvent event) {
        this.packages = null;
    }

    public Object getService(final Bundle bundle, ServiceRegistration registration) {
        return new ELiteScriptEngineFactory(){

            protected void contextCreated(ELContext elctx, ScriptContext sctx) {
                elctx.putContext(ClassResolver.class, (Object)new BundleClassResolver(bundle));
                sctx.setAttribute("bundle", bundle, 100);
                sctx.setAttribute("bundleContext", bundle.getBundleContext(), 100);
            }
        };
    }

    public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
    }

    static class ELContextListenerServiceTracker
    extends ServiceTracker {
        public ELContextListenerServiceTracker(BundleContext context) {
            super(context, ELContextListener.class.getName(), null);
        }

        public Object addingService(ServiceReference reference) {
            Object service = super.addingService(reference);
            if (service != null) {
                ELEngine.addELContextListener((ELContextListener)service);
            }
            return service;
        }

        public void removedService(ServiceReference reference, Object service) {
            ELEngine.removeELContextListener((ELContextListener)service);
            super.removedService(reference, service);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BundleClassResolver
    extends ClassResolver {
        private Bundle bundle;
        private ClassLoader myloader;

        BundleClassResolver(Bundle bundle) {
            this.bundle = bundle;
            this.myloader = Activator.class.getClassLoader();
        }

        @Override
        protected Class<?> resolveClass0(String name) {
            ClassLoader cl;
            Class<?> c = super.resolveClass0(name);
            if (c != null && (cl = c.getClassLoader()) != null && cl != this.myloader) {
                try {
                    this.bundle.loadClass(name);
                }
                catch (ClassNotFoundException ex) {
                    c = null;
                }
            }
            return c;
        }
    }
}

