/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.script;

import elite.lang.Closure;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.script.ScriptContext;
import org.operamasks.el.eval.EvaluationException;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.LiteralClosure;
import org.operamasks.el.eval.closure.ValueChangeListener;
import org.operamasks.el.script.ELiteScriptEngine;

class ContextVariableMapper
extends VariableMapperImpl {
    final ScriptContext context;

    ContextVariableMapper(ScriptContext context) {
        this.context = context;
        super.setVariable("stdin", new StdIn());
        super.setVariable("stdout", new StdOut());
        super.setVariable("stderr", new StdErr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueExpression resolveVariable(String name) {
        ValueExpression expression = super.resolveVariable(name);
        if (expression != null) {
            return expression;
        }
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            int scope = this.context.getAttributesScope(name);
            if (scope != -1) {
                Object value = this.context.getAttribute(name, scope);
                if (value instanceof ValueExpression) {
                    return (ValueExpression)value;
                }
                expression = new ContextValueExpression(name, value);
                super.setVariable(name, expression);
                return expression;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueExpression setVariable(final String name, ValueExpression expression) {
        Object value;
        ValueExpression retval = super.setVariable(name, expression);
        if (expression instanceof Closure && !(expression instanceof ContextValueExpression)) {
            Closure closure = (Closure)expression;
            if (!closure.isPublic()) {
                return retval;
            }
            closure.setValueChangeListener(new ValueChangeListener(){

                public void valueChanged(Object oldValue, Object newValue) {
                    ContextVariableMapper.this.setContextValue(name, newValue);
                }
            });
        }
        if (expression != null) {
            ELContext elctx = (ELContext)this.context.getAttribute(ELiteScriptEngine.EL_CONTEXT_KEY, 100);
            value = expression.getValue(elctx);
        } else {
            value = null;
        }
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            int scope = this.context.getAttributesScope(name);
            if (scope == -1) {
                scope = 100;
            }
            if (expression == null) {
                this.context.removeAttribute(name, scope);
            } else {
                this.context.setAttribute(name, value, scope);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getContextValue(String name) {
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            int scope = this.context.getAttributesScope(name);
            if (scope != -1) {
                return this.context.getAttribute(name, scope);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setContextValue(String name, Object value) {
        ScriptContext scriptContext = this.context;
        synchronized (scriptContext) {
            int scope = this.context.getAttributesScope(name);
            if (scope == -1) {
                scope = 100;
            }
            this.context.setAttribute(name, value, scope);
        }
    }

    static Reader initReader(ELContext elctx, Object value) {
        if (value instanceof Reader) {
            return (Reader)value;
        }
        if (value instanceof InputStream) {
            return new InputStreamReader((InputStream)value);
        }
        throw new EvaluationException(elctx, "Reader expected");
    }

    static PrintWriter initWriter(ELContext elctx, Object value) {
        if (value instanceof PrintWriter) {
            return (PrintWriter)value;
        }
        if (value instanceof Writer) {
            return new PrintWriter((Writer)value, true);
        }
        if (value instanceof OutputStream) {
            return new PrintWriter((OutputStream)value, true);
        }
        throw new EvaluationException(elctx, "Writer expected");
    }

    private class StdErr
    extends LiteralClosure {
        StdErr() {
            super(ContextVariableMapper.initWriter(null, ContextVariableMapper.this.context.getErrorWriter()));
        }

        public void setValue(ELContext elctx, Object value) {
            PrintWriter writer = ContextVariableMapper.initWriter(elctx, value);
            super.setValue(elctx, writer);
            ContextVariableMapper.this.context.setErrorWriter(writer);
        }
    }

    private class StdOut
    extends LiteralClosure {
        StdOut() {
            super(ContextVariableMapper.initWriter(null, ContextVariableMapper.this.context.getWriter()));
        }

        public void setValue(ELContext elctx, Object value) {
            PrintWriter writer = ContextVariableMapper.initWriter(elctx, value);
            super.setValue(elctx, writer);
            ContextVariableMapper.this.context.setWriter(writer);
        }
    }

    private class StdIn
    extends LiteralClosure {
        StdIn() {
            super(ContextVariableMapper.initReader(null, ContextVariableMapper.this.context.getReader()));
        }

        public void setValue(ELContext elctx, Object value) {
            Reader reader = ContextVariableMapper.initReader(elctx, value);
            super.setValue(elctx, reader);
            ContextVariableMapper.this.context.setReader(reader);
        }
    }

    private class ContextValueExpression
    extends LiteralClosure {
        final String name;

        ContextValueExpression(String name, Object value) {
            super(value);
            this.name = name;
        }

        public Object getValue(ELContext elctx) {
            Object value = ContextVariableMapper.this.getContextValue(this.name);
            super.setValue(elctx, value);
            return value;
        }

        public void setValue(ELContext elctx, Object value) {
            super.setValue(elctx, value);
            ContextVariableMapper.this.setContextValue(this.name, value);
        }
    }
}

