/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.shell;

import elite.lang.Builtin;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jline.ANSIBuffer;
import jline.ConsoleReader;
import jline.Terminal;
import org.operamasks.el.parser.IncompleteException;
import org.operamasks.el.shell.ShellContext;
import org.operamasks.el.shell.VariableCompletor;
import org.operamasks.el.shell.command.Command;
import org.operamasks.el.shell.command.CommandProvider;

public class Main {
    private static final String[] WELCOME = new String[]{"Welcome to ELite (Version 0.5.0)", "Copyright (c) 2006-2009 Operamasks Community.", "ELite comes with ABSOLUTELY NO WARRANTY. This is free software,", "and you are welcome to redistribute it under certain conditions.", "Please visit http://www.operamasks.org for details.", ""};
    private static final String[] USAGE = new String[]{"usage: elite [options] [args]", "options:", "  -e <script>        specify a command line script", "  -c <encoding>      specify the encoding of files", "  -i                 interactive mode", "  -h                 print this usage information"};
    private ShellContext shellContext = new ShellContext();
    private String script;
    private String filename;
    private static Map<String, Method> commands = new HashMap<String, Method>();

    public static void main(String[] args) {
        Main main = new Main();
        int status = main.run(args);
        if (status != 0) {
            System.exit(status);
        }
    }

    public int run(String[] args) {
        if (!this.parseOptions(args)) {
            return 1;
        }
        if (this.shellContext.isInteractive()) {
            for (String s : WELCOME) {
                System.out.println(s);
            }
        }
        try {
            ScriptEngine engine = this.createScriptEngine(this.shellContext.getArguments());
            this.shellContext.setEngine(engine);
            int status = 0;
            if (this.filename != null) {
                status = CommandProvider.exec(this.shellContext, this.filename);
            } else if (this.script != null) {
                status = this.exec_script(engine, this.script);
            }
            if (status != 0) {
                return status;
            }
            if (this.shellContext.isInteractive()) {
                this.repl(engine);
            }
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    private boolean parseOptions(String[] args) {
        int argIndex;
        try {
            for (argIndex = 0; argIndex < args.length; ++argIndex) {
                if (args[argIndex].equals("-e")) {
                    this.script = args[++argIndex];
                    continue;
                }
                if (args[argIndex].equals("-c") || args[argIndex].equals("-encoding")) {
                    this.shellContext.setEncoding(args[++argIndex]);
                    continue;
                }
                if (args[argIndex].equals("-i")) {
                    this.shellContext.setInteractive(true);
                    continue;
                }
                if (args[argIndex].startsWith("-")) {
                    this.printUsage();
                    return false;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.printUsage();
            return false;
        }
        if (argIndex < args.length) {
            this.filename = args[argIndex++];
        }
        String[] arguments = new String[args.length - argIndex];
        System.arraycopy(args, argIndex, arguments, 0, arguments.length);
        this.shellContext.setArguments(arguments);
        if (this.filename == null && this.script == null) {
            this.shellContext.setInteractive(true);
        }
        return true;
    }

    private void printUsage() {
        for (String s : USAGE) {
            System.err.println(s);
        }
    }

    private void repl(ScriptEngine engine) throws IOException {
        String prompt;
        String line;
        ELContext elctx = (ELContext)engine.get(ELContext.class.getName());
        ConsoleReader console = new ConsoleReader(System.in, new PrintWriter(System.out));
        console.addCompletor(new VariableCompletor(elctx, engine));
        String buffer = null;
        int lineno = 1;
        while (!this.shellContext.isCompleted() && (line = console.readLine(prompt = lineno == 1 ? "> " : lineno + ") ")) != null) {
            if (lineno == 1) {
                if ((line = line.trim()).length() == 0 || Main.exec_cmd(this.shellContext, line)) continue;
                buffer = line;
            } else {
                if (line.length() == 0) {
                    buffer = null;
                    lineno = 1;
                    continue;
                }
                buffer = buffer + "\n" + line;
            }
            if (buffer.endsWith("\\")) {
                buffer = buffer.substring(0, buffer.length() - 1);
                ++lineno;
                continue;
            }
            try {
                Object value = engine.eval(buffer);
                engine.put("_", value);
                if (value != null) {
                    Builtin.print(elctx, value);
                }
            }
            catch (ScriptException ex) {
                if (ex.getCause() instanceof IncompleteException) {
                    ++lineno;
                    continue;
                }
                System.err.println(Main.hilight(ex.getMessage()));
            }
            catch (Exception ex) {
                this.printStackTrace(ex);
            }
            catch (Error ex) {
                this.printStackTrace(ex);
            }
            buffer = null;
            lineno = 1;
        }
    }

    private static String hilight(String text) {
        if (Terminal.getTerminal().isANSISupported()) {
            ANSIBuffer ansi = new ANSIBuffer();
            ansi.red(text);
            return ansi.toString(true);
        }
        return text;
    }

    private void printStackTrace(Throwable except) {
        if (Terminal.getTerminal().isANSISupported()) {
            StringWriter writer = new StringWriter();
            except.printStackTrace(new PrintWriter(writer));
            System.err.println(Main.hilight(writer.toString()));
        } else {
            except.printStackTrace(System.err);
        }
    }

    private int exec_script(ScriptEngine engine, String script) {
        try {
            Object value = engine.eval(script);
            if (value != null) {
                ELContext elctx = (ELContext)engine.get(ELContext.class.getName());
                Builtin.print(elctx, value);
            }
        }
        catch (ScriptException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    private ScriptEngine createScriptEngine(String[] args) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("ELite");
        engine.put("javax.script.argv", args);
        engine.put("env", System.getenv());
        engine.put("endl", System.getProperty("line.separator"));
        return engine;
    }

    private static boolean exec_cmd(ShellContext shellContext, String cmdline) {
        int sp = cmdline.indexOf(32);
        if (sp == -1) {
            sp = cmdline.length();
        }
        String tok = cmdline.substring(0, sp);
        String args = cmdline.substring(sp).trim();
        if (tok.equals("main")) {
            return false;
        }
        Method cmd = commands.get(tok);
        if (cmd != null) {
            try {
                cmd.invoke(null, shellContext, args);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return true;
        }
        return false;
    }

    static {
        for (Method method : CommandProvider.class.getMethods()) {
            if (!Modifier.isPublic(method.getModifiers()) || !Modifier.isStatic(method.getModifiers()) || "main".equals(method.getName())) continue;
            Command meta = method.getAnnotation(Command.class);
            String key = meta == null ? method.getName() : meta.value();
            commands.put(key, method);
        }
    }
}

