/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.shell;

import java.beans.IntrospectionException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.el.ELContext;
import javax.el.VariableMapper;
import javax.script.ScriptEngine;
import jline.Completor;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.eval.closure.ClosureObject;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VariableCompletor
implements Completor {
    private ELContext elctx;
    private ScriptEngine engine;

    public VariableCompletor(ELContext elctx, ScriptEngine engine) {
        this.elctx = elctx;
        this.engine = engine;
    }

    @Override
    public int complete(String buffer, int cursor, List candidates) {
        int dot = buffer.lastIndexOf(46, cursor);
        if (dot == -1) {
            String prefix = VariableCompletor.scanIdentifier(buffer, cursor, 0);
            if (prefix == null && buffer.substring(0, cursor).trim().length() == 0) {
                prefix = "";
            }
            if (prefix != null) {
                this.completeGlobals(prefix, candidates);
                return cursor - prefix.length();
            }
        } else {
            String base = VariableCompletor.scanBase(buffer, dot, 0);
            String prefix = buffer.substring(dot + 1, cursor);
            if (base != null && (prefix.length() == 0 || VariableCompletor.isIdentifier(prefix)) && this.completeMembers(base, prefix, candidates)) {
                return dot + 1;
            }
        }
        return cursor;
    }

    private void completeGlobals(String prefix, List candidates) {
        VariableMapper vm = this.elctx.getVariableMapper();
        if (vm instanceof VariableMapperImpl) {
            this.addCandidates(((VariableMapperImpl)vm).getVariableMap().keySet(), prefix, candidates);
        }
        MethodResolver resolver = MethodResolver.getInstance(this.elctx);
        this.addCandidates(resolver.listGlobalMethods(), prefix, candidates);
        this.addCandidates(resolver.listSystemMethods(), prefix, candidates);
        Collections.sort(candidates);
    }

    private void addCandidates(Collection<String> from, String prefix, List candidates) {
        for (String name : from) {
            if (!name.startsWith(prefix) || candidates.contains(name)) continue;
            candidates.add(name);
        }
    }

    private boolean completeMembers(String base, String prefix, List candidates) {
        Object value;
        try {
            value = this.engine.eval(base);
            if (value == null) {
                return false;
            }
        }
        catch (Throwable ex) {
            return false;
        }
        if (value instanceof ClosureObject) {
            ClosureObject clo = (ClosureObject)value;
            for (String name : clo.get_closures(this.elctx).keySet()) {
                if (!name.startsWith(prefix) || candidates.contains(name)) continue;
                candidates.add(name);
            }
        } else if (value instanceof Class) {
            String name;
            Class clazz = (Class)value;
            for (Method method : clazz.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || !(name = method.getName() + "()").startsWith(prefix) || candidates.contains(name)) continue;
                candidates.add(name);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (!Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !(name = ((Field)accessibleObject).getName()).startsWith(prefix) || candidates.contains(name)) continue;
                candidates.add(name);
            }
        } else {
            String name;
            Class<?> clazz = value.getClass();
            for (Method method : clazz.getMethods()) {
                if (Modifier.isStatic(method.getModifiers()) || !(name = method.getName() + "()").startsWith(prefix) || candidates.contains(name)) continue;
                candidates.add(name);
            }
            for (AccessibleObject accessibleObject : clazz.getFields()) {
                if (Modifier.isStatic(((Field)accessibleObject).getModifiers()) || !(name = ((Field)accessibleObject).getName()).startsWith(prefix) || candidates.contains(name)) continue;
                candidates.add(name);
            }
            if (prefix.length() != 0) {
                try {
                    for (BeanProperty p : BeanUtils.getProperties(clazz)) {
                        String name2 = p.getName();
                        if (!name2.startsWith(prefix) || candidates.contains(name2)) continue;
                        candidates.add(name2);
                    }
                }
                catch (IntrospectionException ex) {
                    // empty catch block
                }
            }
        }
        Collections.sort(candidates);
        return true;
    }

    private static boolean isIdentifier(String str) {
        if (str.length() > 0 && VariableCompletor.isIdentifierStart(str.charAt(0))) {
            for (int i = 1; i < str.length(); ++i) {
                if (VariableCompletor.isIdentifierPart(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String scanIdentifier(String str, int from, int to) {
        int start = -1;
        int i = from;
        while (--i >= to) {
            char ch = str.charAt(i);
            if (VariableCompletor.isIdentifierStart(ch)) {
                start = i;
                continue;
            }
            if (VariableCompletor.isIdentifierPart(ch)) continue;
            break;
        }
        return start == -1 ? null : str.substring(start, from);
    }

    private static String scanBase(String str, int from, int to) {
        int start = -1;
        int paren = 0;
        int i = from;
        while (--i >= to) {
            char ch = str.charAt(i);
            if (paren == 0) {
                if (VariableCompletor.isIdentifierStart(ch)) {
                    start = i;
                    continue;
                }
                if (ch == ')') {
                    paren = 1;
                    continue;
                }
                if (VariableCompletor.isIdentifierPart(ch) || ch == '.') continue;
                break;
            }
            if (ch == ')') {
                ++paren;
                continue;
            }
            if (ch != '(') continue;
            if (--paren == 0) {
                start = i;
                continue;
            }
            if (paren >= 0) continue;
            break;
        }
        return start == -1 ? null : str.substring(start, from);
    }

    private static boolean isIdentifierStart(char ch) {
        return Character.isJavaIdentifierStart(ch) || ch == '@';
    }

    private static boolean isIdentifierPart(char ch) {
        return Character.isJavaIdentifierPart(ch) || ch == '@' || ch == ':';
    }
}

