/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.el.shell.command;

import elite.lang.Builtin;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.TreeSet;
import javax.el.ELContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.resolver.MethodResolver;
import org.operamasks.el.shell.ShellContext;
import org.operamasks.el.shell.command.Command;

public final class CommandProvider {
    private static final String[] COMMANDS = new String[]{"?                       print this usage information", "@ <filename>            specify a file to execute", "ls [x|a]                list system|global methods and all variable's key", "quit                    quit shell", "which <classname>       find out the absolute path of specify classname"};

    @Command(value="?")
    public static void help(ShellContext shellContext, String args) {
        for (String s : COMMANDS) {
            System.out.println(s);
        }
    }

    @Command(value="@")
    public static int exec(ShellContext shellContext, String filename) {
        if (filename == null || filename.length() == 0) {
            System.err.println("file name is null!");
            return 1;
        }
        try {
            ScriptEngine engine = shellContext.getEngine();
            String text = CommandProvider.readFile(filename, shellContext.getEncoding());
            engine.put("javax.script.filename", filename);
            engine.eval(text);
        }
        catch (ScriptException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
            return 1;
        }
        return 0;
    }

    public static void quit(ShellContext shellContext, String args) {
        System.out.println("Bye!");
        shellContext.setCompleted(true);
    }

    public static void ls(ShellContext shellContext, String args) {
        MethodResolver mr;
        ScriptEngine engine = shellContext.getEngine();
        ELContext elctx = (ELContext)engine.get(ELContext.class.getName());
        TreeSet<String> lst = new TreeSet<String>();
        if (args.indexOf(120) != -1) {
            mr = MethodResolver.getInstance(elctx);
            lst.addAll(mr.listSystemMethods());
        }
        if (args.indexOf(97) != -1) {
            mr = MethodResolver.getInstance(elctx);
            lst.addAll(mr.listGlobalMethods());
        }
        VariableMapperImpl vm = (VariableMapperImpl)elctx.getVariableMapper();
        lst.addAll(vm.getVariableMap().keySet());
        Builtin.print(elctx, lst);
    }

    public static void which(ShellContext shellContext, String args) {
        String resname;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL res = loader.getResource(resname = args.replace('.', '/') + ".class");
        if (res != null) {
            System.out.println(res.toString());
        } else {
            System.err.println(args + ": not found");
        }
    }

    private static String readFile(String path, String encoding) throws IOException {
        int len;
        FileInputStream stream = new FileInputStream(path);
        InputStreamReader reader = encoding != null ? new InputStreamReader((InputStream)stream, encoding) : new InputStreamReader(stream);
        StringBuilder buf = new StringBuilder();
        char[] cbuf = new char[8192];
        while ((len = reader.read(cbuf)) != -1) {
            buf.append(cbuf, 0, len);
        }
        ((Reader)reader).close();
        return buf.toString();
    }
}

