/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.net.sf.cglib.transform.impl;

import org.operamasks.net.sf.cglib.core.CodeEmitter;
import org.operamasks.net.sf.cglib.core.Constants;
import org.operamasks.net.sf.cglib.core.Signature;
import org.operamasks.net.sf.cglib.core.TypeUtils;
import org.operamasks.net.sf.cglib.transform.ClassEmitterTransformer;
import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.Type;

public class AccessFieldTransformer
extends ClassEmitterTransformer {
    private Callback callback;

    public AccessFieldTransformer(Callback callback) {
        this.callback = callback;
    }

    public void declare_field(int access, String name, Type type, Object value, Attribute attrs) {
        super.declare_field(access, name, type, value, attrs);
        String property = TypeUtils.upperFirst(this.callback.getPropertyName(this.getClassType(), name));
        if (property != null) {
            CodeEmitter e = this.begin_method(1, new Signature("get" + property, type, Constants.TYPES_EMPTY), null, null);
            e.load_this();
            e.getfield(name);
            e.return_value();
            e.end_method();
            e = this.begin_method(1, new Signature("set" + property, Type.VOID_TYPE, new Type[]{type}), null, null);
            e.load_this();
            e.load_arg(0);
            e.putfield(name);
            e.return_value();
            e.end_method();
        }
    }

    public static interface Callback {
        public String getPropertyName(Type var1, String var2);
    }
}

