/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.org.objectweb.asm.tree;

import org.operamasks.org.objectweb.asm.Attribute;
import org.operamasks.org.objectweb.asm.ClassAdapter;
import org.operamasks.org.objectweb.asm.ClassVisitor;
import org.operamasks.org.objectweb.asm.CodeVisitor;
import org.operamasks.org.objectweb.asm.tree.ClassNode;
import org.operamasks.org.objectweb.asm.tree.FieldNode;
import org.operamasks.org.objectweb.asm.tree.InnerClassNode;
import org.operamasks.org.objectweb.asm.tree.MethodNode;
import org.operamasks.org.objectweb.asm.tree.TreeCodeAdapter;

public class TreeClassAdapter
extends ClassAdapter {
    public ClassNode classNode;

    public TreeClassAdapter(ClassVisitor cv) {
        super(cv);
    }

    public void visit(int version, int access, String name, String superName, String[] interfaces, String sourceFile) {
        this.classNode = new ClassNode(version, access, name, superName, interfaces, sourceFile);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode icn = new InnerClassNode(name, outerName, innerName, access);
        this.classNode.innerClasses.add(icn);
    }

    public void visitField(int access, String name, String desc, Object value, Attribute attrs) {
        FieldNode fn = new FieldNode(access, name, desc, value, attrs);
        this.classNode.fields.add(fn);
    }

    public CodeVisitor visitMethod(int access, String name, String desc, String[] exceptions, Attribute attrs) {
        MethodNode mn = new MethodNode(access, name, desc, exceptions, attrs);
        this.classNode.methods.add(mn);
        return new TreeCodeAdapter(mn);
    }

    public void visitAttribute(Attribute attr) {
        attr.next = this.classNode.attrs;
        this.classNode.attrs = attr;
    }

    public void visitEnd() {
        if (this.cv != null) {
            this.classNode.accept(this.cv);
        }
    }
}

