/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanUtils {
    private static final SimpleCache<Class, BeanProperties> cache = SimpleCache.make(1000);

    public static final Collection<BeanProperty> getProperties(Class<?> type) throws IntrospectionException {
        BeanProperties properties = cache.get(type);
        if (properties == null) {
            properties = new BeanProperties(type);
            cache.put(type, properties);
        }
        return properties.getAll();
    }

    public static final BeanProperty getProperty(Class<?> type, String name) throws IntrospectionException {
        BeanProperties properties = cache.get(type);
        if (properties == null) {
            properties = new BeanProperties(type);
            cache.put(type, properties);
        }
        return properties.get(name);
    }

    public static final Method getReadMethod(Class<?> type, String name) throws IntrospectionException {
        BeanProperty property = BeanUtils.getProperty(type, name);
        return property == null ? null : property.getReadMethod();
    }

    public static final Method getWriteMethod(Class<?> type, String name) throws IntrospectionException {
        BeanProperty property = BeanUtils.getProperty(type, name);
        return property == null ? null : property.getWriteMethod();
    }

    public static final Class<?> getPropertyType(Class<?> type, String name) throws IntrospectionException {
        BeanProperty property = BeanUtils.getProperty(type, name);
        return property == null ? null : property.getType();
    }

    static final Method getMethod(Class type, Method m) {
        if (m == null || Modifier.isPublic(type.getModifiers())) {
            return m;
        }
        Method mp = null;
        for (Class<?> inf : type.getInterfaces()) {
            try {
                mp = inf.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanUtils.getMethod(mp.getDeclaringClass(), mp);
                if (mp == null) continue;
                return mp;
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class sup = type.getSuperclass();
        if (sup != null) {
            try {
                mp = sup.getMethod(m.getName(), m.getParameterTypes());
                mp = BeanUtils.getMethod(mp.getDeclaringClass(), mp);
                if (mp != null) {
                    return mp;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BeanProperties {
        private final Map<String, BeanProperty> properties;
        private final Class<?> type;

        BeanProperties(Class<?> type) throws IntrospectionException {
            this.type = type;
            this.properties = new HashMap<String, BeanProperty>();
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
                this.properties.put(pd.getName(), new BeanProperty(type, pd));
            }
        }

        public Class<?> getType() {
            return this.type;
        }

        public BeanProperty get(String name) {
            return this.properties.get(name);
        }

        public Collection<BeanProperty> getAll() {
            return Collections.unmodifiableCollection(this.properties.values());
        }
    }
}

