/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.io.IOException;
import java.io.Writer;
import org.operamasks.util.XmlWriter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMWriter
extends XmlWriter {
    public DOMWriter(Writer out) {
        super(out);
    }

    public DOMWriter(Writer out, int step) {
        super(out, step);
    }

    public void writeNode(Node node) throws IOException {
        switch (node.getNodeType()) {
            case 9: 
            case 11: {
                this.writeDocument(node);
                break;
            }
            case 10: {
                this.writeDocType((DocumentType)node);
                break;
            }
            case 1: {
                this.writeElement((Element)node);
                break;
            }
            case 2: {
                this.writeAttribute((Attr)node);
                break;
            }
            case 3: {
                this.writeText((Text)node);
                break;
            }
            case 4: {
                this.writeCDATA((CDATASection)node);
                break;
            }
            case 7: {
                this.writeProcessingInstruction((ProcessingInstruction)node);
                break;
            }
            case 8: {
                this.writeComment((Comment)node);
                break;
            }
            case 5: {
                this.writeEntityReference((EntityReference)node);
            }
        }
    }

    private void writeDocument(Node doc) throws IOException {
        for (Node node = doc.getFirstChild(); node != null; node = node.getNextSibling()) {
            this.writeNode(node);
            this.writeln();
        }
    }

    private void writeDocType(DocumentType doctype) throws IOException {
        super.writeDocType(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
    }

    private void writeElement(Element element) throws IOException {
        this.writeStartTag(element.getNodeName());
        NamedNodeMap attributes = element.getAttributes();
        int length = attributes.getLength();
        for (int i = 0; i < length; ++i) {
            Node attr = attributes.item(i);
            this.writeNode(attr);
        }
        for (Node kid = element.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            this.writeNode(kid);
        }
        this.writeEndTag(element.getNodeName());
    }

    private void writeAttribute(Attr attr) throws IOException {
        super.writeAttribute(attr.getNodeName(), attr.getNodeValue());
    }

    private void writeText(Text text) throws IOException {
        super.writeText(text.getNodeValue());
    }

    private void writeCDATA(CDATASection data) throws IOException {
        super.writeCDATA(data.getNodeValue());
    }

    private void writeProcessingInstruction(ProcessingInstruction pi) throws IOException {
        super.writeProcessingInstruction(pi.getTarget(), pi.getData());
    }

    private void writeComment(Comment comment) throws IOException {
        super.writeComment(comment.getNodeValue());
    }

    private void writeEntityReference(EntityReference ref) throws IOException {
        this.write(38);
        this.write(ref.getNodeName());
        this.write(59);
    }
}

