/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleCache<K, V> {
    private int capacity;
    private Map<Object, V> cache;
    private Map<Object, V> cache2;
    private static Object NULL_KEY = new Object();

    public static <K, V> SimpleCache<K, V> make(int capacity) {
        return new SimpleCache<K, V>(capacity);
    }

    public SimpleCache(int capacity) {
        this.capacity = capacity;
        this.cache = new ConcurrentHashMap<Object, V>(capacity);
        this.cache2 = new ConcurrentHashMap<Object, V>(capacity);
    }

    public V get(Object key) {
        V result;
        if (key == null) {
            key = NULL_KEY;
        }
        if ((result = this.cache.get(key)) == null) {
            result = this.cache2.get(key);
        }
        return result;
    }

    public void put(K key, V value) {
        assert (value != null);
        if (this.cache.size() > this.capacity) {
            this.cache2.clear();
            this.cache2.putAll(this.cache);
            this.cache.clear();
        }
        if (key == null) {
            this.cache.put(NULL_KEY, value);
        } else {
            this.cache.put(key, value);
        }
    }

    public void clear() {
        this.cache.clear();
        this.cache2.clear();
    }
}

