/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io;

import flex.messaging.io.PropertyProxy;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.SerializationDescriptor;
import flex.messaging.io.TypeMarshallingContext;
import flex.messaging.io.amf.ASObject;
import flex.messaging.util.ClassUtil;
import java.io.Externalizable;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractProxy
implements PropertyProxy,
Serializable {
    protected Object defaultInstance;
    protected String alias;
    protected boolean dynamic;
    protected boolean externalizable;
    protected boolean includeReadOnly;
    protected SerializationDescriptor descriptor;
    protected SerializationContext context;

    protected AbstractProxy(Object defaultInstance) {
        this.defaultInstance = defaultInstance;
        if (defaultInstance != null) {
            this.alias = defaultInstance.getClass().getName();
        }
    }

    public Object getDefaultInstance() {
        return this.defaultInstance;
    }

    public void setDefaultInstance(Object instance) {
        this.defaultInstance = instance;
    }

    public static Class getClassFromClassName(String className) {
        TypeMarshallingContext typeContext = TypeMarshallingContext.getTypeMarshallingContext();
        return ClassUtil.createClass(className, typeContext.getClassLoader());
    }

    public static Object createInstanceFromClassName(String className) {
        Class desiredClass = AbstractProxy.getClassFromClassName(className);
        return ClassUtil.createDefaultInstance(desiredClass, null);
    }

    public Object createInstance(String className) {
        ASObject instance;
        if (className == null || className.length() == 0) {
            instance = new ASObject();
        } else if (className.startsWith(">")) {
            instance = new ASObject();
            instance.setType(className);
        } else {
            SerializationContext context = this.getSerializationContext();
            if (context.instantiateTypes || className.startsWith("flex.")) {
                return AbstractProxy.createInstanceFromClassName(className);
            }
            instance = new ASObject();
            instance.setType(className);
        }
        return instance;
    }

    public List getPropertyNames() {
        return this.getPropertyNames(this.getDefaultInstance());
    }

    public Class getType(String propertyName) {
        return this.getType(this.getDefaultInstance(), propertyName);
    }

    public Object getValue(String propertyName) {
        return this.getValue(this.getDefaultInstance(), propertyName);
    }

    public void setValue(String propertyName, Object value) {
        this.setValue(this.getDefaultInstance(), propertyName, value);
    }

    public void setAlias(String value) {
        this.alias = value;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setDynamic(boolean value) {
        this.dynamic = value;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public boolean isExternalizable() {
        return this.externalizable;
    }

    public void setExternalizable(boolean value) {
        this.externalizable = value;
    }

    public boolean isExternalizable(Object instance) {
        return instance instanceof Externalizable;
    }

    public SerializationContext getSerializationContext() {
        if (this.context == null) {
            return SerializationContext.getSerializationContext();
        }
        return this.context;
    }

    public void setSerializationContext(SerializationContext value) {
        this.context = value;
    }

    public void setIncludeReadOnly(boolean value) {
        this.includeReadOnly = value;
    }

    public boolean getIncludeReadOnly() {
        return this.includeReadOnly;
    }

    public SerializationDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(SerializationDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public Object instanceComplete(Object instance) {
        return instance;
    }

    public Object getInstanceToSerialize(Object instance) {
        return instance;
    }

    public Object clone() {
        return null;
    }

    public String toString() {
        if (this.defaultInstance != null) {
            return "[Proxy(inst=" + this.defaultInstance + ") proxyClass=" + this.getClass() + " descriptor=" + this.descriptor + "]";
        }
        return "[Proxy(proxyClass=" + this.getClass() + " descriptor=" + this.descriptor + "]";
    }

    protected void setCloneFieldsFrom(AbstractProxy source) {
        this.setDescriptor(source.getDescriptor());
        this.setDefaultInstance(source.getDefaultInstance());
        this.context = source.context;
        this.includeReadOnly = source.includeReadOnly;
    }
}

