/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.writer.relaxng;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.ConcreteType;
import com.sun.msv.datatype.xsd.DataTypeWithFacet;
import com.sun.msv.datatype.xsd.EnumerationFacet;
import com.sun.msv.datatype.xsd.FinalComponent;
import com.sun.msv.datatype.xsd.FractionDigitsFacet;
import com.sun.msv.datatype.xsd.LengthFacet;
import com.sun.msv.datatype.xsd.ListType;
import com.sun.msv.datatype.xsd.MaxLengthFacet;
import com.sun.msv.datatype.xsd.MinLengthFacet;
import com.sun.msv.datatype.xsd.PatternFacet;
import com.sun.msv.datatype.xsd.RangeFacet;
import com.sun.msv.datatype.xsd.TokenType;
import com.sun.msv.datatype.xsd.TotalDigitsFacet;
import com.sun.msv.datatype.xsd.UnionType;
import com.sun.msv.datatype.xsd.WhiteSpaceFacet;
import com.sun.msv.datatype.xsd.XSDatatype;
import com.sun.msv.datatype.xsd.XSDatatypeImpl;
import com.sun.msv.grammar.AttributeExp;
import com.sun.msv.grammar.BinaryExp;
import com.sun.msv.grammar.ChoiceExp;
import com.sun.msv.grammar.ConcurExp;
import com.sun.msv.grammar.DataExp;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionVisitorVoid;
import com.sun.msv.grammar.InterleaveExp;
import com.sun.msv.grammar.ListExp;
import com.sun.msv.grammar.MixedExp;
import com.sun.msv.grammar.OneOrMoreExp;
import com.sun.msv.grammar.OtherExp;
import com.sun.msv.grammar.ReferenceExp;
import com.sun.msv.grammar.SequenceExp;
import com.sun.msv.grammar.ValueExp;
import com.sun.msv.grammar.relax.EmptyStringType;
import com.sun.msv.grammar.relax.NoneType;
import com.sun.msv.writer.XMLWriter;
import com.sun.msv.writer.relaxng.Context;
import java.util.HashSet;
import java.util.Vector;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.ValidationContext;

public abstract class PatternWriter
implements ExpressionVisitorVoid {
    protected final XMLWriter writer;
    protected final Context context;
    static /* synthetic */ Class class$com$sun$msv$grammar$InterleaveExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$ChoiceExp;
    static /* synthetic */ Class class$com$sun$msv$grammar$SequenceExp;

    public void onAnyString() {
        this.writer.element("text");
    }

    public void onEpsilon() {
        this.writer.element("empty");
    }

    public void onNullSet() {
        this.writer.element("notAllowed");
    }

    protected void serializeUnionType(UnionType dt) {
        this.writer.start("choice");
        int i = 0;
        while (i < dt.memberTypes.length) {
            this.serializeDataType((XSDatatype)dt.memberTypes[i]);
            ++i;
        }
        this.writer.end("choice");
    }

    protected void serializeDataType(XSDatatype dt) {
        if (dt instanceof UnionType) {
            this.serializeUnionType((UnionType)dt);
            return;
        }
        HashSet<String> appliedFacets = new HashSet<String>();
        Vector<XSDatatype> effectiveFacets = new Vector<XSDatatype>();
        XSDatatype x = dt;
        while (x instanceof DataTypeWithFacet || x instanceof FinalComponent) {
            if (x instanceof FinalComponent) {
                x = x.getBaseType();
                continue;
            }
            String facetName = ((DataTypeWithFacet)x).facetName;
            if (facetName.equals("enumeration")) {
                this.serializeEnumeration((XSDatatypeImpl)dt, (EnumerationFacet)x);
                return;
            }
            if (facetName.equals("whiteSpace")) {
                System.err.println("warning: unsupported whiteSpace facet is ignored");
                x = x.getBaseType();
                continue;
            }
            if (!appliedFacets.contains(facetName) || appliedFacets.equals("pattern")) {
                appliedFacets.add(facetName);
                effectiveFacets.add(x);
            }
            x = ((DataTypeWithFacet)x).baseType;
        }
        if (x instanceof ListType) {
            this.serializeListType((XSDatatypeImpl)dt);
            return;
        }
        if (!(x instanceof ConcreteType)) {
            throw new Error(x.getClass().getName());
        }
        if (x instanceof EmptyStringType) {
            this.writer.element("value");
            return;
        }
        if (x instanceof NoneType) {
            this.writer.element("notAllowed");
            return;
        }
        this.writer.start("data", new String[]{"type", x.getName()});
        int i = effectiveFacets.size() - 1;
        while (i >= 0) {
            DataTypeWithFacet dtf = (DataTypeWithFacet)effectiveFacets.get(i);
            if (dtf instanceof LengthFacet) {
                this.param("length", Long.toString(((LengthFacet)dtf).length));
            } else if (dtf instanceof MinLengthFacet) {
                this.param("minLength", Long.toString(((MinLengthFacet)dtf).minLength));
            } else if (dtf instanceof MaxLengthFacet) {
                this.param("maxLength", Long.toString(((MaxLengthFacet)dtf).maxLength));
            } else if (dtf instanceof PatternFacet) {
                String pattern = "";
                PatternFacet pf = (PatternFacet)dtf;
                int j = 0;
                while (j < pf.getRegExps().length) {
                    if (pattern.length() != 0) {
                        pattern = pattern + "|";
                    }
                    pattern = pattern + pf.patterns[j];
                    ++j;
                }
                this.param("pattern", pattern);
            } else if (dtf instanceof TotalDigitsFacet) {
                this.param("totalDigits", Long.toString(((TotalDigitsFacet)dtf).precision));
            } else if (dtf instanceof FractionDigitsFacet) {
                this.param("fractionDigits", Long.toString(((FractionDigitsFacet)dtf).scale));
            } else if (dtf instanceof RangeFacet) {
                this.param(dtf.facetName, dtf.convertToLexicalValue(((RangeFacet)dtf).limitValue, null));
            } else if (!(dtf instanceof WhiteSpaceFacet)) {
                throw new Error();
            }
            --i;
        }
        this.writer.end("data");
    }

    protected void serializeListType(XSDatatypeImpl dt) {
        ListType base = (ListType)dt.getConcreteType();
        if (dt.getFacetObject("length") != null) {
            int len = ((LengthFacet)dt.getFacetObject((String)"length")).length;
            this.writer.start("list");
            int i = 0;
            while (i < len) {
                this.serializeDataType((XSDatatype)base.itemType);
                ++i;
            }
            this.writer.end("list");
            return;
        }
        if (dt.getFacetObject("maxLength") != null) {
            throw new UnsupportedOperationException("warning: maxLength facet to list type is not properly converted.");
        }
        MinLengthFacet minLength = (MinLengthFacet)dt.getFacetObject("minLength");
        this.writer.start("list");
        if (minLength != null) {
            int i = 0;
            while (i < minLength.minLength) {
                this.serializeDataType((XSDatatype)base.itemType);
                ++i;
            }
        }
        this.writer.start("zeroOrMore");
        this.serializeDataType((XSDatatype)base.itemType);
        this.writer.end("zeroOrMore");
        this.writer.end("list");
    }

    public void onAttribute(AttributeExp exp) {
        this.writer.start("attribute");
        this.context.writeNameClass(exp.nameClass);
        this.visitUnary(exp.exp);
        this.writer.end("attribute");
    }

    public void onChoice(ChoiceExp exp) {
        if (exp.exp1 == Expression.epsilon) {
            this.onOptional(exp.exp2);
            return;
        }
        if (exp.exp2 == Expression.epsilon) {
            this.onOptional(exp.exp1);
            return;
        }
        this.visitBinExp("choice", exp, class$com$sun$msv$grammar$ChoiceExp == null ? (class$com$sun$msv$grammar$ChoiceExp = PatternWriter.class$("com.sun.msv.grammar.ChoiceExp")) : class$com$sun$msv$grammar$ChoiceExp);
    }

    public void onConcur(ConcurExp exp) {
        throw new IllegalArgumentException("the grammar includes concur, which is not supported");
    }

    public void onData(DataExp exp) {
        Datatype dt = exp.dt;
        if (dt instanceof XSDatatypeImpl) {
            XSDatatypeImpl dti = (XSDatatypeImpl)dt;
            if (this.isPredefinedType(dt)) {
                this.writer.element("data", new String[]{"type", dti.getName()});
            } else {
                this.serializeDataType((XSDatatype)dti);
            }
            return;
        }
        this.writer.element("data-unknown", new String[]{"class", dt.getClass().getName()});
    }

    public void onElement(ElementExp exp) {
        this.writer.start("element");
        this.context.writeNameClass(exp.getNameClass());
        this.visitUnary(exp.contentModel);
        this.writer.end("element");
    }

    protected void onOptional(Expression exp) {
        if (exp instanceof OneOrMoreExp) {
            this.onZeroOrMore((OneOrMoreExp)exp);
            return;
        }
        this.writer.start("optional");
        this.visitUnary(exp);
        this.writer.end("optional");
    }

    public void visitUnary(Expression exp) {
        if (exp instanceof SequenceExp) {
            SequenceExp seq = (SequenceExp)exp;
            this.visitUnary(seq.exp1);
            seq.exp2.visit(this);
        } else {
            exp.visit(this);
        }
    }

    public void onInterleave(InterleaveExp exp) {
        this.visitBinExp("interleave", exp, class$com$sun$msv$grammar$InterleaveExp == null ? (class$com$sun$msv$grammar$InterleaveExp = PatternWriter.class$("com.sun.msv.grammar.InterleaveExp")) : class$com$sun$msv$grammar$InterleaveExp);
    }

    public void onList(ListExp exp) {
        this.writer.start("list");
        this.visitUnary(exp.exp);
        this.writer.end("list");
    }

    public void onMixed(MixedExp exp) {
        this.writer.start("mixed");
        this.visitUnary(exp.exp);
        this.writer.end("mixed");
    }

    public void onOneOrMore(OneOrMoreExp exp) {
        this.writer.start("oneOrMore");
        this.visitUnary(exp.exp);
        this.writer.end("oneOrMore");
    }

    protected void onZeroOrMore(OneOrMoreExp exp) {
        this.writer.start("zeroOrMore");
        this.visitUnary(exp.exp);
        this.writer.end("zeroOrMore");
    }

    public abstract void onOther(OtherExp var1);

    public abstract void onRef(ReferenceExp var1);

    public void onSequence(SequenceExp exp) {
        this.visitBinExp("group", exp, class$com$sun$msv$grammar$SequenceExp == null ? (class$com$sun$msv$grammar$SequenceExp = PatternWriter.class$("com.sun.msv.grammar.SequenceExp")) : class$com$sun$msv$grammar$SequenceExp);
    }

    public void onValue(ValueExp exp) {
        if (exp.dt instanceof XSDatatypeImpl) {
            XSDatatypeImpl base = (XSDatatypeImpl)exp.dt;
            final Vector<String> ns = new Vector<String>();
            String lex = base.convertToLexicalValue(exp.value, new SerializationContext(){

                public String getNamespacePrefix(String namespaceURI) {
                    int cnt = ns.size() / 2;
                    ns.add("xmlns:ns" + cnt);
                    ns.add(namespaceURI);
                    return "ns" + cnt;
                }
            });
            if (base != TokenType.theInstance) {
                ns.add("type");
                ns.add(base.getName());
            }
            this.writer.start("value", ns.toArray(new String[0]));
            this.writer.characters(lex);
            this.writer.end("value");
            return;
        }
        throw new UnsupportedOperationException(exp.dt.getClass().getName());
    }

    public PatternWriter(Context ctxt) {
        this.writer = ctxt.getWriter();
        this.context = ctxt;
    }

    protected boolean isPredefinedType(Datatype x) {
        return !(x instanceof DataTypeWithFacet) && !(x instanceof UnionType) && !(x instanceof ListType) && !(x instanceof FinalComponent) && !(x instanceof EmptyStringType) && !(x instanceof NoneType);
    }

    protected void serializeEnumeration(XSDatatypeImpl dt, EnumerationFacet enums) {
        Object[] values = enums.values.toArray();
        if (values.length > 1) {
            this.writer.start("choice");
        }
        int i = 0;
        while (i < values.length) {
            final Vector<String> ns = new Vector<String>();
            String lex = dt.convertToLexicalValue(values[i], new SerializationContext(){

                public String getNamespacePrefix(String namespaceURI) {
                    int cnt = ns.size() / 2;
                    ns.add("xmlns:ns" + cnt);
                    ns.add(namespaceURI);
                    return "ns" + cnt;
                }
            });
            boolean allowed = dt.isValid(lex, new ValidationContext(){

                public String getBaseUri() {
                    return null;
                }

                public boolean isNotation(String name) {
                    return true;
                }

                public boolean isUnparsedEntity(String name) {
                    return true;
                }

                public String resolveNamespacePrefix(String prefix) {
                    if (!prefix.startsWith("ns")) {
                        return null;
                    }
                    int i = Integer.parseInt(prefix.substring(2));
                    return (String)ns.get(i * 2 + 1);
                }
            });
            ns.add("type");
            ns.add(dt.getConcreteType().getName());
            if (allowed) {
                this.writer.start("value", ns.toArray(new String[0]));
                this.writer.characters(lex);
                this.writer.end("value");
            }
            ++i;
        }
        if (values.length > 1) {
            this.writer.end("choice");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected void param(String name, String value) {
        this.writer.start("param", new String[]{"name", name});
        this.writer.characters(value);
        this.writer.end("param");
    }

    public void visitBinExp(String elementName, BinaryExp exp, Class type) {
        this.writer.start(elementName);
        Expression[] children = exp.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].visit(this);
            ++i;
        }
        this.writer.end(elementName);
    }
}

