/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code11Encoder
implements BarcodeEncoder {
    private static Code11Encoder instance;
    protected BarSet[] CODES_WIDTH = new BarSet[]{new BarSet("101011"), new BarSet("1101011"), new BarSet("1001011"), new BarSet("1100101"), new BarSet("1011011"), new BarSet("1101101"), new BarSet("1001101"), new BarSet("1010011"), new BarSet("1101001"), new BarSet("110101"), new BarSet("101101")};
    protected BarSet INTER_CHAR = new BarSet("0");
    protected BarSet START_STOP_CHAR = new BarSet("1011001");

    protected Code11Encoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new Code11Encoder();
        }
        return instance;
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n2 = (string.length() - i) % 10;
            n2 = n2 == 0 ? 10 : n2;
            n += this.getCharIndex(string.charAt(i)) * n2;
        }
        String string2 = Integer.toString(n % 11);
        if (string.length() + string2.length() >= 10) {
            n = 0;
            String string3 = string + string2;
            for (int i = string3.length() - 1; i >= 0; --i) {
                int n3 = (string3.length() - i) % 9;
                n3 = n3 == 0 ? 9 : n3;
                n += this.getCharIndex(string3.charAt(i)) * n3;
            }
            string2 = string2 + Integer.toString(n % 9);
        }
        return string2;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Code11] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[string.length() * 2 + 3];
        barSetArray[0] = this.START_STOP_CHAR;
        barSetArray[1] = this.INTER_CHAR;
        for (int i = 0; i < string.length(); ++i) {
            barSetArray[i * 2 + 2] = this.CODES_WIDTH[this.getCharIndex(string.charAt(i))];
            barSetArray[i * 2 + 3] = this.INTER_CHAR;
        }
        barSetArray[barSetArray.length - 1] = this.START_STOP_CHAR;
        return barSetArray;
    }

    private int getCharIndex(char c) {
        return c == '-' ? 10 : c - 48;
    }

    public String toString() {
        return "CODE 11";
    }
}

