/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.BarcodeEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class Code93Encoder
implements BarcodeEncoder {
    protected static BarSet[] CODES = new BarSet[]{new BarSet("100010100"), new BarSet("101001000"), new BarSet("101000100"), new BarSet("101000010"), new BarSet("100101000"), new BarSet("100100100"), new BarSet("100100010"), new BarSet("101010000"), new BarSet("100010010"), new BarSet("100001010"), new BarSet("110101000"), new BarSet("110100100"), new BarSet("110100010"), new BarSet("110010100"), new BarSet("110010010"), new BarSet("110001010"), new BarSet("101101000"), new BarSet("101100100"), new BarSet("101100010"), new BarSet("100110100"), new BarSet("100011010"), new BarSet("101011000"), new BarSet("101001100"), new BarSet("101000110"), new BarSet("100101100"), new BarSet("100010110"), new BarSet("110110100"), new BarSet("110110010"), new BarSet("110101100"), new BarSet("110100110"), new BarSet("110010110"), new BarSet("110011010"), new BarSet("101101100"), new BarSet("101100110"), new BarSet("100110110"), new BarSet("100111010"), new BarSet("100101110"), new BarSet("111010100"), new BarSet("111010010"), new BarSet("111001010"), new BarSet("101101110"), new BarSet("101110110"), new BarSet("110101110"), new BarSet("100100110"), new BarSet("111011010"), new BarSet("111010110"), new BarSet("100110010")};
    protected BarSet START_STOP_CHAR = new BarSet("101011110");
    protected BarSet TERMINATION_BAR = new BarSet("1");
    private static Code93Encoder instance;

    protected Code93Encoder() {
    }

    public static BarcodeEncoder getInstance() {
        if (instance == null) {
            instance = new Code93Encoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 1) {
            throw new InvalidAtributeException("[Code93] Invalid text length (" + string.length() + ").");
        }
        BarSet[] barSetArray = new BarSet[string.length() + 3];
        barSetArray[0] = this.START_STOP_CHAR;
        for (int i = 0; i < string.length(); ++i) {
            barSetArray[i + 1] = CODES[this.getCharIndex(string.charAt(i))];
        }
        barSetArray[barSetArray.length - 2] = this.START_STOP_CHAR;
        barSetArray[barSetArray.length - 1] = this.TERMINATION_BAR;
        return barSetArray;
    }

    protected int getCharIndex(char c) throws InvalidAtributeException {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'Z') {
            return c - 55;
        }
        if (c == '-') {
            return 36;
        }
        if (c == '.') {
            return 37;
        }
        if (c == ' ') {
            return 38;
        }
        if (c == '$') {
            return 39;
        }
        if (c == '/') {
            return 40;
        }
        if (c == '+') {
            return 41;
        }
        if (c == '%') {
            return 42;
        }
        if (c == '\u00b9') {
            return 43;
        }
        if (c == '\u00b3') {
            return 44;
        }
        if (c == '\u00a3') {
            return 45;
        }
        if (c == '\u00b2') {
            return 46;
        }
        throw new InvalidAtributeException("[Code93] The text contains unsuported chars.");
    }

    protected char getChar(byte by) throws InvalidAtributeException {
        if (by >= 0 && by <= 9) {
            return (char)(by + 48);
        }
        if (by >= 10 && by <= 35) {
            return (char)(by + 55);
        }
        if (by == 36) {
            return '-';
        }
        if (by == 37) {
            return '.';
        }
        if (by == 38) {
            return ' ';
        }
        if (by == 39) {
            return '$';
        }
        if (by == 40) {
            return '/';
        }
        if (by == 41) {
            return '+';
        }
        if (by == 42) {
            return '%';
        }
        if (by == 43) {
            return '\u00b9';
        }
        if (by == 44) {
            return '\u00b3';
        }
        if (by == 45) {
            return '\u00a3';
        }
        if (by == 46) {
            return '\u00b2';
        }
        throw new InvalidAtributeException("[Code93] The text contains unsuported chars.");
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            int n2 = (string.length() - i) % 20;
            n2 = n2 == 0 ? 20 : n2;
            n += this.getCharIndex(string.charAt(i)) * n2;
        }
        String string2 = Character.toString(this.getChar((byte)(n % 47)));
        n = 0;
        String string3 = string + string2;
        for (int i = string3.length() - 1; i >= 0; --i) {
            int n3 = (string3.length() - i) % 15;
            n3 = n3 == 0 ? 15 : n3;
            n += this.getCharIndex(string3.charAt(i)) * n3;
        }
        string2 = string2 + Character.toString(this.getChar((byte)(n % 47)));
        return string2;
    }

    public String toString() {
        return "CODE 93";
    }
}

