/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.encode;

import org.jbarcode.encode.BarSet;
import org.jbarcode.encode.EAN13Encoder;
import org.jbarcode.encode.EANEncoder;
import org.jbarcode.encode.InvalidAtributeException;

public class UPCAEncoder
extends EANEncoder {
    private static UPCAEncoder instance;

    private UPCAEncoder() {
    }

    public static UPCAEncoder getInstance() {
        if (instance == null) {
            instance = new UPCAEncoder();
        }
        return instance;
    }

    public BarSet[] encode(String string) throws InvalidAtributeException {
        if (string.length() < 11 || string.length() > 12) {
            throw new InvalidAtributeException("[UPCA] Invalid text length (" + string.length() + ").");
        }
        try {
            return EAN13Encoder.getInstance().encode("0" + string);
        }
        catch (InvalidAtributeException invalidAtributeException) {
            throw new InvalidAtributeException("[UPCA] Only numbers suported.", invalidAtributeException);
        }
    }

    public String computeCheckSum(String string) throws InvalidAtributeException {
        return super.computeCheckSum("0" + string);
    }

    public String convertUPCAtoUPCE(String string) throws InvalidAtributeException {
        if (string.length() != 11 && string.length() != 12) {
            throw new InvalidAtributeException("[UPCA] Invalid text length (" + string.length() + ").");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.charAt(0));
        if (string.charAt(0) != '0' && string.charAt(0) != '1') {
            throw new InvalidAtributeException("[UPCA] Invalid Number System,  only 0 & 1 are valid (" + string.charAt(0) + ").");
        }
        if ("000".equals(string.substring(3, 6)) || "100".equals(string.substring(3, 6)) || "200".equals(string.substring(3, 6))) {
            stringBuffer.append(string.substring(1, 3));
            stringBuffer.append(string.substring(8, 11));
            stringBuffer.append(string.charAt(3));
        } else if ("00".equals(string.substring(4, 6))) {
            stringBuffer.append(string.substring(1, 4));
            stringBuffer.append(string.substring(9, 11));
            stringBuffer.append('3');
        } else if (string.charAt(5) == '0') {
            stringBuffer.append(string.substring(1, 5));
            stringBuffer.append(string.charAt(10));
            stringBuffer.append('4');
        } else if (string.charAt(10) >= '5' && string.charAt(10) <= '9') {
            stringBuffer.append(string.substring(1, 6));
            stringBuffer.append(string.charAt(10));
        } else {
            throw new InvalidAtributeException("[UPCA] Invalid code.");
        }
        if (string.length() == 12) {
            stringBuffer.append(string.charAt(11));
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return "UPC-A";
    }
}

