/*
 * Decompiled with CFR 0.152.
 */
package org.jbarcode.paint;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import org.jbarcode.paint.TextPainter;

public class BaseLineTextPainter
implements TextPainter {
    private static TextPainter instance;

    private BaseLineTextPainter() {
    }

    public static TextPainter getInstance() {
        if (instance == null) {
            instance = new BaseLineTextPainter();
        }
        return instance;
    }

    public void paintText(BufferedImage bufferedImage, String string, int n) {
        Graphics graphics = bufferedImage.getGraphics();
        Font font = new Font("monospace", 0, 10 * n);
        graphics.setFont(font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = fontMetrics.getHeight();
        int n3 = (bufferedImage.getWidth() - fontMetrics.stringWidth(string)) / 2;
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight() * 1 / 20);
        graphics.fillRect(0, bufferedImage.getHeight() - n2 * 9 / 10, bufferedImage.getWidth(), n2 * 9 / 10);
        graphics.setColor(Color.BLACK);
        graphics.drawString(string, n3, bufferedImage.getHeight() - n2 / 10);
    }
}

