/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc;

import com.aliyun.odps.Column;
import com.aliyun.odps.Instance;
import com.aliyun.odps.LogView;
import com.aliyun.odps.Odps;
import com.aliyun.odps.OdpsException;
import com.aliyun.odps.Partition;
import com.aliyun.odps.PartitionSpec;
import com.aliyun.odps.Table;
import com.aliyun.odps.data.ResultSet;
import com.aliyun.odps.jdbc.OdpsConnection;
import com.aliyun.odps.jdbc.OdpsForwardResultSet;
import com.aliyun.odps.jdbc.OdpsResultSetMetaData;
import com.aliyun.odps.jdbc.OdpsScollResultSet;
import com.aliyun.odps.jdbc.OdpsSessionForwardResultSet;
import com.aliyun.odps.jdbc.OdpsStaticResultSet;
import com.aliyun.odps.jdbc.WrapperAdapter;
import com.aliyun.odps.jdbc.utils.OdpsLogger;
import com.aliyun.odps.jdbc.utils.Utils;
import com.aliyun.odps.sqa.SQLExecutor;
import com.aliyun.odps.task.SQLTask;
import com.aliyun.odps.tunnel.InstanceTunnel;
import com.aliyun.odps.tunnel.TunnelException;
import com.aliyun.odps.type.TypeInfo;
import com.aliyun.odps.type.TypeInfoFactory;
import com.aliyun.odps.utils.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;

public class OdpsStatement
extends WrapperAdapter
implements Statement {
    private static Pattern DESC_TABLE_PATTERN = Pattern.compile("\\s*(DESCRIBE|DESC)\\s+([^;]+);?", 34);
    private static Pattern SHOW_TABLES_PATTERN = Pattern.compile("\\s*SHOW\\s+TABLES\\s*;?", 34);
    private static Pattern SHOW_PARTITIONS_PATTERN = Pattern.compile("\\s*SHOW\\s+PARTITIONS\\s+([^;]+);?", 34);
    private static final Pattern TABLE_PARTITION_PATTERN = Pattern.compile("\\s*([\\w\\.]+)(\\s*|(\\s+PARTITION\\s*\\((.*)\\)))\\s*", 2);
    private OdpsConnection connHandle;
    private Instance executeInstance = null;
    private java.sql.ResultSet resultSet = null;
    private int updateCount = -1;
    private int queryTimeout = -1;
    ResultSet sessionResultSet = null;
    boolean updateCountFetched = false;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private static final int POLLING_INTERVAL = 3000;
    private static final String JDBC_SQL_TASK_NAME = "jdbc_sql_task";
    private static java.sql.ResultSet EMPTY_RESULT_SET = null;
    protected boolean isResultSetScrollable = false;
    private Properties sqlTaskProperties;
    protected FetchDirection resultSetFetchDirection = FetchDirection.UNKNOWN;
    protected int resultSetMaxRows = 0;
    protected int resultSetFetchSize = 10000;
    protected Long resultCountLimit = null;
    protected Long resultSizeLimit = null;
    protected boolean enableLimit = false;
    private SQLWarning warningChain = null;

    public static String[] parseTablePartition(String tablePartition) {
        String[] ret = new String[2];
        Matcher m = TABLE_PARTITION_PATTERN.matcher(tablePartition);
        boolean match = m.matches();
        if (match && m.groupCount() >= 1) {
            ret[0] = m.group(1);
        }
        if (match && m.groupCount() >= 4) {
            ret[1] = m.group(4);
        }
        return ret;
    }

    private void descTablePartition(String tablePartition) throws SQLException {
        String[] parsedTablePartition = OdpsStatement.parseTablePartition(tablePartition);
        if (parsedTablePartition[0] == null) {
            throw new SQLException("Invalid argument: " + tablePartition);
        }
        OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Arrays.asList("col_name", "data_type", "comment"), Arrays.asList(TypeInfoFactory.STRING, TypeInfoFactory.STRING, TypeInfoFactory.STRING));
        LinkedList<Object[]> rows = new LinkedList<Object[]>();
        try {
            Table t = this.connHandle.getOdps().tables().get(parsedTablePartition[0]);
            this.addColumnDesc(t.getSchema().getColumns(), rows);
            this.addColumnDesc(t.getSchema().getPartitionColumns(), rows);
            if (t.isPartitioned()) {
                rows.add(new String[]{"", null, null});
                rows.add(new String[]{"# Partition Information", null, null});
                rows.add(new String[]{"# col_name", "data_type", "comment"});
                rows.add(new String[]{"", null, null});
                this.addColumnDesc(t.getSchema().getPartitionColumns(), rows);
                if (parsedTablePartition[1] != null) {
                    Partition partition = t.getPartition(new PartitionSpec(parsedTablePartition[1]));
                    PartitionSpec spec = partition.getPartitionSpec();
                    rows.add(new String[]{"", null, null});
                    rows.add(new String[]{"# Detailed Partition Information", null, null});
                    List partitionValues = partition.getPartitionSpec().keys().stream().map(arg_0 -> ((PartitionSpec)spec).get(arg_0)).collect(Collectors.toList());
                    rows.add(new String[]{"Partition Value:", String.join((CharSequence)", ", partitionValues), null});
                    rows.add(new String[]{"Database:", this.connHandle.getOdps().getDefaultProject(), null});
                    rows.add(new String[]{"Table:", parsedTablePartition[0], null});
                    rows.add(new String[]{"CreateTime:", partition.getCreatedTime().toString(), null});
                    rows.add(new String[]{"LastDDLTime:", partition.getLastMetaModifiedTime().toString(), null});
                    rows.add(new String[]{"LastModifiedTime:", partition.getLastDataModifiedTime().toString(), null});
                }
            }
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        this.resultSet = new OdpsStaticResultSet(this.connHandle, meta, rows.iterator());
    }

    private void addColumnDesc(List<Column> columns, List<Object[]> rows) {
        for (Column c : columns) {
            String[] row = new String[]{c.getName(), c.getTypeInfo().getTypeName(), c.getComment()};
            rows.add(row);
        }
    }

    private void showTables() throws SQLException {
        OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Collections.singletonList("tab_name"), Collections.singletonList(TypeInfoFactory.STRING));
        LinkedList<String[]> rows = new LinkedList<String[]>();
        for (Table table : this.connHandle.getOdps().tables()) {
            rows.add(new String[]{table.getName()});
        }
        this.resultSet = new OdpsStaticResultSet(this.connHandle, meta, rows.iterator());
    }

    private void showPartitions(String table) throws SQLException {
        OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Collections.singletonList("partition"), Collections.singletonList(TypeInfoFactory.STRING));
        LinkedList<String[]> rows = new LinkedList<String[]>();
        for (Partition partition : this.connHandle.getOdps().tables().get(table).getPartitions()) {
            rows.add(new String[]{partition.getPartitionSpec().toString(false, true)});
        }
        this.resultSet = new OdpsStaticResultSet(this.connHandle, meta, rows.iterator());
    }

    OdpsStatement(OdpsConnection conn) {
        this(conn, false);
    }

    OdpsStatement(OdpsConnection conn, boolean isResultSetScrollable) {
        this.connHandle = conn;
        this.sqlTaskProperties = (Properties)conn.getSqlTaskProperties().clone();
        this.resultCountLimit = conn.getCountLimit();
        this.resultSizeLimit = conn.getSizeLimit();
        this.enableLimit = conn.enableLimit();
        this.isResultSetScrollable = isResultSetScrollable;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        if (this.isCancelled || this.executeInstance == null) {
            return;
        }
        try {
            if (this.connHandle.runningInInteractiveMode()) {
                this.connHandle.getExecutor().cancel();
                this.connHandle.log.info("submit cancel query instance id=" + this.executeInstance.getId());
            } else if (!this.executeInstance.isTerminated()) {
                this.executeInstance.stop();
                this.connHandle.log.info("submit cancel to instance id=" + this.executeInstance.getId());
            }
        }
        catch (OdpsException e) {
            throw new SQLException(e);
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.connHandle.log.info("the statement has been closed");
        this.connHandle = null;
        this.executeInstance = null;
        this.sessionResultSet = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public synchronized java.sql.ResultSet executeQuery(String sql) throws SQLException {
        Properties properties = new Properties();
        Matcher descTablePatternMatcher = DESC_TABLE_PATTERN.matcher(sql);
        Matcher showTablesPatternMatcher = SHOW_TABLES_PATTERN.matcher(sql);
        Matcher showPartitionsPatternMatcher = SHOW_PARTITIONS_PATTERN.matcher(sql);
        if (descTablePatternMatcher.matches()) {
            this.descTablePartition(descTablePatternMatcher.group(2));
            return this.getResultSet();
        }
        if (showTablesPatternMatcher.matches()) {
            this.showTables();
            return this.getResultSet();
        }
        if (showPartitionsPatternMatcher.matches()) {
            this.showPartitions(showPartitionsPatternMatcher.group(1));
            return this.getResultSet();
        }
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return EMPTY_RESULT_SET;
        }
        if (this.processUseClause(query)) {
            return EMPTY_RESULT_SET;
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties);
        return this.hasResultSet(query) ? this.getResultSet() : EMPTY_RESULT_SET;
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        Properties properties = new Properties();
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return 0;
        }
        if (this.connHandle.runningInInteractiveMode()) {
            throw new SQLFeatureNotSupportedException("executeUpdate() is not supported in session mode.");
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties);
        return this.updateCount >= 0 ? this.updateCount : 0;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        Properties properties = new Properties();
        Matcher descTablePatternMatcher = DESC_TABLE_PATTERN.matcher(sql);
        Matcher showTablesPatternMatcher = SHOW_TABLES_PATTERN.matcher(sql);
        Matcher showPartitionsPatternMatcher = SHOW_PARTITIONS_PATTERN.matcher(sql);
        if (descTablePatternMatcher.matches()) {
            this.descTablePartition(descTablePatternMatcher.group(2));
            return true;
        }
        if (showTablesPatternMatcher.matches()) {
            this.showTables();
            return true;
        }
        if (showPartitionsPatternMatcher.matches()) {
            this.showPartitions(showPartitionsPatternMatcher.group(1));
            return true;
        }
        String query = Utils.parseSetting(sql, properties);
        if (StringUtils.isNullOrEmpty((String)query)) {
            this.processSetClause(properties);
            return false;
        }
        if (this.processUseClause(query)) {
            return false;
        }
        this.checkClosed();
        this.beforeExecute();
        this.runSQL(query, properties);
        return this.hasResultSet(query);
    }

    public boolean hasResultSet(String sql) throws SQLException {
        if (this.connHandle.runningInInteractiveMode()) {
            return true;
        }
        if (this.updateCount == 0) {
            return OdpsStatement.isQuery(sql);
        }
        return this.updateCount < 0;
    }

    public static boolean isQuery(String sql) throws SQLException {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.matches("^\\s*(--|#).*") || line.matches("^\\s*$")) continue;
                if (!line.matches("(?i)^(\\s*)(SELECT).*$")) break;
                return true;
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        return false;
    }

    private void processSetClause(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            this.connHandle.log.info("set sql task property: " + key + "=" + properties.getProperty(key));
            if (!this.connHandle.disableConnSetting()) {
                this.connHandle.getSqlTaskProperties().setProperty(key, properties.getProperty(key));
            }
            this.sqlTaskProperties.setProperty(key, properties.getProperty(key));
        }
    }

    private boolean processUseClause(String sql) throws SQLFeatureNotSupportedException {
        if (sql.matches("(?i)^(\\s*)(USE)(\\s+)(.*);?(\\s*)$")) {
            int i;
            String project;
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            if ((project = sql.substring((i = sql.toLowerCase().indexOf("use")) + 3).trim()).length() > 0) {
                if (this.connHandle.runningInInteractiveMode()) {
                    throw new SQLFeatureNotSupportedException("ODPS-1850001 - 'use project' is not supported in odps jdbc for now.");
                }
                this.connHandle.getOdps().setDefaultProject(project);
                this.connHandle.log.info("set project to " + project);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OdpsConnection getConnection() throws SQLException {
        return this.connHandle;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        int direction;
        this.checkClosed();
        switch (this.resultSetFetchDirection) {
            case FORWARD: {
                direction = 1000;
                break;
            }
            case REVERSE: {
                direction = 1001;
                break;
            }
            default: {
                direction = 1002;
            }
        }
        return direction;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkClosed();
        return this.resultSetFetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkClosed();
        this.resultSetFetchSize = rows;
    }

    @Override
    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.resultSetMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw new SQLException("max must be >= 0");
        }
        this.resultSetMaxRows = max;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        if (!this.connHandle.runningInInteractiveMode()) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds <= 0) {
            throw new IllegalArgumentException("Invalid query timeout:" + String.valueOf(seconds));
        }
        if (!this.connHandle.runningInInteractiveMode()) {
            this.connHandle.log.error("OdpsDriver do not support query timeout, setQueryTimeout: " + seconds);
        } else {
            this.queryTimeout = seconds;
        }
    }

    @Override
    public java.sql.ResultSet getResultSet() throws SQLException {
        long startTime = System.currentTimeMillis();
        if (this.resultSet == null || this.resultSet.isClosed()) {
            InstanceTunnel tunnel = new InstanceTunnel(this.connHandle.getOdps());
            String te = this.connHandle.getTunnelEndpoint();
            if (!StringUtils.isNullOrEmpty((String)te)) {
                this.connHandle.log.info("using tunnel endpoint: " + te);
                tunnel.setEndpoint(te);
            }
            if (!this.connHandle.runningInInteractiveMode()) {
                try {
                    InstanceTunnel.DownloadSession session;
                    try {
                        session = tunnel.createDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.executeInstance.getId());
                    }
                    catch (TunnelException e1) {
                        this.connHandle.log.error("create download session failed: " + e1.getMessage());
                        this.connHandle.log.error("fallback to limit mode");
                        session = tunnel.createDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.executeInstance.getId(), true);
                    }
                    this.connHandle.log.debug("create download session id=" + session.getId());
                    this.resultSet = this.isResultSetScrollable ? new OdpsScollResultSet(this, this.getResultMeta(session.getSchema().getColumns()), session, OdpsScollResultSet.ResultMode.OFFLINE) : new OdpsForwardResultSet(this, this.getResultMeta(session.getSchema().getColumns()), session, startTime);
                }
                catch (TunnelException e) {
                    this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                    e.printStackTrace();
                    if ("InstanceTypeNotSupported".equalsIgnoreCase(e.getErrorCode())) {
                        return null;
                    }
                    throw new SQLException("create download session failed: instance id=" + this.executeInstance.getId() + ", Error:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                    e.printStackTrace();
                    throw new SQLException("create download session failed: instance id=" + this.executeInstance.getId() + ", Error:" + e.getMessage(), e);
                }
            }
            if (this.sessionResultSet != null) {
                try {
                    InstanceTunnel.DownloadSession session = tunnel.createDirectDownloadSession(this.connHandle.getOdps().getDefaultProject(), this.connHandle.getExecutor().getInstance().getId(), this.connHandle.getExecutor().getTaskName(), this.connHandle.getExecutor().getSubqueryId(), this.enableLimit);
                    OdpsResultSetMetaData meta = this.getResultMeta(this.sessionResultSet.getTableSchema().getColumns());
                    this.resultSet = this.isResultSetScrollable ? new OdpsScollResultSet(this, meta, session, OdpsScollResultSet.ResultMode.INTERACTIVE) : new OdpsSessionForwardResultSet(this, meta, this.sessionResultSet, startTime);
                    this.sessionResultSet = null;
                }
                catch (TunnelException e) {
                    this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                    e.printStackTrace();
                    throw new SQLException("create session resultset failed: instance id=" + this.connHandle.getExecutor().getInstance().getId() + ", Error:" + e.getMessage(), e);
                }
                catch (IOException e) {
                    this.connHandle.log.error("create download session for session failed: " + e.getMessage());
                    e.printStackTrace();
                    throw new SQLException("create session resultset failed: instance id=" + this.connHandle.getExecutor().getInstance().getId() + ", Error:" + e.getMessage(), e);
                }
            }
        }
        return this.resultSet;
    }

    private OdpsResultSetMetaData getResultMeta(List<Column> columns) {
        ArrayList<String> columnNames = new ArrayList<String>();
        ArrayList<TypeInfo> columnSqlTypes = new ArrayList<TypeInfo>();
        for (Column col : columns) {
            columnNames.add(col.getName());
            columnSqlTypes.add(col.getTypeInfo());
        }
        return new OdpsResultSetMetaData(columnNames, columnSqlTypes);
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 1003;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        if (this.updateCountFetched) {
            return -1;
        }
        this.updateCountFetched = true;
        if (this.executeInstance == null) {
            return -1;
        }
        return this.updateCount;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        switch (direction) {
            case 1000: {
                this.resultSetFetchDirection = FetchDirection.FORWARD;
                break;
            }
            case 1001: {
                this.resultSetFetchDirection = FetchDirection.REVERSE;
                break;
            }
            case 1002: {
                this.resultSetFetchDirection = FetchDirection.UNKNOWN;
                break;
            }
            default: {
                throw new SQLException("invalid argument for setFetchDirection()");
            }
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    private void beforeExecute() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.executeInstance = null;
        this.sessionResultSet = null;
        this.isClosed = false;
        this.isCancelled = false;
        this.updateCount = -1;
        this.updateCountFetched = false;
    }

    protected OdpsLogger getParentLogger() {
        return this.connHandle.log;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The statement has been closed");
        }
    }

    private void runSQLOffline(String sql, Odps odps, Map<String, String> settings) throws SQLException, OdpsException {
        Instance.TaskStatus taskStatus;
        long begin = System.currentTimeMillis();
        this.executeInstance = SQLTask.run((Odps)odps, (String)odps.getDefaultProject(), (String)sql, (String)JDBC_SQL_TASK_NAME, settings, null);
        LogView logView = new LogView(odps);
        if (this.connHandle.getLogviewHost() != null) {
            logView.setLogViewHost(this.connHandle.getLogviewHost());
        }
        String logViewUrl = logView.generateLogView(this.executeInstance, 168L);
        this.connHandle.log.info("Run SQL: " + sql);
        this.connHandle.log.info(logViewUrl);
        this.warningChain = new SQLWarning(logViewUrl);
        boolean complete = false;
        while (!complete) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                break;
            }
            complete = Instance.Status.TERMINATED.equals((Object)this.executeInstance.getStatus());
        }
        if ((taskStatus = (Instance.TaskStatus)this.executeInstance.getTaskStatus().get(JDBC_SQL_TASK_NAME)) == null) {
            this.connHandle.log.warn("Failed to get task status. The instance may have been killed before its task was created.");
        } else {
            switch (taskStatus.getStatus()) {
                case SUCCESS: {
                    this.connHandle.log.debug("sql status: success");
                    break;
                }
                case FAILED: {
                    try {
                        String reason = (String)this.executeInstance.getTaskResults().get(JDBC_SQL_TASK_NAME);
                        this.connHandle.log.error("execute sql [" + sql + "] failed: " + reason);
                        throw new SQLException("execute sql [" + sql + "] failed: " + reason, "FAILED");
                    }
                    catch (OdpsException e) {
                        this.connHandle.log.error("Fail to get task status:" + sql, e);
                        throw new SQLException("Fail to get task status", e);
                    }
                }
                case CANCELLED: {
                    this.connHandle.log.info("execute instance cancelled");
                    throw new SQLException("execute instance cancelled", "CANCELLED");
                }
                case WAITING: 
                case RUNNING: 
                case SUSPENDED: {
                    this.connHandle.log.debug("sql status: " + taskStatus.getStatus());
                    break;
                }
            }
        }
        long end = System.currentTimeMillis();
        this.connHandle.log.info("It took me " + (end - begin) + " ms to run sql");
        Instance.TaskSummary taskSummary = null;
        try {
            taskSummary = this.executeInstance.getTaskSummary(JDBC_SQL_TASK_NAME);
        }
        catch (OdpsException e) {
            this.connHandle.log.warn("Failed to get TaskSummary: instance_id=" + this.executeInstance.getId() + ", taskname=" + JDBC_SQL_TASK_NAME);
        }
        if (taskSummary != null) {
            this.updateCount = Utils.getSinkCountFromTaskSummary(StringEscapeUtils.unescapeJava((String)taskSummary.getJsonSummary()));
        } else {
            this.connHandle.log.warn("task summary is empty");
        }
        this.connHandle.log.debug("successfully updated " + this.updateCount + " records");
    }

    private void runSQLInSession(String sql, Map<String, String> settings) throws SQLException, OdpsException {
        Long autoSelectLimit;
        long begin = System.currentTimeMillis();
        SQLExecutor executor = this.connHandle.getExecutor();
        if (this.queryTimeout != -1 && !settings.containsKey("odps.sql.session.query.timeout")) {
            settings.put("odps.sql.session.query.timeout", String.valueOf(this.queryTimeout));
        }
        if ((autoSelectLimit = this.connHandle.getAutoSelectLimit()) != null && autoSelectLimit > 0L) {
            settings.put("odps.sql.select.auto.limit", autoSelectLimit.toString());
        }
        executor.run(sql, settings);
        try {
            this.sessionResultSet = executor.getResultSet(Long.valueOf(0L), this.resultCountLimit, this.resultSizeLimit, this.enableLimit);
            List exeLog = executor.getExecutionLog();
            if (!exeLog.isEmpty()) {
                for (String log : exeLog) {
                    this.connHandle.log.warn("Session execution log:" + log);
                }
            }
        }
        catch (IOException e) {
            this.connHandle.log.error("Run SQL failed", e);
            throw new SQLException("execute sql [" + sql + "] instance:[" + executor.getInstance().getId() + "] failed: " + e.getMessage(), e);
        }
        catch (OdpsException e) {
            this.connHandle.log.error("Run SQL failed", e);
            throw new SQLException("execute sql [" + sql + "] instance:[" + executor.getInstance().getId() + "] failed: " + e.getMessage(), e);
        }
        long end = System.currentTimeMillis();
        this.connHandle.log.info("It took me " + (end - begin) + " ms to run sql");
        this.executeInstance = executor.getInstance();
        String logView = executor.getLogView();
        this.connHandle.log.info("Run SQL: " + sql + ", LogView:" + logView);
        this.warningChain = new SQLWarning(executor.getSummary());
    }

    private void runSQL(String sql, Properties properties) throws SQLException {
        try {
            if (!sql.endsWith(";")) {
                sql = sql + ";";
            }
            Odps odps = this.connHandle.getOdps();
            HashMap<String, String> settings = new HashMap<String, String>();
            for (String key : this.sqlTaskProperties.stringPropertyNames()) {
                settings.put(key, this.sqlTaskProperties.getProperty(key));
            }
            if (properties != null && !properties.isEmpty()) {
                for (String key : properties.stringPropertyNames()) {
                    settings.put(key, properties.getProperty(key));
                }
            }
            if (!settings.isEmpty()) {
                this.connHandle.log.info("Enabled SQL task properties: " + settings);
            }
            if (!this.connHandle.runningInInteractiveMode()) {
                this.runSQLOffline(sql, odps, settings);
            } else {
                this.runSQLInSession(sql, settings);
            }
        }
        catch (OdpsException e) {
            this.connHandle.log.error("Fail to run sql: " + sql, e);
            throw new SQLException("Fail to run sql:" + sql + ", Error:" + e.toString(), e);
        }
    }

    public Instance getExecuteInstance() {
        return this.executeInstance;
    }

    public static String getDefaultTaskName() {
        return JDBC_SQL_TASK_NAME;
    }

    public Properties getSqlTaskProperties() {
        return this.sqlTaskProperties;
    }

    static {
        try {
            OdpsResultSetMetaData meta = new OdpsResultSetMetaData(Collections.singletonList("N/A"), Collections.singletonList(TypeInfoFactory.STRING));
            EMPTY_RESULT_SET = new OdpsStaticResultSet(null, meta, null);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    static enum FetchDirection {
        FORWARD,
        REVERSE,
        UNKNOWN;

    }
}

