/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.odps.jdbc.utils.transformer.to.jdbc;

import com.aliyun.odps.data.SimpleStruct;
import com.aliyun.odps.data.Struct;
import com.aliyun.odps.jdbc.utils.transformer.to.jdbc.AbstractToJdbcDateTypeTransformer;
import com.aliyun.odps.type.TypeInfo;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.TimeZone;

public class ToJdbcStringTransformer
extends AbstractToJdbcDateTypeTransformer {
    static ThreadLocal<Gson> GSON_FORMAT = ThreadLocal.withInitial(() -> {
        JsonSerializer dateTimeSerializer = (date, type, jsonSerializationContext) -> {
            if (date == null) {
                return null;
            }
            return new JsonPrimitive(((SimpleDateFormat)DATETIME_FORMAT.get()).format((Date)date));
        };
        JsonSerializer timestampSerializer = (timestamp, type, jsonSerializationContext) -> {
            if (timestamp == null) {
                return null;
            }
            return new JsonPrimitive(((SimpleDateFormat)TIMESTAMP_FORMAT.get()).format((Date)timestamp));
        };
        JsonSerializer structSerializer = (struct, type, jsonSerializationContext) -> {
            if (struct == null) {
                return null;
            }
            return ToJdbcStringTransformer.normalizeStruct(struct);
        };
        return new GsonBuilder().registerTypeAdapter(Date.class, (Object)dateTimeSerializer).registerTypeAdapter(Timestamp.class, (Object)timestampSerializer).registerTypeAdapter(SimpleStruct.class, (Object)structSerializer).serializeNulls().create();
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone, TypeInfo odpsType) throws SQLException {
        if (o == null) {
            return null;
        }
        if (o instanceof byte[]) {
            return ToJdbcStringTransformer.encodeBytes((byte[])o, charset);
        }
        if (Date.class.isInstance(o)) {
            Calendar.Builder calendarBuilder = new Calendar.Builder().setCalendarType("iso8601").setLenient(true);
            if (timeZone != null) {
                calendarBuilder.setTimeZone(timeZone);
            }
            Calendar calendar = calendarBuilder.build();
            try {
                if (Timestamp.class.isInstance(o)) {
                    ((SimpleDateFormat)TIMESTAMP_FORMAT.get()).setCalendar(calendar);
                    String string = ((SimpleDateFormat)TIMESTAMP_FORMAT.get()).format(o);
                    return string;
                }
                if (java.sql.Date.class.isInstance(o)) {
                    ((SimpleDateFormat)DATE_FORMAT.get()).setCalendar(calendar);
                    String string = ((SimpleDateFormat)DATE_FORMAT.get()).format(o);
                    return string;
                }
                ((SimpleDateFormat)DATETIME_FORMAT.get()).setCalendar(calendar);
                String string = ((SimpleDateFormat)DATETIME_FORMAT.get()).format(o);
                return string;
            }
            finally {
                this.restoreToDefaultCalendar();
            }
        }
        if (odpsType != null) {
            switch (odpsType.getOdpsType()) {
                case ARRAY: 
                case MAP: {
                    return GSON_FORMAT.get().toJson(o);
                }
                case STRUCT: {
                    return GSON_FORMAT.get().toJson(ToJdbcStringTransformer.normalizeStruct(o));
                }
            }
            return o.toString();
        }
        return o.toString();
    }

    @Override
    public Object transform(Object o, String charset, Calendar cal, TimeZone timeZone) throws SQLException {
        return this.transform(o, charset, cal, timeZone, null);
    }

    private static JsonElement normalizeStruct(Object object) {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        Struct struct = (Struct)object;
        for (int i = 0; i < struct.getFieldCount(); ++i) {
            values.put(struct.getFieldName(i), struct.getFieldValue(i));
        }
        return new Gson().toJsonTree(values);
    }
}

