/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.groovy;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GroovyScript {
    private GroovyClassLoader loader;
    private Class<?> scriptClass;
    private String filename;
    private URL resource;
    private File scriptFile;
    private long lastModified = -1L;

    GroovyScript(GroovyClassLoader loader, URL resource, String filename) {
        File scriptFile;
        this.loader = loader;
        this.resource = resource;
        this.filename = filename;
        if (resource.getProtocol().equals("file") && (scriptFile = new File(resource.getFile())).exists()) {
            this.scriptFile = scriptFile;
            this.lastModified = scriptFile.lastModified();
        }
    }

    public Class<?> getScriptClass() throws Exception {
        if (this.scriptClass == null || this.isModified()) {
            this.scriptClass = this.loadScriptClass();
        }
        return this.scriptClass;
    }

    public String getScriptName() {
        return this.filename;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    protected Class<?> loadScriptClass() throws Exception {
        return this.loader.parseClass(this.resource.openStream(), this.filename);
    }

    protected boolean isModified() {
        long timestamp;
        if (this.scriptFile != null && (timestamp = this.scriptFile.lastModified()) != this.lastModified) {
            this.lastModified = timestamp;
            return true;
        }
        return false;
    }
}

