/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import org.operamasks.faces.application.TargetCreator;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTargetCreator
implements TargetCreator {
    private Class targetClass;
    private Constructor constructor;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.application");

    public DefaultTargetCreator(Class targetClass) {
        this.targetClass = targetClass;
    }

    public DefaultTargetCreator(Class targetClass, Class argType) {
        this.targetClass = targetClass;
        try {
            this.constructor = targetClass.getConstructor(argType);
        }
        catch (NoSuchMethodException ex) {
            this.logger.log(Level.FINE, "retrieve constructor method fails: " + ex);
        }
    }

    @Override
    public Object createTarget(Object arg) {
        try {
            if (arg != null && this.constructor != null) {
                return this.constructor.newInstance(arg);
            }
            return this.targetClass.newInstance();
        }
        catch (Exception ex) {
            throw new FacesException(Resources._T("JSF_CREATE_TARGET_ERROR", this.targetClass.getName()), (Throwable)ex);
        }
    }

    @Override
    public Class<?> getTargetClass() {
        return this.targetClass;
    }
}

