/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.operamasks.faces.internal.util.OMUtils;

public class DeltaState
implements Serializable {
    private static final long serialVersionUID = -6783183277497492795L;
    private Map<Integer, Object> state = new HashMap<Integer, Object>();
    private static Logger log = Logger.getLogger("org.operamasks.state");

    public DeltaState(Object origState, Object newState) {
        assert (origState instanceof Object[]);
        assert (newState instanceof Object[]);
        this.recursiveCompareState(0, (Object[])origState, (Object[])newState);
    }

    private int recursiveCompareState(int counter, Object[] origState, Object[] newState) {
        int len = origState.length;
        for (int i = 0; i < len; ++i) {
            Object origStateObj = origState[i];
            Object newStateObj = newState[i];
            if (origStateObj instanceof Object[]) {
                if (newStateObj instanceof Object[] && ((Object[])origStateObj).length == ((Object[])newStateObj).length) {
                    counter = this.recursiveCompareState(counter, (Object[])origStateObj, (Object[])newStateObj);
                } else {
                    counter = this.getCurrentCounter((Object[])origStateObj, counter);
                    this.state.put(counter, newStateObj);
                }
            } else if (!OMUtils.isObjectEquals(origStateObj, newStateObj)) {
                this.state.put(counter, newStateObj);
            }
            ++counter;
        }
        return counter;
    }

    private int getCurrentCounter(Object[] root, int counter) {
        int result = counter;
        for (Object obj : root) {
            if (obj instanceof Object[]) {
                result = this.getCurrentCounter((Object[])obj, result);
            }
            ++result;
        }
        return result;
    }

    public Object combineOrigState(Object origState) {
        assert (origState instanceof Object[]);
        Object result = this.clone(origState);
        this.recursiveCombineState(0, (Object[])result);
        return result;
    }

    private int recursiveCombineState(int counter, Object[] newState) {
        for (Object newStateObj : newState) {
            if (newStateObj != null && newStateObj instanceof Object[]) {
                int currentCounter = this.getCurrentCounter((Object[])newStateObj, counter);
                if (this.state.containsKey(currentCounter)) {
                    counter = currentCounter;
                    newState[i] = this.state.get(counter);
                } else {
                    counter = this.recursiveCombineState(counter, (Object[])newStateObj);
                }
            } else if (this.state.containsKey(counter)) {
                newState[i] = this.state.get(counter);
            }
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object clone(Object obj) {
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        Object result = null;
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            out = new ObjectOutputStream(bout);
            out.writeObject(obj);
            out.flush();
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            final ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            in = new ObjectInputStream(bin){

                protected Class resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                    return Class.forName(desc.getName(), true, contextLoader);
                }
            };
            result = in.readObject();
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "Exception occured in state cloning.", e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e1) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e1) {}
            }
        }
        return result;
    }
}

