/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.el.ELContext;
import javax.faces.FacesException;
import javax.faces.context.FacesContext;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.event.ModelEvent;
import org.operamasks.faces.event.ModelEventListener;
import org.operamasks.util.Utils;

public class ModelEventListenerMethodAdapter
implements ModelEventListener {
    private String beanName;
    private Method method;

    public ModelEventListenerMethodAdapter(String beanName, Method method) {
        this.beanName = beanName;
        this.method = method;
    }

    private Method getMethod(Class targetClass) {
        if (this.method != null) {
            this.method = Utils.checkMethod((Class)targetClass, (Method)this.method);
        }
        return this.method;
    }

    public void processModelEvent(ModelEvent event) {
        FacesContext context = FacesContext.getCurrentInstance();
        ModelBean bean = this.getListenerBean(context, event);
        if (bean == null) {
            return;
        }
        Method method = this.getMethod(bean.getTargetClass());
        if (method == null) {
            return;
        }
        try {
            String outcome;
            Class[] types = method.getParameterTypes();
            Object[] params = event.getParameters();
            Object[] values = types.length == 1 && types[0] == ModelEvent.class ? new Object[]{event} : Utils.buildParameterList((Class[])types, (Object[])params, (boolean)method.isVarArgs());
            bean.inject(context);
            Object result = bean.invokeAction(method, values);
            bean.outject(context);
            if (result != null && !context.getRenderResponse() && (outcome = result.toString()).startsWith("view:")) {
                context.getApplication().getNavigationHandler().handleNavigation(context, null, outcome);
                context.renderResponse();
            }
        }
        catch (InvocationTargetException ex) {
            throw new FacesException(ex.getTargetException());
        }
        catch (Exception ex) {
            throw new FacesException((Throwable)ex);
        }
    }

    private ModelBean getListenerBean(FacesContext context, ModelEvent event) {
        Object[] params;
        if (("org.operamasks.faces.MANAGED_BEAN_CREATED".equals(event.getEventType()) || "org.operamasks.faces.MANAGED_BEAN_DESTROYED".equals(event.getEventType())) && this.beanName.equals((params = event.getParameters())[0])) {
            return ModelBean.wrap(params[2]);
        }
        ELContext elContext = context.getELContext();
        Object bean = elContext.getELResolver().getValue(elContext, null, (Object)this.beanName);
        if (elContext.isPropertyResolved() && bean != null) {
            return ModelBean.wrap(bean);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelEventListenerMethodAdapter) {
            ModelEventListenerMethodAdapter other = (ModelEventListenerMethodAdapter)obj;
            if (!this.beanName.equals(other.beanName)) {
                return false;
            }
            if (this.method == null) {
                return other.method == null;
            }
            return this.method.equals(other.method);
        }
        return false;
    }

    public int hashCode() {
        int h = this.beanName.hashCode();
        if (this.method != null) {
            h ^= this.method.hashCode();
        }
        return h;
    }
}

