/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import org.operamasks.faces.application.impl.ChildComponentStructure;
import org.operamasks.faces.application.impl.ComponentStructure;
import org.operamasks.faces.application.impl.ComponentViewState;
import org.operamasks.faces.application.impl.DeltaState;
import org.operamasks.faces.application.impl.TreeStructure;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.internal.util.ViewStateStrategy;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagerImpl
extends StateManager {
    private static final String SERVER_VIEW_STATE = "org.operamasks.faces.SERVER_VIEW_STATE";
    private static final String ATTACHED_STATE_PARAM = "org.operamasks.faces.ATTACHED_STATE";

    public Object saveView(FacesContext context) {
        if (context.getViewRoot().isTransient()) {
            return null;
        }
        this.checkIdUniqueness(context);
        Object treeStructure = this.getTreeStructureToSave(context);
        Object componentState = this.getComponentStateToSave(context);
        Object attachedState = this.getAttachedStateToSave(context);
        Integer viewStateStrategy = this.getViewStateStrategy(context);
        Object[] state = new Object[]{treeStructure, componentState, attachedState, viewStateStrategy};
        if (this.isSavingStateInClient(context)) {
            return state;
        }
        return this.saveStateInServer(context, state);
    }

    private Integer getViewStateStrategy(FacesContext context) {
        String strategy = (String)context.getExternalContext().getRequestMap().get("org.operamasks.faces.VIEW_STATE_STRATEGY");
        return OMUtils.parseViewStateStrategy(strategy);
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        String renderKitId = context.getViewRoot().getRenderKitId();
        RenderKit renderKit = FacesUtils.getRenderKit(context, renderKitId);
        if (renderKit == null) {
            throw new FacesException(Resources._T("JSF_NO_SUCH_RENDER_KIT_ID", renderKitId));
        }
        renderKit.getResponseStateManager().writeState(context, state);
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot view = context.getViewRoot();
        Object state = this.isSavingStateInClient(context) ? this.restoreStateFromClient(context, viewId, renderKitId) : this.restoreStateFromServer(context, viewId);
        if (state != null) {
            Object[] stateArray = (Object[])state;
            HashMap treeStructure = stateArray[0];
            Object componentState = stateArray[1];
            Object attachedState = stateArray[2];
            Integer viewStateStrategyCode = (Integer)stateArray[3];
            ViewStateStrategy viewStateStrategy = ViewStateStrategy.values()[viewStateStrategyCode];
            if (view == null) {
                if (ViewStateStrategy.DELTA.equals((Object)viewStateStrategy)) {
                    if (treeStructure == null) {
                        treeStructure = new HashMap();
                    }
                    view = this.restoreDeltaTreeStructure(context, viewId, treeStructure, (Map)componentState);
                } else if (treeStructure != null) {
                    view = (UIViewRoot)this.restoreTreeStructure((TreeStructure)((Object)treeStructure));
                }
            }
            if (view != null) {
                if (ViewStateStrategy.DELTA.equals((Object)viewStateStrategy)) {
                    this.restoreDeltaViewState(context, view, (Map)componentState, viewId);
                } else if (componentState != null) {
                    view.processRestoreState(context, componentState);
                }
                if (attachedState != null) {
                    this.setAttachedStateToRestore(context, attachedState);
                }
            }
        }
        return view;
    }

    private Object restoreStateFromClient(FacesContext context, String viewId, String renderKitId) {
        RenderKit renderKit = context.getRenderKit();
        if (renderKit == null && (renderKit = FacesUtils.getRenderKit(context, renderKitId)) == null) {
            throw new FacesException(Resources._T("JSF_NO_SUCH_RENDER_KIT_ID", renderKitId));
        }
        return renderKit.getResponseStateManager().getState(context, viewId);
    }

    private Object saveStateInServer(FacesContext context, Object state) {
        String viewId = context.getViewRoot().getViewId();
        Map sessionMap = context.getExternalContext().getSessionMap();
        HashMap<String, Object> viewMap = (HashMap<String, Object>)sessionMap.get(SERVER_VIEW_STATE);
        if (viewMap == null) {
            viewMap = new HashMap<String, Object>();
            sessionMap.put(SERVER_VIEW_STATE, viewMap);
        }
        viewMap.put(viewId, state);
        return new Object[]{viewId, null};
    }

    private Object restoreStateFromServer(FacesContext context, String viewId) {
        if (context.getExternalContext().getSession(false) == null) {
            return null;
        }
        Map sessionMap = context.getExternalContext().getSessionMap();
        Map viewMap = (Map)sessionMap.get(SERVER_VIEW_STATE);
        return viewMap == null ? null : viewMap.get(viewId);
    }

    private TreeStructure buildTreeStructure(UIComponent component) {
        TreeStructure struct = new TreeStructure(component);
        for (UIComponent uIComponent : component.getChildren()) {
            if (uIComponent.isTransient()) continue;
            TreeStructure childStruct = this.buildTreeStructure(uIComponent);
            struct.addChild(childStruct);
        }
        for (Map.Entry entry : component.getFacets().entrySet()) {
            UIComponent facet = (UIComponent)entry.getValue();
            if (facet.isTransient()) continue;
            TreeStructure facetStruct = this.buildTreeStructure(facet);
            struct.addFacet((String)entry.getKey(), facetStruct);
        }
        return struct;
    }

    private UIComponent restoreTreeStructure(TreeStructure struct) {
        UIComponent component = struct.createComponent();
        for (TreeStructure treeStructure : struct.getChildren()) {
            UIComponent child = this.restoreTreeStructure(treeStructure);
            component.getChildren().add(child);
        }
        for (Map.Entry entry : struct.getFacets().entrySet()) {
            UIComponent facet = this.restoreTreeStructure((TreeStructure)entry.getValue());
            component.getFacets().put(entry.getKey(), facet);
        }
        return component;
    }

    private Object buildDeltaTreeStructure(FacesContext context, UIViewRoot viewRoot) {
        Map<String, ComponentViewState> origCompViewState = OMUtils.getOrigViewStateMaps(context).get(context.getViewRoot().getViewId());
        HashMap<String, TreeStructure> structMap = new HashMap<String, TreeStructure>();
        UIViewRoot root = context.getViewRoot();
        if (!root.isTransient()) {
            String clientId = root.getClientId(context);
            this.recursiveBuildDeltaTreeStructure(context, clientId, origCompViewState, (UIComponent)root, structMap);
        }
        return structMap.size() > 0 ? structMap : null;
    }

    private void recursiveBuildDeltaTreeStructure(FacesContext context, String clientId, Map<String, ComponentViewState> origViewStateMap, UIComponent comp, Map<String, TreeStructure> structMap) {
        ComponentViewState origCompViewState = origViewStateMap.get(clientId);
        if (origCompViewState != null) {
            ComponentStructure origCompStruct = origCompViewState.getCompStruct();
            ComponentStructure newCompStruct = new ComponentStructure(comp);
            if (!((Object)origCompStruct.getChildren()).equals(newCompStruct.getChildren())) {
                TreeStructure treeStructure = new TreeStructure(comp);
                for (UIComponent uIComponent : comp.getChildren()) {
                    if (uIComponent.isTransient()) continue;
                    TreeStructure childStruct = this.buildTreeStructure(uIComponent);
                    treeStructure.addChild(childStruct);
                }
                for (Map.Entry entry : comp.getFacets().entrySet()) {
                    UIComponent facet = (UIComponent)entry.getValue();
                    if (facet.isTransient()) continue;
                    TreeStructure facetStruct = this.buildTreeStructure(facet);
                    treeStructure.addFacet((String)entry.getKey(), facetStruct);
                }
                structMap.put(clientId, treeStructure);
            } else {
                Iterator iterator = comp.getFacetsAndChildren();
                while (iterator.hasNext()) {
                    UIComponent child = (UIComponent)iterator.next();
                    if (child.isTransient()) continue;
                    String string = child.getClientId(context);
                    this.recursiveBuildDeltaTreeStructure(context, string, origViewStateMap, child, structMap);
                }
            }
        } else {
            TreeStructure newStruct = new TreeStructure(comp);
            for (UIComponent uIComponent : comp.getChildren()) {
                if (uIComponent.isTransient()) continue;
                TreeStructure childStruct = this.buildTreeStructure(uIComponent);
                newStruct.addChild(childStruct);
            }
            for (Map.Entry entry : comp.getFacets().entrySet()) {
                UIComponent facet = (UIComponent)entry.getValue();
                if (facet.isTransient()) continue;
                TreeStructure treeStructure = this.buildTreeStructure(facet);
                newStruct.addFacet((String)entry.getKey(), treeStructure);
            }
            structMap.put(clientId, newStruct);
        }
    }

    private UIViewRoot restoreDeltaTreeStructure(FacesContext context, String viewId, Map<String, TreeStructure> structMap, Map<Object, Object> componentState) {
        UIViewRoot viewRoot;
        Map<String, ComponentViewState> origCompViewState = OMUtils.getOrigViewStateMaps(context).get(viewId);
        if (structMap.containsKey("___viewroot___")) {
            TreeStructure rootCompStructure = structMap.get("___viewroot___");
            viewRoot = (UIViewRoot)rootCompStructure.createComponent();
            this.restoreViewRootState(context, viewRoot, componentState, origCompViewState);
            context.setViewRoot(viewRoot);
            for (TreeStructure treeStructure : rootCompStructure.getChildren()) {
                UIComponent child = this.restoreTreeStructure(treeStructure);
                viewRoot.getChildren().add(child);
            }
            for (Map.Entry entry : rootCompStructure.getFacets().entrySet()) {
                UIComponent facet = this.restoreTreeStructure((TreeStructure)entry.getValue());
                viewRoot.getFacets().put(entry.getKey(), facet);
            }
        } else {
            String clientId;
            ComponentStructure rootCompStruct = origCompViewState.get("___viewroot___").getCompStruct();
            viewRoot = (UIViewRoot)rootCompStruct.createComponent();
            this.restoreViewRootState(context, viewRoot, componentState, origCompViewState);
            context.setViewRoot(viewRoot);
            for (ChildComponentStructure childComponentStructure : rootCompStruct.getChildren()) {
                UIComponent child = childComponentStructure.createComponent();
                viewRoot.getChildren().add(child);
                clientId = child.getClientId(context);
                this.fillChildrenComponent(context, clientId, child, origCompViewState, structMap);
            }
            for (Map.Entry entry : rootCompStruct.getFacets().entrySet()) {
                UIComponent facet = ((ChildComponentStructure)entry.getValue()).createComponent();
                viewRoot.getFacets().put(entry.getKey(), facet);
                clientId = facet.getClientId(context);
                this.fillChildrenComponent(context, clientId, facet, origCompViewState, structMap);
            }
        }
        return viewRoot;
    }

    private void restoreViewRootState(FacesContext context, UIViewRoot viewRoot, Map<Object, Object> stateMap, Map<String, ComponentViewState> origCompMap) {
        viewRoot.restoreState(context, origCompMap.get("___viewroot___").getCompState());
        if (stateMap != null && stateMap.containsKey("___viewroot___")) {
            Object state = stateMap.get("___viewroot___");
            if (state instanceof DeltaState) {
                ComponentViewState origCompViewState = origCompMap.get("___viewroot___");
                Object origState = origCompViewState.getCompState();
                Object newState = ((DeltaState)state).combineOrigState(origState);
                viewRoot.restoreState(context, newState);
            } else {
                viewRoot.restoreState(context, state);
            }
        } else {
            ComponentViewState origCompViewState = origCompMap.get("___viewroot___");
            if (origCompViewState != null) {
                viewRoot.restoreState(context, origCompViewState.getCompState());
            }
        }
    }

    private void fillChildrenComponent(FacesContext context, String clientId, UIComponent parent, Map<String, ComponentViewState> origCompMap, Map<String, TreeStructure> strutureMap) {
        block5: {
            String childClientId;
            block4: {
                if (!strutureMap.containsKey(clientId)) break block4;
                TreeStructure rootStructure = strutureMap.get(clientId);
                for (TreeStructure treeStructure : rootStructure.getChildren()) {
                    UIComponent uIComponent = this.restoreTreeStructure(treeStructure);
                    parent.getChildren().add(uIComponent);
                }
                for (Map.Entry entry : rootStructure.getFacets().entrySet()) {
                    UIComponent uIComponent = this.restoreTreeStructure((TreeStructure)entry.getValue());
                    parent.getFacets().put(entry.getKey(), uIComponent);
                }
                break block5;
            }
            ComponentViewState origCompViewState = origCompMap.get(clientId);
            if (origCompViewState == null) break block5;
            ComponentStructure origCompStruct = origCompViewState.getCompStruct();
            for (ChildComponentStructure childComponentStructure : origCompStruct.getChildren()) {
                UIComponent child = childComponentStructure.createComponent();
                parent.getChildren().add(child);
                childClientId = child.getClientId(context);
                this.fillChildrenComponent(context, childClientId, child, origCompMap, strutureMap);
            }
            for (Map.Entry<String, ChildComponentStructure> entry : origCompStruct.getFacets().entrySet()) {
                UIComponent facet = entry.getValue().createComponent();
                parent.getFacets().put(entry.getKey(), facet);
                childClientId = facet.getClientId(context);
                this.fillChildrenComponent(context, childClientId, facet, origCompMap, strutureMap);
            }
        }
    }

    private void checkIdUniqueness(FacesContext context) {
        HashSet<String> componentIds = new HashSet<String>();
        Iterator<UIComponent> itr = FacesUtils.createFacetsAndChildrenIterator((UIComponent)context.getViewRoot(), true);
        while (itr.hasNext()) {
            UIComponent component = itr.next();
            String id = component.getClientId(context);
            if (id == null || componentIds.add(id)) continue;
            throw new IllegalStateException(Resources._T("JSF_DUPLICATE_COMPONENT_ID", id + "[" + component.getClass().getName() + "]"));
        }
    }

    public StateManager.SerializedView saveSerializedView(FacesContext context) {
        Object[] state = (Object[])this.saveView(context);
        if (state == null) {
            return null;
        }
        return new StateManager.SerializedView((StateManager)this, state[0], state[1]);
    }

    public void writeState(FacesContext context, StateManager.SerializedView view) throws IOException {
        Object[] state = new Object[]{view.getStructure(), view.getState()};
        this.writeState(context, state);
    }

    protected Object getTreeStructureToSave(FacesContext context) {
        UIViewRoot viewRoot = context.getViewRoot();
        if (OMUtils.isDeltaViewState(context)) {
            return this.buildDeltaTreeStructure(context, viewRoot);
        }
        return this.buildTreeStructure((UIComponent)viewRoot);
    }

    protected Object getComponentStateToSave(FacesContext context) {
        if (OMUtils.isDeltaViewState(context)) {
            return this.saveDeltaViewState(context);
        }
        return context.getViewRoot().processSaveState(context);
    }

    private Object saveDeltaViewState(FacesContext context) {
        Map<String, ComponentViewState> origViewStateMap = OMUtils.getOrigViewStateMaps(context).get(context.getViewRoot().getViewId());
        HashMap<String, Object> resultAttrStateMap = new HashMap<String, Object>();
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator((UIComponent)context.getViewRoot(), true);
        while (it.hasNext()) {
            Object newCompAttrState;
            UIComponent comp = it.next();
            if (comp.isTransient()) continue;
            String clientId = comp.getClientId(context);
            ComponentViewState origCompViewState = origViewStateMap.get(clientId);
            if (origCompViewState == null || !comp.getClass().getName().equals(origCompViewState.getCompStruct().getClassName())) {
                newCompAttrState = comp.saveState(context);
                resultAttrStateMap.put(comp.getClientId(context), newCompAttrState);
                continue;
            }
            newCompAttrState = comp.saveState(context);
            Object origCompAttrState = origCompViewState.getCompState();
            if (OMUtils.isObjectEquals(origCompAttrState, newCompAttrState)) continue;
            resultAttrStateMap.put(comp.getClientId(context), new DeltaState(origCompAttrState, newCompAttrState));
        }
        return resultAttrStateMap.isEmpty() ? null : resultAttrStateMap;
    }

    private void restoreDeltaViewState(FacesContext context, UIViewRoot root, Map attrStateMap, String viewId) {
        Map<String, ComponentViewState> origViewStateMap = OMUtils.getOrigViewStateMaps(context).get(viewId);
        Iterator<UIComponent> it = FacesUtils.createFacetsAndChildrenIterator((UIComponent)root, true);
        while (it.hasNext()) {
            UIComponent comp = it.next();
            if (comp.isTransient()) continue;
            String clientId = comp.getClientId(context);
            if (attrStateMap != null && attrStateMap.containsKey(clientId)) {
                Object compAttrState = attrStateMap.get(clientId);
                if (compAttrState instanceof DeltaState) {
                    ComponentViewState origCompViewState = origViewStateMap.get(clientId);
                    Object origCompAttrState = origCompViewState.getCompState();
                    Object newCompAttrState = ((DeltaState)compAttrState).combineOrigState(origCompAttrState);
                    comp.restoreState(context, newCompAttrState);
                } else {
                    comp.restoreState(context, compAttrState);
                }
            } else {
                ComponentViewState origCompViewState = origViewStateMap.get(clientId);
                if (origCompViewState != null) {
                    comp.restoreState(context, origCompViewState.getCompState());
                }
            }
            if (!(comp instanceof UIViewRoot)) continue;
            context.setViewRoot((UIViewRoot)comp);
        }
    }

    protected Object getAttachedStateToSave(FacesContext context) {
        Map stateMap = (Map)context.getExternalContext().getRequestMap().get(ATTACHED_STATE_PARAM);
        if (stateMap == null) {
            return null;
        }
        Object[] stateArray = new Object[stateMap.size() * 2];
        Iterator it = stateMap.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            stateArray[i * 2] = e.getKey();
            stateArray[i * 2 + 1] = UIComponentBase.saveAttachedState((FacesContext)context, e.getValue());
            ++i;
        }
        return stateArray;
    }

    protected void setAttachedStateToRestore(FacesContext context, Object stateObj) {
        Object[] stateArray = (Object[])stateObj;
        HashMap<Object, Object> stateMap = new HashMap<Object, Object>(stateArray.length / 2);
        for (int i = 0; i < stateArray.length; i += 2) {
            Object key = stateArray[i];
            Object value = UIComponentBase.restoreAttachedState((FacesContext)context, (Object)stateArray[i + 1]);
            stateMap.put(key, value);
        }
        context.getExternalContext().getRequestMap().put(ATTACHED_STATE_PARAM, stateMap);
    }

    public static void saveAttachedState(FacesContext context, Object key, Object value) {
        Map requestMap = context.getExternalContext().getRequestMap();
        HashMap<Object, Object> stateMap = (HashMap<Object, Object>)requestMap.get(ATTACHED_STATE_PARAM);
        if (stateMap == null) {
            stateMap = new HashMap<Object, Object>();
            requestMap.put(ATTACHED_STATE_PARAM, stateMap);
        }
        stateMap.put(key, value);
    }

    public static Object restoreAttachedState(FacesContext context, Object key) {
        Map requestMap = context.getExternalContext().getRequestMap();
        Map stateMap = (Map)requestMap.get(ATTACHED_STATE_PARAM);
        if (stateMap != null) {
            return stateMap.get(key);
        }
        return null;
    }
}

