/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.application.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.jsp.jstl.core.Config;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.UpdaterStub;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.render.ajax.AjaxHtmlResponseWriter;
import org.operamasks.faces.render.ajax.AjaxResponseWriter;
import org.operamasks.util.Utils;

public class ViewHandlerImpl
extends ViewHandler {
    private static final String FACES_MAPPING = "org.operamasks.faces.FACES_MAPPING";
    private ApplicationAssociate associate;
    private String defaultSuffix;
    private static final String AJAX_RESPONSE_TYPE = "text/javascript";

    private ApplicationAssociate getAssociate(FacesContext context) {
        if (this.associate == null) {
            this.associate = ApplicationAssociate.getInstance(context);
        }
        return this.associate;
    }

    public Locale calculateLocale(FacesContext context) {
        Locale result = null;
        Iterator requestLocales = context.getExternalContext().getRequestLocales();
        while (result == null && requestLocales.hasNext()) {
            Locale pref = (Locale)requestLocales.next();
            result = this.getPreferredLocale(context, pref);
        }
        if (result == null) {
            result = context.getApplication().getDefaultLocale();
        }
        if (result == null) {
            result = Locale.getDefault();
        }
        return result;
    }

    private Locale getPreferredLocale(FacesContext context, Locale pref) {
        Locale result = null;
        Iterator it = context.getApplication().getSupportedLocales();
        while (it.hasNext()) {
            Locale locale = (Locale)it.next();
            if (pref.equals(locale)) {
                result = locale;
                break;
            }
            if (!pref.getLanguage().equals(locale.getLanguage()) || !locale.getCountry().equals("")) continue;
            result = locale;
        }
        return result;
    }

    public String calculateCharacterEncoding(FacesContext context) {
        String encoding = super.calculateCharacterEncoding(context);
        if (encoding != null && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding;
    }

    public String calculateRenderKitId(FacesContext context) {
        Map paramMap = context.getExternalContext().getRequestParameterMap();
        String renderKitId = (String)paramMap.get("javax.faces.RenderKitId");
        if (renderKitId == null) {
            renderKitId = context.getApplication().getDefaultRenderKitId();
        }
        if (renderKitId == null) {
            renderKitId = "HTML_BASIC";
        }
        return renderKitId;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        Locale locale = null;
        String renderKitId = null;
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot != null) {
            locale = viewRoot.getLocale();
            renderKitId = viewRoot.getRenderKitId();
        }
        ViewHandler outerViewHandler = context.getApplication().getViewHandler();
        if (locale == null) {
            locale = outerViewHandler.calculateLocale(context);
        }
        if (renderKitId == null) {
            renderKitId = outerViewHandler.calculateRenderKitId(context);
        }
        viewRoot = new UIViewRoot();
        viewRoot.setId("___viewroot___");
        viewRoot.setViewId(viewId);
        viewRoot.setLocale(locale);
        viewRoot.setRenderKitId(renderKitId);
        return viewRoot;
    }

    public String getActionURL(FacesContext context, String viewId) {
        if (viewId == null || !viewId.startsWith("/")) {
            throw new IllegalArgumentException("Invalid view ID: " + viewId);
        }
        String contextPath = context.getExternalContext().getRequestContextPath();
        String mapping = this.getFacesMapping(context);
        if (mapping == null) {
            return contextPath.concat(viewId);
        }
        if (ViewHandlerImpl.isPrefixMapping(mapping)) {
            return contextPath.concat(mapping).concat(viewId);
        }
        return contextPath.concat(this.replaceSuffix(viewId, mapping));
    }

    public String getResourceURL(FacesContext context, String path) {
        ExternalContext ectx = context.getExternalContext();
        String contextPath = ectx.getRequestContextPath();
        if (path.startsWith("/")) {
            path = contextPath.concat(path);
        } else if (!Utils.isAbsoluteURL((String)path)) {
            String prefix = (String)ectx.getRequestMap().get("javax.servlet.include.servlet_path");
            if (prefix == null) {
                prefix = ectx.getRequestServletPath();
            }
            if (prefix != null) {
                prefix = prefix.substring(0, prefix.lastIndexOf(47) + 1);
                path = contextPath.concat(prefix).concat(path);
            }
        }
        return path;
    }

    private String getFacesMapping(FacesContext context) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String mapping = (String)requestMap.get(FACES_MAPPING);
        if (mapping == null) {
            mapping = this.getAssociate(context).getFacesMapping(context);
            requestMap.put(FACES_MAPPING, mapping);
        }
        return mapping;
    }

    private static boolean isPrefixMapping(String mapping) {
        return mapping.charAt(0) == '/';
    }

    private String replaceSuffix(String viewId, String suffix) {
        int period = viewId.lastIndexOf(46);
        if (period == -1) {
            return viewId.concat(suffix);
        }
        if (!viewId.endsWith(suffix)) {
            return viewId.substring(0, period).concat(suffix);
        }
        return viewId;
    }

    private String getDefaultSuffix(FacesContext context) {
        if (this.defaultSuffix == null) {
            this.defaultSuffix = context.getExternalContext().getInitParameter("javax.faces.DEFAULT_SUFFIX");
            if (this.defaultSuffix == null) {
                this.defaultSuffix = ".jsp";
            }
        }
        return this.defaultSuffix;
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        ExternalContext extCtx = context.getExternalContext();
        String mapping = this.getFacesMapping(context);
        if (mapping != null) {
            if (!ViewHandlerImpl.isPrefixMapping(mapping)) {
                viewId = this.replaceSuffix(viewId, this.getDefaultSuffix(context));
            } else if (mapping.equals(viewId)) {
                try {
                    context.responseComplete();
                    extCtx.redirect(extCtx.getRequestContextPath());
                    return null;
                }
                catch (IOException ex) {
                    throw new FacesException((Throwable)ex);
                }
            }
        }
        StateManager stateManager = context.getApplication().getStateManager();
        ViewHandler outerViewHandler = context.getApplication().getViewHandler();
        String renderKitId = outerViewHandler.calculateRenderKitId(context);
        return stateManager.restoreView(context, viewId, renderKitId);
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        if (!viewToRender.isRendered()) {
            return;
        }
        String viewId = viewToRender.getViewId();
        String mapping = this.getFacesMapping(context);
        if (mapping != null) {
            if (!ViewHandlerImpl.isPrefixMapping(mapping)) {
                viewId = this.replaceSuffix(viewId, this.getDefaultSuffix(context));
            } else if (mapping.equals(viewId)) {
                HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
                response.sendError(404);
                return;
            }
        }
        viewToRender.setViewId(viewId);
        ExternalContext extCtx = context.getExternalContext();
        if (extCtx.getRequest() instanceof ServletRequest) {
            Config.set((ServletRequest)((ServletRequest)extCtx.getRequest()), (String)"javax.servlet.jsp.jstl.fmt.locale", (Object)viewToRender.getLocale());
        }
        try {
            HttpServletResponse response = (HttpServletResponse)extCtx.getResponse();
            String encoding = extCtx.getRequestCharacterEncoding();
            if (encoding != null && Charset.isSupported(encoding)) {
                response.setCharacterEncoding(encoding);
            }
            response.setHeader("Cache-Control", "no-cache");
            response.setHeader("Pragma", "no-cache");
        }
        catch (Throwable ex) {
            // empty catch block
        }
        this.associate.responseRendered();
        if (OMUtils.isAjaxResponse(context)) {
            this.renderAjaxView(context, viewToRender);
        } else {
            extCtx.dispatch(viewId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAjaxView(FacesContext context, UIViewRoot viewToRender) throws IOException, FacesException {
        ExternalContext extCtx = context.getExternalContext();
        HttpServletResponse response = (HttpServletResponse)extCtx.getResponse();
        response.setLocale(context.getViewRoot().getLocale());
        try {
            extCtx.setResponse((Object)new ResponseWrapper(response));
            extCtx.dispatch(viewToRender.getViewId());
        }
        finally {
            extCtx.setResponse((Object)response);
        }
        String contentType = response.getContentType();
        String encoding = response.getCharacterEncoding();
        response.setContentType(AJAX_RESPONSE_TYPE);
        RenderKit renderKit = FacesUtils.getRenderKit(context, "AJAX");
        ResponseWriter writer = renderKit.createResponseWriter((Writer)response.getWriter(), contentType, encoding);
        context.setResponseWriter(writer);
        writer.startDocument();
        String renderId = OMUtils.getRequestRenderId(context);
        boolean rendered = false;
        if (renderId != null) {
            rendered = this.renderPartialView(context, renderId, (UIComponent)viewToRender);
        }
        if (!rendered) {
            viewToRender.encodeAll(context);
        }
        writer.endDocument();
    }

    private boolean renderPartialView(FacesContext context, String renderId, UIComponent component) throws IOException, FacesException {
        boolean rendered = false;
        for (UIComponent child : component.getChildren()) {
            if (child instanceof UpdaterStub) {
                String id = ((UpdaterStub)child).getRenderId();
                if (id == null || !id.equals(renderId)) continue;
                child.encodeAll(context);
                rendered = true;
                continue;
            }
            rendered |= this.renderPartialView(context, renderId, child);
        }
        return rendered;
    }

    public void writeState(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer instanceof AjaxResponseWriter) {
            ((AjaxResponseWriter)writer).setViewStateChanged();
        } else if (writer instanceof AjaxHtmlResponseWriter) {
            ((AjaxHtmlResponseWriter)writer).setViewStateChanged();
        } else {
            StateManager stateManager = context.getApplication().getStateManager();
            Object state = stateManager.saveView(context);
            stateManager.writeState(context, state);
        }
    }

    private static class NullOutputStream
    extends ServletOutputStream {
        private NullOutputStream() {
        }

        public void write(int c) {
        }

        public void write(char[] cbuf, int off, int len) {
        }

        public void write(String s, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private static class NullWriter
    extends Writer {
        private NullWriter() {
        }

        public void write(int c) {
        }

        public void write(char[] cbuf, int off, int len) {
        }

        public void write(String s, int off, int len) {
        }

        public void flush() {
        }

        public void close() {
        }
    }

    private static class ResponseWrapper
    extends HttpServletResponseWrapper {
        private boolean useWriter;
        private boolean useStream;

        public ResponseWrapper(HttpServletResponse wrapped) {
            super(wrapped);
        }

        public PrintWriter getWriter() {
            if (this.useStream) {
                throw new IllegalStateException();
            }
            this.useWriter = true;
            return new PrintWriter(new NullWriter());
        }

        public ServletOutputStream getOutputStream() {
            if (this.useWriter) {
                throw new IllegalStateException();
            }
            this.useStream = true;
            return new NullOutputStream();
        }

        public void setContentType(String x) {
        }

        public void setContentLength(int x) {
        }

        public void setLocale(Locale x) {
        }

        public void flushBuffer() {
        }
    }
}

