/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.factories;

import java.lang.reflect.Method;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import org.operamasks.faces.annotation.Convert;
import org.operamasks.faces.annotation.Format;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.application.TargetCreator;
import org.operamasks.faces.application.impl.DefaultTargetCreator;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.ConverterAdapter;
import org.operamasks.faces.binding.impl.MethodConvertAction;
import org.operamasks.faces.binding.impl.MethodFormatAction;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdaptingConverterFactory
implements ConverterFactory {
    private TargetCreator creator;
    private Method convertMethod;
    private Method formatMethod;

    public AdaptingConverterFactory(TargetCreator creator) {
        this.creator = creator;
    }

    public AdaptingConverterFactory(Class<?> converterClass) {
        this.creator = new DefaultTargetCreator(converterClass, Class.class);
    }

    @Override
    public Converter createConverter(Class type) {
        Object target = this.creator.createTarget(type);
        if (target instanceof Converter) {
            return (Converter)target;
        }
        return this.createConverterAdapter(target);
    }

    private Converter createConverterAdapter(Object target) {
        if (this.convertMethod == null && this.formatMethod == null) {
            this.initialize(this.creator.getTargetClass());
        }
        ModelBean targetBean = ModelBean.wrap(target);
        ConverterAdapter adapter = new ConverterAdapter();
        if (this.convertMethod != null) {
            adapter.setConvertAction(new MethodConvertAction(targetBean, this.convertMethod));
        }
        if (this.formatMethod != null) {
            adapter.setFormatAction(new MethodFormatAction(targetBean, this.formatMethod));
        }
        return adapter;
    }

    private void initialize(Class targetClass) {
        for (Method method : targetClass.getDeclaredMethods()) {
            if (method.isAnnotationPresent(Convert.class)) {
                if (!this.checkConvertMethod(method)) {
                    throw new FacesException(Resources._T("MVB_INVALID_CONVERT_METHOD", method.getName()));
                }
                this.convertMethod = method;
                continue;
            }
            if (!method.isAnnotationPresent(Format.class)) continue;
            if (!this.checkFormatMethod(method)) {
                throw new FacesException(Resources._T("MVB_INVALID_FORMAT_METHOD", method.getName()));
            }
            this.formatMethod = method;
        }
        if (this.convertMethod == null && this.formatMethod == null) {
            throw new FacesException(Resources._T("MVB_CONVERT_OR_FORMAT_METHOD_NOT_FOUND", targetClass.getName()));
        }
    }

    private boolean checkConvertMethod(Method method) {
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1) {
            return params[0] == String.class;
        }
        if (params.length == 3) {
            return params[0] != FacesContext.class && params[1] != UIComponent.class && params[2] != String.class;
        }
        return false;
    }

    private boolean checkFormatMethod(Method method) {
        if (method.getReturnType() != String.class) {
            return false;
        }
        Class<?>[] params = method.getParameterTypes();
        if (params.length == 1) {
            return true;
        }
        if (params.length == 3) {
            return params[0] == FacesContext.class && params[1] == UIComponent.class;
        }
        return false;
    }
}

