/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.factories;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.convert.Converter;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.application.ConverterFactory;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.ConvertAction;
import org.operamasks.faces.binding.impl.ConverterAdapter;
import org.operamasks.faces.binding.impl.FormatAction;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;
import org.operamasks.util.BeanProperty;
import org.operamasks.util.BeanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizingConverterFactory
implements ConverterFactory {
    private final ConverterFactory delegate;
    private final Map<String, Object> properties;
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.binding");

    public CustomizingConverterFactory(ConverterFactory delegate) {
        this.delegate = delegate;
        this.properties = new HashMap<String, Object>();
    }

    public void setConverterProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    @Override
    public Converter createConverter(Class targetClass) {
        return this.createConverter(null, targetClass);
    }

    public Converter createConverter(ModelBean scope, Class targetClass) {
        Converter converter = this.delegate.createConverter(targetClass);
        if (converter != null && this.properties.size() > 0) {
            this.setConverterProperties(scope, converter);
        }
        return converter;
    }

    protected void setConverterProperties(ModelBean scope, Converter converter) {
        ModelBean bean = this.getConverterBean(converter);
        Class<?> tclass = bean.getTargetClass();
        for (String name : this.properties.keySet()) {
            try {
                BeanProperty p = BeanUtils.getProperty(tclass, (String)name);
                if (p == null) {
                    logger.warning(Resources._T("MVB_CONVERTER_PROPERTY_NOT_FOUND", name, tclass.getName()));
                    continue;
                }
                if (p.isReadOnly()) {
                    logger.warning(Resources._T("MVB_CONVERTER_PROPERTY_READONLY", name, tclass.getName()));
                    continue;
                }
                Object value = this.properties.get(name);
                if (value instanceof String) {
                    value = this.convertStringValue(scope, (String)value, p.getType());
                } else if (!p.getType().isInstance(value)) {
                    value = TypeCoercion.coerce((Object)value, (Class)p.getType());
                }
                if (value == null) continue;
                bean.invoke(p.getWriteMethod(), value);
            }
            catch (Exception ex) {
                throw new FacesException(Resources._T("MVB_SET_CONVERTER_PROPERTY_FAILED", name, tclass.getName()), (Throwable)ex);
            }
        }
    }

    private Object convertStringValue(ModelBean scope, String value, Class<?> type) {
        if (value.length() == 0) {
            return null;
        }
        if (scope != null) {
            return scope.evaluateExpression(value, type);
        }
        return FacesUtils.evaluateExpressionGet(value, type);
    }

    private ModelBean getConverterBean(Converter converter) {
        if (converter instanceof ConverterAdapter) {
            ConverterAdapter adapter = (ConverterAdapter)converter;
            ConvertAction convert = adapter.getConvertAction();
            if (convert != null) {
                return convert.getTarget();
            }
            FormatAction format = adapter.getFormatAction();
            if (format != null) {
                return format.getTarget();
            }
            throw new IllegalArgumentException();
        }
        return ModelBean.wrap(converter);
    }
}

