/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodInfo;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.AbstractMethodAdapter;
import org.operamasks.faces.internal.stub.event.AjaxActionEventStub;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodAdapter
extends AbstractMethodAdapter {
    private static final long serialVersionUID = -5995645728075566775L;
    private transient ModelBean bean;
    private transient Method method;

    public ActionMethodAdapter(ModelBean bean, Method method) {
        this.bean = bean;
        this.method = method;
    }

    public MethodInfo getMethodInfo(ELContext context) {
        return new MethodInfo(this.method.getName(), this.method.getReturnType(), (Class[])this.method.getParameterTypes());
    }

    public Object invoke(ELContext context, Object[] params) {
        Object[] targetParams = params;
        if (params != null && params.length == 1 && params[0] instanceof AjaxActionEventStub) {
            Method m = this.fetchAjaxActionMethod(params[0].getClass());
            if (m != null && m.getParameterTypes().length == 1) {
                this.method = m;
                this.method.setAccessible(true);
            } else {
                targetParams = new Object[]{};
            }
        }
        try {
            return this.bean.invokeAction(this.method, targetParams);
        }
        catch (Exception ex) {
            throw new ELException((Throwable)ex);
        }
    }

    private Method fetchAjaxActionMethod(Class<?> c) {
        Method result = null;
        Set<Method> methods = this.getAllMethods(this.bean);
        result = this.fetchMethod(methods, this.method.getName(), c);
        if (result == null) {
            result = this.fetchMethod(methods, this.method.getName(), "org.operamasks.faces.event.ajax.AjaxActionEvent");
        }
        if (result == null) {
            result = this.fetchMethod(methods, this.method.getName());
        }
        return result;
    }

    private Method fetchMethod(Set<Method> sourceMethods, String targetName, Class<?> targetParaClass) {
        for (Method m : sourceMethods) {
            if (!targetName.equals(m.getName())) continue;
            Class<?>[] parameterTypes = m.getParameterTypes();
            if (targetParaClass == null && parameterTypes.length == 0) {
                return m;
            }
            if (parameterTypes.length != 1 || !parameterTypes[0].equals(targetParaClass)) continue;
            return m;
        }
        return null;
    }

    private Method fetchMethod(Set<Method> sourceMethods, String targetName, String targetParaClassName) {
        for (Method m : sourceMethods) {
            Class<?>[] parameterTypes;
            if (!targetName.equals(m.getName()) || (parameterTypes = m.getParameterTypes()).length != 1 || !parameterTypes[0].getName().equals(targetParaClassName)) continue;
            return m;
        }
        return null;
    }

    private Method fetchMethod(Set<Method> sourceMethods, String targetName) {
        for (Method m : sourceMethods) {
            if (!targetName.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    private Set<Method> getAllMethods(ModelBean bean) {
        HashSet<Method> allMethods = new HashSet<Method>();
        for (Class<?> c = bean.getTargetClass(); c != null && c != Object.class; c = c.getSuperclass()) {
            for (Method m : c.getDeclaredMethods()) {
                allMethods.add(m);
            }
        }
        return allMethods;
    }
}

