/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import org.operamasks.faces.annotation.Init;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.Injector;
import org.operamasks.faces.binding.impl.PropertyBinding;
import org.operamasks.faces.binding.impl.processor.bean.AnnotationProcessor;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingBuilder {
    private final List<Binding> bindings = new ArrayList<Binding>();
    private final List<Injector> injectors = new ArrayList<Injector>();
    private static final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.binding");
    private static final String DEFAULT_PROCESSOR_CONFIG_FILE = "org/operamasks/faces/binding/impl/processor/bean/bean_processors.cfg";
    private static final String PROCESSOR_CONFIG_FILE = "META-INF/bean_processors.cfg";
    private static List<AnnotationProcessor<Annotation>> processors = new ArrayList<AnnotationProcessor<Annotation>>();

    private static ClassLoader getClassLoader() {
        ApplicationAssociate associate = ApplicationAssociate.getInstance();
        if (associate != null) {
            return associate.getClassLoader();
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseProcessor(InputStream configStream, ClassLoader cl) {
        BufferedReader reader = null;
        try {
            String name;
            reader = new BufferedReader(new InputStreamReader(configStream));
            while ((name = reader.readLine()) != null) {
                if ((name = name.trim()).length() == 0) continue;
                Class<?> clazz = cl.loadClass(name);
                AnnotationProcessor processor = (AnnotationProcessor)clazz.newInstance();
                processors.add(processor);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "read config file fails: " + e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.WARNING, "load class fails: " + e);
        }
        catch (InstantiationException e) {
            logger.log(Level.WARNING, "instantiation fails: " + e);
        }
        catch (IllegalAccessException e) {
            logger.log(Level.WARNING, "illegal access: " + e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "close stream fails: " + e);
                }
            }
        }
    }

    public List<Binding> getBindings() {
        Collections.sort(this.bindings, new Comparator<Binding>(){

            @Override
            public int compare(Binding x, Binding y) {
                return x.getOrder() - y.getOrder();
            }
        });
        return this.bindings;
    }

    public List<Injector> getInjectors() {
        Collections.sort(this.injectors, new Comparator<Injector>(){

            @Override
            public int compare(Injector x, Injector y) {
                return x.getOrder() - y.getOrder();
            }
        });
        return this.injectors;
    }

    public void addBinding(Binding binding) {
        this.bindings.add(binding);
        if (binding instanceof Injector) {
            this.injectors.add((Injector)((Object)binding));
        }
    }

    public void build(Class<?> targetClass) {
        Class<?> superclass;
        this.scan(targetClass);
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> c : interfaces) {
                this.build(c);
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null) {
            this.build(superclass);
        }
    }

    private void scan(Class<?> targetClass) {
        ArrayList<AccessibleObject> initMethods = new ArrayList<AccessibleObject>();
        for (Field field : targetClass.getDeclaredFields()) {
            for (AnnotationProcessor<Annotation> p : processors) {
                if (p.process(this, targetClass, field)) break;
            }
        }
        for (AccessibleObject accessibleObject : targetClass.getDeclaredMethods()) {
            if (accessibleObject.isAnnotationPresent(Init.class)) {
                initMethods.add(accessibleObject);
                continue;
            }
            for (AnnotationProcessor<Annotation> p : processors) {
                if (p.process(this, targetClass, accessibleObject)) break;
            }
        }
        if (initMethods.size() > 0) {
            for (Method method : initMethods) {
                this.addInitMethod(method);
            }
        }
    }

    private void addInitMethod(Method method) {
        if (method.getParameterTypes().length != 0) {
            return;
        }
        String name = method.getAnnotation(Init.class).value();
        if (name == null || name.length() == 0) {
            name = method.getName();
            if (name.startsWith("init")) {
                if (name.length() <= 4) {
                    throw new FacesException(Resources._T("IOVC_INIT_CALLBACK_EMPTYNAME"));
                }
                name = name.substring(4);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            } else {
                return;
            }
        }
        Class<?> type = method.getReturnType();
        for (Binding b : this.bindings) {
            PropertyBinding pb;
            Field field;
            if (!(b instanceof PropertyBinding) || (field = (pb = (PropertyBinding)b).getField()) == null || !name.equals(field.getName()) || type != Void.TYPE && type != field.getType() || field.getDeclaringClass() != method.getDeclaringClass()) continue;
            pb.setInitMethod(method);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream configStream = null;
        try {
            ClassLoader cl = BindingBuilder.getClassLoader();
            ArrayList<URL> configUrls = new ArrayList<URL>();
            URL default_config_url = cl.getResource(DEFAULT_PROCESSOR_CONFIG_FILE);
            configUrls.add(default_config_url);
            Enumeration<URL> urls = cl.getResources(PROCESSOR_CONFIG_FILE);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                configUrls.add(url);
            }
            for (URL url : configUrls) {
                configStream = url.openStream();
                BindingBuilder.parseProcessor(configStream, cl);
                if (configStream == null) continue;
                configStream.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "load config file fails: " + e);
        }
        finally {
            if (configStream != null) {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "close stream fails: " + e);
                }
            }
        }
    }
}

