/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.faces.component.UIData;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.impl.AbstractValueAdapter;
import org.operamasks.faces.binding.impl.DataItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeDataItemAdapter
extends AbstractValueAdapter {
    private static final long serialVersionUID = 933923974767927902L;
    private transient UIData data;
    private List<DataItem> bindings = new ArrayList<DataItem>();
    private transient PhaseId phaseId;

    public CompositeDataItemAdapter() {
    }

    public CompositeDataItemAdapter(UIData data) {
        this();
        this.data = data;
    }

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public void addDataItem(DataItem dataItem) {
        this.bindings.add(dataItem);
    }

    public Object getValue(ELContext context) {
        Object target;
        if (this.data.isRowAvailable() && (target = this.data.getRowData()) != null) {
            ModelBean bean = ModelBean.wrap(target);
            for (DataItem item : this.bindings) {
                Object result = item.getValue(bean);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void setValue(ELContext context, Object value) {
        Object target;
        if (this.data.isRowAvailable() && (target = this.data.getRowData()) != null) {
            ModelBean bean = ModelBean.wrap(target);
            for (DataItem item : this.bindings) {
                if (item.isReadOnly()) continue;
                item.setValue(bean, value);
            }
        }
    }

    public boolean isReadOnly(ELContext context) {
        return false;
    }

    public Class<?> getType(ELContext context) {
        return this.getExpectedType();
    }

    public Class<?> getExpectedType() {
        for (DataItem item : this.bindings) {
            Class<?> type = item.getType();
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

