/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.event.PhaseId;
import org.operamasks.faces.binding.impl.AbstractValueAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CompositeValueAdapter
extends AbstractValueAdapter {
    private static final long serialVersionUID = 4618930829718737035L;
    private List<ValueExpression> bindings = new ArrayList<ValueExpression>();
    private transient PhaseId phaseId;

    public PhaseId getPhaseId() {
        return this.phaseId;
    }

    public void setPhaseId(PhaseId phaseId) {
        this.phaseId = phaseId;
    }

    public void addValueBinding(ValueExpression binding) {
        this.bindings.add(binding);
    }

    public Object getValue(ELContext context) {
        for (ValueExpression b : this.bindings) {
            Object result = b.getValue(context);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void setValue(ELContext context, Object value) {
        boolean readonly = true;
        for (ValueExpression b : this.bindings) {
            if (b.isReadOnly(context)) continue;
            b.setValue(context, value);
            readonly = false;
        }
        if (readonly) {
            throw new PropertyNotWritableException();
        }
    }

    public boolean isReadOnly(ELContext context) {
        return false;
    }

    public Class<?> getType(ELContext context) {
        for (ValueExpression b : this.bindings) {
            Class type = b.getType(context);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public Class<?> getExpectedType() {
        for (ValueExpression b : this.bindings) {
            Class type = b.getExpectedType();
            if (type == null) continue;
            return type;
        }
        return null;
    }
}

