/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.el.ELContext;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.ELEngine;
import org.operamasks.el.eval.MethodResolvable;
import org.operamasks.el.eval.TypeCoercion;
import org.operamasks.faces.application.impl.ResourceBundleWrapper;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.binding.impl.Injector;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELLocalStringBinding
extends Binding
implements Injector {
    private Closure closure;
    private String key;
    private Class<?> type;

    public ELLocalStringBinding(Closure closure, String key, Class<?> type) {
        super(null);
        this.closure = closure;
        this.key = key;
        this.type = type;
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        this.inject(ctx, mbc.getModelBean());
    }

    @Override
    public void inject(FacesContext ctx, ModelBean bean) {
        Object value;
        if (this.closure != null && (value = this.getValue((ELiteBean)bean)) != null) {
            this.closure.setValue(ctx.getELContext(), value);
        }
    }

    @Override
    public void outject(FacesContext context, ModelBean bean) {
    }

    public Object getValue(ELiteBean bean) {
        if (this.type.isArray()) {
            return this.loadArray(bean);
        }
        if (this.type == List.class) {
            return this.loadList(bean);
        }
        if (this.type == Map.class) {
            return this.loadMap(bean);
        }
        if (this.type == ResourceBundle.class) {
            return this.loadResourceBundle(bean);
        }
        return this.loadSingle(bean);
    }

    private Object loadSingle(ELiteBean bean) {
        String text = bean.getLocalString(this.key);
        return text == null ? null : TypeCoercion.coerce((Object)text, this.type);
    }

    private Object loadArray(ELiteBean bean) {
        String text;
        Class<?> elemType = this.type.getComponentType();
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while ((text = bean.getLocalString(this.key + "[" + i + "]")) != null) {
            list.add(TypeCoercion.coerce((Object)text, elemType));
            ++i;
        }
        Object[] result = (Object[])Array.newInstance(elemType, list.size());
        list.toArray(result);
        return result;
    }

    private Object loadList(ELiteBean bean) {
        String text;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while ((text = bean.getLocalString(this.key + "[" + i + "]")) != null) {
            list.add(text);
            ++i;
        }
        return list;
    }

    private Object loadMap(ELiteBean bean) {
        return new LocalStringMap(bean.getPath());
    }

    private Object loadResourceBundle(ELiteBean bean) {
        ResourceBundle bundle = bean.getLocalStringBundle();
        if (bundle != null) {
            bundle = new ResourceBundleWrapper(bundle);
        }
        return bundle;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LocalStringMap
    extends AbstractMap<String, String>
    implements MethodResolvable,
    Serializable {
        private final String path;
        private Map<String, String> stringMap = null;

        LocalStringMap(String path) {
            this.path = path;
        }

        private String getString(String key) {
            return ELiteBean.getLocalString(this.path, key);
        }

        @Override
        public boolean containsKey(Object key) {
            return key != null && this.getString(key.toString()) != null;
        }

        @Override
        public String get(Object key) {
            return this.getString(key.toString());
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.stringMap().entrySet();
        }

        @Override
        public Set<String> keySet() {
            return this.stringMap().keySet();
        }

        @Override
        public Collection<String> values() {
            return this.stringMap().values();
        }

        private Map<String, String> stringMap() {
            if (this.stringMap != null) {
                return this.stringMap;
            }
            ResourceBundle bundle = ELiteBean.getLocalStringBundle(this.path);
            if (bundle == null) {
                this.stringMap = Collections.emptyMap();
                return this.stringMap;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                map.put(key, bundle.getString(key));
            }
            this.stringMap = map;
            return this.stringMap;
        }

        public String format(String key, Object ... args) {
            String msgtext = this.getString(key);
            if (msgtext == null || args == null || args.length == 0) {
                return msgtext;
            }
            return MessageFormat.format(msgtext, args);
        }

        public MethodInfo getMethodInfo(ELContext ctx, String name) throws MethodNotFoundException {
            if (this.getString(name) == null) {
                throw new MethodNotFoundException(Resources._T("MVB_LOCAL_STRING_KEY_NOT_FOUND", name));
            }
            return new MethodInfo(name, String.class, new Class[0]);
        }

        public Object invoke(ELContext ctx, String name, Closure[] args) throws MethodNotFoundException {
            String msgtext = this.getString(name);
            if (msgtext == null) {
                throw new MethodNotFoundException(Resources._T("MVB_LOCAL_STRING_KEY_NOT_FOUND", name));
            }
            if (args.length != 0) {
                msgtext = MessageFormat.format(msgtext, ELEngine.getArgValues((ELContext)ctx, (Closure[])args));
            }
            return msgtext;
        }
    }
}

