/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import elite.lang.Closure;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.context.FacesContext;
import org.operamasks.el.eval.ELContextImpl;
import org.operamasks.el.eval.ELProgram;
import org.operamasks.el.eval.VariableMapperImpl;
import org.operamasks.el.parser.Parser;
import org.operamasks.el.parser.ResourceResolver;
import org.operamasks.faces.application.ApplicationAssociate;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.util.SimpleCache;

final class ELiteBeanCache {
    private static final String SCRIPT_KEY = ELiteBeanCache.class.getName() + ":";
    private SimpleCache<URL, CacheEntry> cache = new SimpleCache(200);

    public static ELiteBeanCache getInstance() {
        return ApplicationAssociate.getInstance().getSingleton(ELiteBeanCache.class);
    }

    private ELiteBeanCache() {
    }

    public ELiteBean get(FacesContext ctx, String path) {
        Map requestMap = ctx.getExternalContext().getRequestMap();
        ELiteBean bean = (ELiteBean)requestMap.get(SCRIPT_KEY + path);
        if (bean != null) {
            return bean;
        }
        try {
            ELProgram prog;
            URL url = ctx.getExternalContext().getResource(path);
            if (url == null) {
                return null;
            }
            CacheEntry entry = (CacheEntry)this.cache.get((Object)url);
            long lastmod = url.openConnection().getLastModified();
            if (entry != null && lastmod == entry.lastmod) {
                prog = entry.prog;
            } else {
                String script = this.readScript(url);
                prog = this.loadScript(script, path);
                this.cache.put((Object)url, (Object)new CacheEntry(prog, lastmod));
            }
            bean = this.runScript(ctx, prog, path);
            requestMap.put(SCRIPT_KEY + path, bean);
            return bean;
        }
        catch (IOException ex) {
            return null;
        }
    }

    private String readScript(URL url) {
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(url.openStream());
            StringBuilder buf = new StringBuilder();
            char[] cbuf = new char[8192];
            while ((len = reader.read(cbuf)) != -1) {
                buf.append(cbuf, 0, len);
            }
            ((Reader)reader).close();
            return buf.toString();
        }
        catch (IOException ex) {
            return null;
        }
    }

    private ELProgram loadScript(String script, String path) {
        Parser parser = new Parser(script);
        parser.setFileName(path);
        parser.setResourceResolver((ResourceResolver)new WebResourceResolver());
        return parser.parse();
    }

    private ELiteBean runScript(FacesContext ctx, ELProgram prog, String path) {
        ELContextImpl elctx = (ELContextImpl)ctx.getELContext();
        VariableMapper vm = elctx.getVariableMapper();
        DelegatingVariableMapper vmd = new DelegatingVariableMapper(vm);
        elctx.setVariableMapper((VariableMapper)vmd);
        prog.execute((ELContext)elctx, path, 1);
        elctx.setVariableMapper(vm);
        return ELiteBean.make((ELContext)elctx, path, vmd.getVariableMap());
    }

    private static class DelegatingVariableMapper
    extends VariableMapperImpl {
        private VariableMapper delegate;

        DelegatingVariableMapper(VariableMapper delegate) {
            this.delegate = delegate;
        }

        public ValueExpression resolveVariable(String name) {
            return this.delegate.resolveVariable(name);
        }

        public ValueExpression setVariable(String name, ValueExpression var) {
            if (var instanceof Closure) {
                ValueExpression oldvar = this.delegate.resolveVariable(name);
                if (oldvar == null) {
                    super.setVariable(name, var);
                    this.delegate.setVariable(name, var);
                } else {
                    super.setVariable(name, oldvar);
                }
                return oldvar;
            }
            return this.delegate.setVariable(name, var);
        }
    }

    private static class WebResourceResolver
    implements ResourceResolver {
        private WebResourceResolver() {
        }

        public Reader open(String path) throws IOException {
            FacesContext ctx = FacesContext.getCurrentInstance();
            InputStream stream = ctx.getExternalContext().getResourceAsStream(path);
            return new InputStreamReader(stream);
        }
    }

    private static class CacheEntry {
        ELProgram prog;
        long lastmod;

        CacheEntry(ELProgram prog, long lastmod) {
            this.prog = prog;
            this.lastmod = lastmod;
        }
    }
}

