/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import org.operamasks.faces.binding.ModelBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityManagerWrapper
implements EntityManager {
    private ModelBean bean;
    private EntityManager em;

    public EntityManagerWrapper(ModelBean bean, EntityManager em) {
        this.bean = bean;
        this.em = em;
    }

    public void persist(Object entity) {
        this.em.persist(entity);
    }

    public <T> T merge(T entity) {
        return (T)this.em.merge(entity);
    }

    public void remove(Object entity) {
        this.em.remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object key) {
        return (T)this.em.find(entityClass, key);
    }

    public <T> T getReference(Class<T> entityClass, Object key) {
        return (T)this.em.getReference(entityClass, key);
    }

    public void flush() {
        this.em.flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.em.setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.em.getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.em.lock(entity, lockMode);
    }

    public void refresh(Object entity) {
        this.em.refresh(entity);
    }

    public void clear() {
        this.em.clear();
    }

    public boolean contains(Object entity) {
        return this.em.contains(entity);
    }

    public Query createQuery(String ejbqlString) {
        if (ejbqlString.indexOf("#{") == -1) {
            return this.em.createQuery(ejbqlString);
        }
        StringBuilder ejbql = new StringBuilder(ejbqlString.length());
        ArrayList<String> params = new ArrayList<String>();
        int start = 0;
        int current = 0;
        while ((current = ejbqlString.indexOf("#{", current)) != -1) {
            int terminate = ejbqlString.indexOf(125, current);
            if (terminate == -1) {
                current += 2;
                continue;
            }
            ejbql.append(ejbqlString.substring(start, current));
            ejbql.append(":").append(EntityManagerWrapper.getParameterName(params.size()));
            params.add(ejbqlString.substring(current, terminate + 1));
            start = current = terminate + 1;
        }
        ejbql.append(ejbqlString.substring(start));
        Query q = this.em.createQuery(ejbql.toString());
        for (int i = 0; i < params.size(); ++i) {
            String name = EntityManagerWrapper.getParameterName(i);
            Object value = this.bean.evaluateExpression((String)params.get(i), Object.class);
            q.setParameter(name, value);
        }
        return q;
    }

    private static String getParameterName(int pos) {
        return "el" + pos;
    }

    public Query createNamedQuery(String name) {
        return this.em.createNamedQuery(name);
    }

    public Query createNativeQuery(String sqlString) {
        return this.em.createNativeQuery(sqlString);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return this.em.createNativeQuery(sqlString, resultClass);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return this.em.createNativeQuery(sqlString, resultSetMapping);
    }

    public void joinTransaction() {
        this.em.joinTransaction();
    }

    public Object getDelegate() {
        return this.em.getDelegate();
    }

    public void close() {
        this.em.close();
    }

    public boolean isOpen() {
        return this.em.isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.em.getTransaction();
    }
}

