/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ResourceBundle;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.developer.util.FacesUtils;

class LoggerWrapper
extends Logger {
    private ModelBean bean;
    private Logger logger;

    public LoggerWrapper(ModelBean bean, Logger logger, String name) {
        super(name, null);
        this.bean = bean;
        this.logger = logger;
    }

    public void log(LogRecord record) {
        if (this.logger.isLoggable(record.getLevel())) {
            String msg = record.getMessage();
            if (FacesUtils.isValueExpression(msg)) {
                msg = this.bean.evaluateExpression(msg, String.class);
                record.setMessage(msg);
            }
            this.logger.log(record);
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.logger.getResourceBundle();
    }

    public String getResourceBundleName() {
        return this.logger.getResourceBundleName();
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.logger.setFilter(newFilter);
    }

    public Filter getFilter() {
        return this.logger.getFilter();
    }

    public void setLevel(Level newLevel) throws SecurityException {
        this.logger.setLevel(newLevel);
    }

    public Level getLevel() {
        return this.logger.getLevel();
    }

    public boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }

    public String getName() {
        return this.logger.getName();
    }

    public void addHandler(Handler handler) throws SecurityException {
        this.logger.addHandler(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.logger.removeHandler(handler);
    }

    public Handler[] getHandlers() {
        return this.logger.getHandlers();
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.logger.setUseParentHandlers(useParentHandlers);
    }

    public boolean getUseParentHandlers() {
        return this.logger.getUseParentHandlers();
    }

    public Logger getParent() {
        return this.logger.getParent();
    }

    public void setParent(Logger parent) {
        this.logger.setParent(parent);
    }
}

