/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.operamasks.faces.annotation.Bind;
import org.operamasks.faces.application.ViewBuilder;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBinder;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.impl.Binding;
import org.operamasks.faces.binding.impl.BindingBuilder;
import org.operamasks.faces.binding.impl.Injector;
import org.operamasks.faces.binding.impl.LocalStringAttributeBinding;
import org.operamasks.faces.binding.impl.LocalStringBinding;
import org.operamasks.faces.binding.impl.PropertyValueAdapter;
import org.operamasks.faces.binding.impl.ValueBinding;
import org.operamasks.faces.internal.util.OMUtils;
import org.operamasks.faces.util.LoggerUtil;
import org.operamasks.resources.Resources;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ModelBinderImpl
extends ModelBinder {
    private Class<?> targetClass;
    private final List<Binding> bindings;
    private final List<Injector> injectors;
    private final Logger logger = LoggerUtil.getLogger("org.operamasks.faces.iovc");

    ModelBinderImpl(Class<?> targetClass) {
        BindingBuilder builder = new BindingBuilder();
        builder.build(targetClass);
        this.targetClass = targetClass;
        this.bindings = builder.getBindings();
        this.injectors = builder.getInjectors();
        this.addLocalStringAttributeBindings(targetClass);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    private void addLocalStringAttributeBindings(Class<?> targetClass) {
        Class<?> superclass;
        for (String key : this.getLocalStringKeys(targetClass)) {
            int dot = key.indexOf(46);
            if (dot == -1) continue;
            String id = key.substring(0, dot);
            String att = key.substring(dot + 1);
            if (!this.isValidAttribute(att)) continue;
            this.addLocalStringAttributeBinding(targetClass, key, id, att);
        }
        Class<?>[] interfaces = targetClass.getInterfaces();
        if (interfaces != null) {
            for (Class<?> c : interfaces) {
                this.addLocalStringAttributeBindings(c);
            }
        }
        if ((superclass = targetClass.getSuperclass()) != null && superclass != Object.class) {
            this.addLocalStringAttributeBindings(superclass);
        }
    }

    private void addLocalStringAttributeBinding(Class<?> targetClass, String key, String id, String att) {
        String viewId = null;
        for (Binding b : this.bindings) {
            if (!(b instanceof ValueBinding)) continue;
            ValueBinding vb = (ValueBinding)b;
            if (id.equals(vb.getId()) && att.equals(vb.getAttribute())) {
                if (vb.getLocalString() == null) {
                    LocalStringBinding ls = new LocalStringBinding(vb.getViewId());
                    ls.setName(vb.getName());
                    ls.setType(vb.getType());
                    ls.setDeclaringClass(targetClass);
                    ls.setKey(key);
                    vb.setLocalString(ls);
                }
                return;
            }
            if (!id.equals(vb.getId())) continue;
            viewId = vb.getViewId();
        }
        LocalStringAttributeBinding binding = new LocalStringAttributeBinding(viewId);
        binding.setDeclaringClass(targetClass);
        binding.setId(id);
        binding.setAttribute(att);
        this.bindings.add(binding);
    }

    private Set<String> getLocalStringKeys(Class<?> declaringClass) {
        ResourceBundle bundle = OMUtils.getLocalStringBundle(declaringClass);
        if (bundle == null) {
            return Collections.emptySet();
        }
        String classname = declaringClass.getName();
        String basename = classname.substring(classname.lastIndexOf(46) + 1);
        classname = classname + ".";
        basename = basename + ".";
        HashSet<String> keys = new HashSet<String>();
        Enumeration<String> e = bundle.getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            if (key.startsWith(classname)) {
                keys.add(key.substring(classname.length()));
                continue;
            }
            if (!key.startsWith(basename)) continue;
            keys.add(key.substring(basename.length()));
        }
        return keys;
    }

    private boolean isValidAttribute(String att) {
        return att.matches("[a-zA-Z][a-zA-Z0-9_]*") && !"label".equals(att) && !"description".equals(att);
    }

    @Override
    public void applyGlobal(FacesContext ctx, ModelBindingContext mbc) {
        String currentViewId = mbc.getViewId();
        for (Binding b : this.bindings) {
            if (!b.isMatchingView(currentViewId)) continue;
            b.applyGlobal(ctx, mbc);
        }
    }

    @Override
    public void applyModel(FacesContext ctx, ModelBindingContext mbc) {
        String viewId;
        String currentViewId = mbc.getViewId();
        if (mbc.getPhaseId().equals(PhaseId.RESTORE_VIEW) && (viewId = (String)ctx.getExternalContext().getRequestParameterMap().get("javax.faces.ViewId")) != null && ctx.getApplication().getViewHandler() instanceof ViewBuilder) {
            this.copyComponentState(ctx, mbc);
        }
        for (Binding b : this.bindings) {
            if (!b.isMatchingView(currentViewId)) continue;
            b.apply(ctx, mbc);
        }
    }

    private void copyComponentState(FacesContext ctx, ModelBindingContext mbc) {
        String currentViewId = mbc.getViewId();
        HashSet<UIComponent> copied = new HashSet<UIComponent>();
        for (Binding binding : this.bindings) {
            ELContext elctx;
            UIComponent comp;
            ValueBinding b;
            if (!binding.isMatchingView(currentViewId) || !(binding instanceof ValueBinding) || !"binding".equals((b = (ValueBinding)binding).getAttribute()) || (comp = mbc.getComponent(b.getId())) == null) continue;
            if (copied.contains(comp)) break;
            copied.add(comp);
            ModelBean bean = mbc.getModelBean();
            PropertyValueAdapter bindingVE = new PropertyValueAdapter(b, bean);
            UIComponent oldValue = (UIComponent)bindingVE.getValue(elctx = ctx.getELContext());
            if (oldValue == null || oldValue == comp) continue;
            comp.restoreState(ctx, oldValue.saveState(ctx));
        }
    }

    @Override
    public void applyDataModel(FacesContext ctx, ModelBindingContext mbc, UIData data) {
        String currentViewId = mbc.getViewId();
        if (this.bindings.size() == 0) {
            this.addBindingsFromBean(currentViewId);
        }
        for (Binding b : this.bindings) {
            if (!b.isMatchingView(currentViewId)) continue;
            b.applyDataItem(ctx, mbc, data);
        }
    }

    private void addBindingsFromBean(String currentViewId) {
        PropertyDescriptor[] pds = null;
        try {
            pds = Introspector.getBeanInfo(this.targetClass).getPropertyDescriptors();
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
        if (pds == null) {
            return;
        }
        for (PropertyDescriptor pd : pds) {
            if (pd.getReadMethod() == null) {
                if (!this.logger.isLoggable(Level.FINE)) continue;
                this.logger.fine(Resources._T("IOVC_MISSING_GETTER", this.targetClass.getSimpleName(), pd.getName()));
                continue;
            }
            ValueBinding b = new ValueBinding(currentViewId);
            b.init(Bind.class, this.targetClass, pd.getReadMethod());
            b.setId(pd.getName());
            b.setAttribute("value");
            this.bindings.add(b);
        }
    }

    @Override
    public void inject(FacesContext context, ModelBean bean) {
        if (!this.injectors.isEmpty()) {
            for (Injector b : this.injectors) {
                b.inject(context, bean);
            }
        }
    }

    @Override
    public void outject(FacesContext context, ModelBean bean) {
        if (!this.injectors.isEmpty()) {
            for (Injector b : this.injectors) {
                b.outject(context, bean);
            }
        }
    }
}

