/*
 * Decompiled with CFR 0.152.
 */
package org.operamasks.faces.binding.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.operamasks.faces.application.ViewMapper;
import org.operamasks.faces.application.impl.DefaultViewMapper;
import org.operamasks.faces.binding.ModelBean;
import org.operamasks.faces.binding.ModelBeanCreator;
import org.operamasks.faces.binding.ModelBinder;
import org.operamasks.faces.binding.ModelBindingContext;
import org.operamasks.faces.binding.ModelBindingFactory;
import org.operamasks.faces.binding.impl.ELiteBean;
import org.operamasks.faces.binding.impl.ELiteBeanCache;
import org.operamasks.faces.binding.impl.ModelBinderImpl;
import org.operamasks.faces.binding.impl.ModelBindingContextImpl;
import org.operamasks.faces.developer.util.FacesUtils;
import org.operamasks.faces.internal.stub.component.UseBeanStub;
import org.operamasks.util.SimpleCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelBindingFactoryImpl
extends ModelBindingFactory {
    private ViewMapper viewMapper;
    private ModelBeanCreator modelBeanCreator;
    private SimpleCache<String, ModelBinderImpl> cache = SimpleCache.make((int)200);
    private static final String MODEL_BEANS_ATTRIBUTE = "org.operamasks.faces.MODEL_BEANS-";
    private static final String ELITE_SCRIPT_PREFIX = "/WEB-INF/";

    protected ModelBindingFactoryImpl() {
        this.viewMapper = DefaultViewMapper.getInstance();
    }

    @Override
    public ViewMapper getViewMapper() {
        return this.viewMapper;
    }

    @Override
    public void setViewMapper(ViewMapper viewMapper) {
        if (viewMapper == null) {
            throw new NullPointerException();
        }
        this.viewMapper = viewMapper;
    }

    @Override
    public ModelBeanCreator getModelBeanCreator() {
        return this.modelBeanCreator;
    }

    @Override
    public void setModelBeanCreator(ModelBeanCreator creator) {
        this.modelBeanCreator = creator;
    }

    @Override
    public ModelBinder createBinder(Class targetClass) {
        String key = targetClass.getName();
        ModelBinderImpl result = (ModelBinderImpl)this.cache.get((Object)key);
        if (result == null || result.getTargetClass() != targetClass) {
            result = new ModelBinderImpl(targetClass);
            this.cache.put((Object)key, (Object)result);
        }
        return result;
    }

    @Override
    public ModelBindingContext createContext(PhaseId phaseId, String viewId, ModelBean[] modelBeans) {
        return new ModelBindingContextImpl(phaseId, viewId, modelBeans);
    }

    @Override
    public ModelBean[] getModelBeans(String viewId, UIComponent root) {
        List<String> beanList;
        if (viewId == null || root == null) {
            throw new NullPointerException();
        }
        FacesContext ctx = FacesContext.getCurrentInstance();
        ELContext elctx = ctx.getELContext();
        ArrayList<ModelBean> list = new ArrayList<ModelBean>();
        ELiteBean elbean = ELiteBean.make(elctx);
        if (elbean != null) {
            list.add(elbean);
        }
        if ((beanList = this.viewMapper.mapViewId(viewId = this.normalizeViewId(viewId))) != null) {
            for (String beanName : beanList) {
                ModelBean bean = null;
                if (FacesUtils.isValueExpression(beanName)) {
                    bean = ModelBean.wrap(FacesUtils.createValueExpression(beanName, Object.class));
                } else if (beanName.startsWith(ELITE_SCRIPT_PREFIX)) {
                    bean = ELiteBeanCache.getInstance().get(ctx, beanName);
                } else {
                    Object target = elctx.getELResolver().getValue(elctx, null, (Object)beanName);
                    if (elctx.isPropertyResolved() && target != null) {
                        bean = ModelBean.wrap(target);
                        bean.addName(beanName);
                    }
                }
                if (bean == null) continue;
                this.addModelBeanIntoList(list, bean);
            }
        }
        Iterator<UIComponent> iter = FacesUtils.createFacetsAndChildrenIterator(root, true);
        while (iter.hasNext()) {
            UIComponent comp = iter.next();
            if (!(comp instanceof UseBeanStub)) continue;
            for (ModelBean bean : ((UseBeanStub)comp).getBeans(true)) {
                this.addModelBeanIntoList(list, bean);
            }
        }
        ModelBean[] result = list.toArray(new ModelBean[list.size()]);
        Map requestMap = ctx.getExternalContext().getRequestMap();
        requestMap.put(MODEL_BEANS_ATTRIBUTE + viewId, result);
        return result;
    }

    @Override
    public ModelBean[] getModelBeans(String viewId) {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        return (ModelBean[])requestMap.get(MODEL_BEANS_ATTRIBUTE + viewId);
    }

    private void addModelBeanIntoList(List<ModelBean> list, ModelBean bean) {
        for (ModelBean exist : list) {
            if (!exist.equals(bean)) continue;
            exist.addNames(bean.getNames());
            return;
        }
        list.add(bean.clone());
    }

    private String normalizeViewId(String viewId) {
        viewId = viewId.replace("\\", "/");
        int pos = -1;
        while ((pos = viewId.indexOf("/../")) > 0) {
            String preSub = viewId.substring(0, pos);
            int pos2 = preSub.lastIndexOf("/");
            if (pos2 == -1) continue;
            viewId = viewId.substring(0, pos2) + viewId.substring(pos + 3);
        }
        return viewId;
    }
}

